/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.netbeans.jemmy.Timeout;
import org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.JSliderOperator;

public class JSliderAPIDriver
extends AbstractScrollDriver {
    private static final int SMALL_INCREMENT = 1;

    public JSliderAPIDriver() {
        super(new String[]{"org.netbeans.jemmy.operators.JSliderOperator"});
    }

    @Override
    protected int position(ComponentOperator oper, int orientation) {
        return ((JSliderOperator)oper).getValue();
    }

    @Override
    public void scrollToMinimum(ComponentOperator oper, int orientation) {
        ((JSliderOperator)oper).setValue(((JSliderOperator)oper).getMinimum());
    }

    @Override
    public void scrollToMaximum(ComponentOperator oper, int orientation) {
        ((JSliderOperator)oper).setValue(((JSliderOperator)oper).getMaximum());
    }

    @Override
    protected void step(ComponentOperator oper, ScrollAdjuster adj) {
        JSliderOperator scroll = (JSliderOperator)oper;
        int newValue = -1;
        if (adj.getScrollDirection() == -1) {
            newValue = scroll.getValue() > scroll.getMinimum() + this.getUnitIncrement(scroll) ? scroll.getValue() - this.getUnitIncrement(scroll) : scroll.getMinimum();
        } else if (adj.getScrollDirection() == 1) {
            newValue = scroll.getValue() < scroll.getMaximum() - this.getUnitIncrement(scroll) ? scroll.getValue() + this.getUnitIncrement(scroll) : scroll.getMaximum();
        }
        this.setValue(oper, newValue);
    }

    private void setValue(ComponentOperator oper, int value) {
        if (value != -1) {
            ((JSliderOperator)oper).setValue(value);
        }
    }

    @Override
    protected Timeout getScrollDeltaTimeout(ComponentOperator oper) {
        return oper.getTimeouts().create("JSliderOperator.ScrollingDelta");
    }

    @Override
    protected void jump(ComponentOperator oper, ScrollAdjuster adj) {
        JSliderOperator scroll = (JSliderOperator)oper;
        int newValue = -1;
        if (adj.getScrollDirection() == -1) {
            newValue = scroll.getValue() > scroll.getMinimum() + this.getBlockIncrement(scroll) ? scroll.getValue() - this.getBlockIncrement(scroll) : scroll.getMinimum();
        } else if (adj.getScrollDirection() == 1) {
            newValue = scroll.getValue() < scroll.getMaximum() - this.getBlockIncrement(scroll) ? scroll.getValue() + this.getBlockIncrement(scroll) : scroll.getMaximum();
        }
        this.setValue(oper, newValue);
    }

    @Override
    protected void startPushAndWait(ComponentOperator oper, int direction, int orientation) {
    }

    @Override
    protected void stopPushAndWait(ComponentOperator oper, int direction, int orientation) {
    }

    @Override
    protected Point startDragging(ComponentOperator oper) {
        return null;
    }

    @Override
    protected void drop(ComponentOperator oper, Point pnt) {
    }

    @Override
    protected void drag(ComponentOperator oper, Point pnt) {
    }

    @Override
    protected boolean canDragAndDrop(ComponentOperator oper) {
        return false;
    }

    @Override
    protected boolean canJump(ComponentOperator oper) {
        return this.isSmallIncrement((JSliderOperator)oper);
    }

    @Override
    protected boolean canPushAndWait(ComponentOperator oper) {
        return false;
    }

    @Override
    protected int getDragAndDropStepLength(ComponentOperator oper) {
        return 1;
    }

    private int getUnitIncrement(JSliderOperator oper) {
        return oper.getMinorTickSpacing() == 0 ? 1 : oper.getMinorTickSpacing();
    }

    private int getBlockIncrement(JSliderOperator oper) {
        return oper.getMajorTickSpacing() == 0 ? 1 : oper.getMajorTickSpacing();
    }

    private boolean isSmallIncrement(JSliderOperator oper) {
        return oper.getMajorTickSpacing() <= 1 && oper.getMajorTickSpacing() <= 1;
    }
}

