/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui.notifications;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.openide.util.ImageUtilities;

class BalloonManager {
    private static Balloon currentBalloon;
    private static JLayeredPane currentPane;
    private static ComponentListener listener;
    private static WindowStateListener windowListener;
    private static Window ownerWindow;

    BalloonManager() {
    }

    public static synchronized void show(JComponent jComponent, JComponent jComponent2, ActionListener actionListener, ActionListener actionListener2, int n) {
        assert (null != jComponent);
        assert (null != jComponent2);
        BalloonManager.dismiss();
        currentBalloon = new Balloon(jComponent2, actionListener, actionListener2, n);
        currentPane = JLayeredPane.getLayeredPaneAbove(jComponent);
        listener = new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
                BalloonManager.dismiss();
            }
        };
        windowListener = new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                BalloonManager.dismiss();
            }
        };
        ownerWindow = SwingUtilities.getWindowAncestor(jComponent);
        if (null != ownerWindow) {
            ownerWindow.addWindowStateListener(windowListener);
        }
        currentPane.addComponentListener(listener);
        BalloonManager.configureBalloon(currentBalloon, currentPane, jComponent);
        currentPane.add((Component)currentBalloon, new Integer(JLayeredPane.POPUP_LAYER - 1));
    }

    public static synchronized void dismiss() {
        if (null != currentBalloon) {
            currentBalloon.setVisible(false);
            currentBalloon.stopDismissTimer();
            currentPane.remove(currentBalloon);
            currentPane.repaint();
            currentPane.removeComponentListener(listener);
            if (null != ownerWindow) {
                ownerWindow.removeWindowStateListener(windowListener);
            }
            currentBalloon.content.removeMouseListener(currentBalloon.mouseListener);
            currentBalloon = null;
            currentPane = null;
            listener = null;
            ownerWindow = null;
            windowListener = null;
        }
    }

    public static synchronized void dismissSlowly(final int n) {
        if (null != currentBalloon) {
            if (currentBalloon.timeoutMillis > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (currentBalloon != null) {
                            currentBalloon.startDismissTimer(n);
                        }
                    }
                });
            } else {
                BalloonManager.dismiss();
            }
        }
    }

    public static synchronized void stopDismissSlowly() {
        if (null != currentBalloon && currentBalloon.timeoutMillis > 0) {
            currentBalloon.timeoutMillis = ToolTipManager.sharedInstance().getDismissDelay();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (currentBalloon != null) {
                        currentBalloon.stopDismissTimer();
                    }
                }
            });
        }
    }

    private static void configureBalloon(Balloon balloon, JLayeredPane jLayeredPane, JComponent jComponent) {
        Rectangle rectangle = jComponent.getBounds();
        rectangle = SwingUtilities.convertRectangle(jComponent.getParent(), rectangle, jLayeredPane);
        int n = jLayeredPane.getWidth();
        int n2 = jLayeredPane.getHeight();
        Dimension dimension = balloon.getPreferredSize();
        dimension.height += 15;
        if (rectangle.x + rectangle.width + dimension.width < n && rectangle.y + rectangle.height + dimension.height + 15 < n2) {
            balloon.setArrowLocation(14);
            balloon.setBounds(rectangle.x + rectangle.width - 7, rectangle.y + rectangle.height, dimension.width + 15, dimension.height);
        } else if (rectangle.x + rectangle.width + dimension.width < n && rectangle.y - dimension.height - 15 > 0) {
            balloon.setArrowLocation(12);
            balloon.setBounds(rectangle.x + rectangle.width - 7, rectangle.y - dimension.height, dimension.width + 15, dimension.height);
        } else if (rectangle.x - dimension.width > 0 && rectangle.y + rectangle.height + dimension.height + 15 < n2) {
            balloon.setArrowLocation(16);
            balloon.setBounds(rectangle.x - dimension.width + 7, rectangle.y + rectangle.height, dimension.width + 15, dimension.height);
        } else {
            balloon.setArrowLocation(18);
            balloon.setBounds(rectangle.x - dimension.width, rectangle.y - dimension.height, dimension.width + 15, dimension.height);
        }
    }

    static class DismissButton
    extends JButton {
        public DismissButton() {
            this.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/resources/dismiss_enabled.png", (boolean)true));
            this.setRolloverIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/resources/dismiss_rollover.png", (boolean)true));
            this.setPressedIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/core/ui/resources/dismiss_pressed.png", (boolean)true));
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setBorderPainted(false);
            this.setFocusable(false);
            this.setOpaque(false);
            this.setRolloverEnabled(true);
        }

        @Override
        public void paint(Graphics graphics) {
            Icon icon = null;
            icon = this.getModel().isArmed() && this.getModel().isPressed() ? this.getPressedIcon() : (this.getModel().isRollover() ? this.getRolloverIcon() : this.getIcon());
            icon.paintIcon(this, graphics, 0, 0);
        }
    }

    private static class Balloon
    extends JPanel {
        private static final int Y_OFFSET = 8;
        private static final int ARC = 15;
        private static final int SHADOW_SIZE = 3;
        private JComponent content;
        private MouseListener mouseListener;
        private ActionListener defaultAction;
        private JButton btnDismiss;
        private int arrowLocation = 14;
        private float currentAlpha = 1.0f;
        private Timer dismissTimer;
        private int timeoutMillis;
        private boolean isMouseOverEffect = false;
        private static final float ALPHA_DECREMENT = 0.03f;
        private static final int DISMISS_REPAINT_REPEAT = 100;
        private static Color mouseOverGradientStartColor = null;
        private static Color mouseOverGradientFinishColor = null;
        private static Color defaultGradientStartColor = null;
        private static Color defaultGradientFinishColor = null;
        private static final boolean isMetal = UIManager.getLookAndFeel() instanceof MetalLookAndFeel;
        private static final boolean isNimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());

        public Balloon(final JComponent jComponent, final ActionListener actionListener, ActionListener actionListener2, final int n) {
            super(new GridBagLayout());
            this.content = jComponent;
            this.defaultAction = actionListener;
            this.timeoutMillis = n;
            jComponent.setOpaque(false);
            this.btnDismiss = new DismissButton();
            this.btnDismiss.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    BalloonManager.dismiss();
                }
            });
            if (null != actionListener2) {
                this.btnDismiss.addActionListener(actionListener2);
            }
            this.add((Component)jComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.btnDismiss, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(7, 0, 0, 7), 0, 0));
            this.setOpaque(false);
            this.mouseListener = new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    BalloonManager.dismiss();
                    if (null != actionListener) {
                        actionListener.actionPerformed(new ActionEvent(this, 0, "", mouseEvent.getWhen(), mouseEvent.getModifiers()));
                    }
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    if (null != actionListener) {
                        jComponent.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this.stopDismissTimer();
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    jComponent.setCursor(Cursor.getDefaultCursor());
                    if (timeoutMillis > 0) {
                        this.startDismissTimer(ToolTipManager.sharedInstance().getDismissDelay());
                    }
                }
            };
            jComponent.addMouseListener(this.mouseListener);
            if (n > 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.startDismissTimer(n);
                    }
                });
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    isMouseOverEffect = true;
                    this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    isMouseOverEffect = false;
                    this.repaint();
                }
            };
            this.addMouseListener(mouseAdapter);
            jComponent.addMouseListener(mouseAdapter);
            this.btnDismiss.addMouseListener(mouseAdapter);
            this.handleMouseOver(jComponent, mouseAdapter);
        }

        private void handleMouseOver(Container container, MouseListener mouseListener) {
            container.addMouseListener(mouseListener);
            for (Component component : container.getComponents()) {
                component.addMouseListener(mouseListener);
                if (!(component instanceof Container)) continue;
                this.handleMouseOver((Container)component, mouseListener);
            }
        }

        synchronized void startDismissTimer(int n) {
            this.stopDismissTimer();
            this.currentAlpha = 1.0f;
            this.dismissTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    currentAlpha = currentAlpha - 0.03f;
                    if (currentAlpha <= 0.03f) {
                        this.stopDismissTimer();
                        BalloonManager.dismiss();
                    }
                    this.repaint();
                }
            });
            this.dismissTimer.setInitialDelay(n);
            this.dismissTimer.start();
        }

        synchronized void stopDismissTimer() {
            if (null != this.dismissTimer) {
                this.dismissTimer.stop();
                this.dismissTimer = null;
                this.currentAlpha = 1.0f;
            }
        }

        void setArrowLocation(int n) {
            this.arrowLocation = n;
            if (n == 12 || n == 18) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, this.btnDismiss.getWidth()));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, this.btnDismiss.getWidth()));
            }
        }

        private Shape getMask(int n, int n2) {
            --n;
            n -= 3;
            GeneralPath generalPath = new GeneralPath();
            Area area = null;
            switch (this.arrowLocation) {
                case 14: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 8.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(7.0f, 0.0f);
                    generalPath.lineTo(7.0f, 8.0f);
                    generalPath.lineTo(15.0f, 8.0f);
                    break;
                }
                case 12: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 3.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(7.0f, n2 - 1);
                    generalPath.lineTo(7.0f, n2 - 1 - 8);
                    generalPath.lineTo(15.0f, n2 - 1 - 8);
                    break;
                }
                case 16: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 8.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(n - 7, 0.0f);
                    generalPath.lineTo(n - 7, 8.0f);
                    generalPath.lineTo(n - 7 - 8, 8.0f);
                    break;
                }
                case 18: {
                    area = new Area(new RoundRectangle2D.Float(0.0f, 3.0f, n, n2 - 8 - 3, 15.0f, 15.0f));
                    generalPath.moveTo(n - 7, n2 - 1);
                    generalPath.lineTo(n - 7 - 8, n2 - 1 - 8);
                    generalPath.lineTo(n - 7, n2 - 1 - 8);
                }
            }
            generalPath.closePath();
            area.add(new Area(generalPath));
            return area;
        }

        private Shape getShadowMask(Shape shape) {
            Area area = new Area(shape);
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(3.0, 3.0);
            area.transform(affineTransform);
            area.subtract(new Area(shape));
            return area;
        }

        @Override
        protected void paintBorder(Graphics graphics) {
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite composite = graphics2D.getComposite();
            Shape shape = this.getMask(this.getWidth(), this.getHeight());
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.25f * this.currentAlpha));
            graphics2D.setColor(Color.black);
            graphics2D.fill(this.getShadowMask(shape));
            graphics2D.setColor(UIManager.getColor("ToolTip.background"));
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            Point point = shape.getBounds().getLocation();
            Point2D.Double double_ = new Point2D.Double(((Point2D)point).getX(), ((Point2D)point).getY() + shape.getBounds().getHeight());
            if (this.isMouseOverEffect) {
                graphics2D.setPaint(new GradientPaint(double_, Balloon.getMouseOverGradientStartColor(), point, Balloon.getMouseOverGradientFinishColor()));
            } else {
                graphics2D.setPaint(new GradientPaint(double_, Balloon.getDefaultGradientStartColor(), point, Balloon.getDefaultGradientFinishColor()));
            }
            graphics2D.fill(shape);
            graphics2D.setColor(Color.black);
            graphics2D.draw(shape);
            graphics2D.setComposite(composite);
        }

        @Override
        protected void paintChildren(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.currentAlpha));
            super.paintChildren(graphics);
            graphics2D.setComposite(composite);
        }

        private static Color getMouseOverGradientStartColor() {
            if (null == mouseOverGradientStartColor && null == (mouseOverGradientStartColor = UIManager.getColor("nb.core.ui.balloon.mouseOverGradientStartColor"))) {
                Color color;
                mouseOverGradientStartColor = new Color(224, 224, 185);
                if ((isMetal || isNimbus) && null != (color = UIManager.getColor("ToolTip.background"))) {
                    mouseOverGradientStartColor = color.darker();
                }
            }
            return mouseOverGradientStartColor;
        }

        private static Color getMouseOverGradientFinishColor() {
            if (null == mouseOverGradientFinishColor && null == (mouseOverGradientFinishColor = UIManager.getColor("nb.core.ui.balloon.mouseOverGradientFinishColor"))) {
                Color color;
                mouseOverGradientFinishColor = new Color(255, 255, 241);
                if ((isMetal || isNimbus) && null != (color = UIManager.getColor("ToolTip.background"))) {
                    mouseOverGradientFinishColor = color.brighter();
                }
            }
            return mouseOverGradientFinishColor;
        }

        private static Color getDefaultGradientStartColor() {
            if (null == defaultGradientStartColor && null == (defaultGradientStartColor = UIManager.getColor("nb.core.ui.balloon.defaultGradientStartColor"))) {
                Color color;
                defaultGradientStartColor = new Color(225, 225, 225);
                if ((isMetal || isNimbus) && null != (color = UIManager.getColor("ToolTip.background"))) {
                    defaultGradientStartColor = color.darker();
                }
            }
            return defaultGradientStartColor;
        }

        private static Color getDefaultGradientFinishColor() {
            if (null == defaultGradientFinishColor && null == (defaultGradientFinishColor = UIManager.getColor("nb.core.ui.balloon.defaultGradientFinishColor"))) {
                Color color;
                defaultGradientFinishColor = new Color(255, 255, 255);
                if ((isMetal || isNimbus) && null != (color = UIManager.getColor("ToolTip.background"))) {
                    defaultGradientFinishColor = color;
                }
            }
            return defaultGradientFinishColor;
        }
    }
}

