/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmType;
import org.jetbrains.kotlin.com.intellij.lang.jvm.types.JvmWildcardType;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiManager;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiTypes;
import org.jetbrains.kotlin.com.intellij.psi.TypeAnnotationProvider;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

public final class PsiWildcardType
extends PsiType.Stub
implements JvmWildcardType {
    public static final String EXTENDS_PREFIX = "? extends ";
    public static final String SUPER_PREFIX = "? super ";
    private static final Logger LOG = Logger.getInstance(PsiWildcardType.class);
    private static final Key<PsiWildcardType> UNBOUNDED_WILDCARD = new Key("UNBOUNDED_WILDCARD");
    private final PsiManager myManager;
    private final boolean myIsExtending;
    private final PsiType myBound;

    private PsiWildcardType(@NotNull PsiManager manager, boolean isExtending, @Nullable PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(0);
        }
        super(TypeAnnotationProvider.EMPTY);
        this.myManager = manager;
        this.myIsExtending = isExtending;
        this.myBound = bound;
    }

    @NotNull
    public static PsiWildcardType createUnbounded(@NotNull PsiManager manager) {
        PsiWildcardType unboundedWildcard;
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(1);
        }
        if ((unboundedWildcard = manager.getUserData(UNBOUNDED_WILDCARD)) == null) {
            unboundedWildcard = manager.putUserDataIfAbsent(UNBOUNDED_WILDCARD, new PsiWildcardType(manager, false, null));
        }
        PsiWildcardType psiWildcardType = unboundedWildcard;
        if (psiWildcardType == null) {
            PsiWildcardType.$$$reportNull$$$0(2);
        }
        return psiWildcardType;
    }

    @NotNull
    public static PsiWildcardType createExtends(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(3);
        }
        if (bound == null) {
            PsiWildcardType.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType) && bound != PsiTypes.nullType(), bound);
        return new PsiWildcardType(manager, true, bound);
    }

    @NotNull
    public static PsiWildcardType createSuper(@NotNull PsiManager manager, @NotNull PsiType bound) {
        if (manager == null) {
            PsiWildcardType.$$$reportNull$$$0(5);
        }
        if (bound == null) {
            PsiWildcardType.$$$reportNull$$$0(6);
        }
        LOG.assertTrue(!(bound instanceof PsiWildcardType) && bound != PsiTypes.nullType(), bound);
        return new PsiWildcardType(manager, false, bound);
    }

    @Override
    @NotNull
    public String getPresentableText(boolean annotated) {
        String string2 = this.getText(false, annotated, this.myBound == null ? null : this.myBound.getPresentableText(annotated));
        if (string2 == null) {
            PsiWildcardType.$$$reportNull$$$0(7);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getCanonicalText(boolean annotated) {
        String string2 = this.getText(true, annotated, this.myBound == null ? null : this.myBound.getCanonicalText(annotated));
        if (string2 == null) {
            PsiWildcardType.$$$reportNull$$$0(8);
        }
        return string2;
    }

    @Override
    @NotNull
    public String getInternalCanonicalText() {
        String string2 = this.getText(true, true, this.myBound == null ? null : this.myBound.getInternalCanonicalText());
        if (string2 == null) {
            PsiWildcardType.$$$reportNull$$$0(9);
        }
        return string2;
    }

    private String getText(boolean qualified, boolean annotated, @Nullable String suffix) {
        PsiAnnotation[] annotations2;
        PsiAnnotation[] psiAnnotationArray = annotations2 = annotated ? this.getAnnotations() : PsiAnnotation.EMPTY_ARRAY;
        if (annotations2.length == 0 && suffix == null) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        if (annotated) {
            PsiNameHelper.appendAnnotations(sb, annotations2, qualified);
        }
        if (suffix == null) {
            sb.append('?');
        } else {
            sb.append(this.myIsExtending ? EXTENDS_PREFIX : SUPER_PREFIX);
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    @NotNull
    public GlobalSearchScope getResolveScope() {
        GlobalSearchScope scope2;
        if (this.myBound != null && (scope2 = this.myBound.getResolveScope()) != null) {
            GlobalSearchScope globalSearchScope = scope2;
            if (globalSearchScope == null) {
                PsiWildcardType.$$$reportNull$$$0(10);
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(this.myManager.getProject());
        if (globalSearchScope == null) {
            PsiWildcardType.$$$reportNull$$$0(11);
        }
        return globalSearchScope;
    }

    @Override
    public PsiType @NotNull [] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{this.getExtendsBound()};
        if (psiTypeArray == null) {
            PsiWildcardType.$$$reportNull$$$0(12);
        }
        return psiTypeArray;
    }

    @Override
    public boolean equalsToText(@NotNull String text) {
        if (text == null) {
            PsiWildcardType.$$$reportNull$$$0(13);
        }
        if (this.myBound == null) {
            return "?".equals(text);
        }
        if (this.myIsExtending) {
            return text.startsWith(EXTENDS_PREFIX) && this.myBound.equalsToText(text.substring(EXTENDS_PREFIX.length()));
        }
        return text.startsWith(SUPER_PREFIX) && this.myBound.equalsToText(text.substring(SUPER_PREFIX.length()));
    }

    @NotNull
    public PsiManager getManager() {
        PsiManager psiManager = this.myManager;
        if (psiManager == null) {
            PsiWildcardType.$$$reportNull$$$0(14);
        }
        return psiManager;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PsiWildcardType)) {
            return false;
        }
        PsiWildcardType that = (PsiWildcardType)o;
        if (this.myBound == null && that.myBound != null) {
            return that.isExtends() && that.myBound.equalsToText("java.lang.Object");
        }
        if (this.myBound != null && that.myBound == null) {
            return this.isExtends() && this.myBound.equalsToText("java.lang.Object");
        }
        return this.myIsExtending == that.myIsExtending && Comparing.equal(this.myBound, that.myBound);
    }

    public int hashCode() {
        return (this.myIsExtending ? 1 : 0) + (this.myBound != null ? this.myBound.hashCode() : 0);
    }

    @Nullable
    public PsiType getBound() {
        return this.myBound;
    }

    @Override
    public <A> A accept(@NotNull PsiTypeVisitor<A> visitor2) {
        if (visitor2 == null) {
            PsiWildcardType.$$$reportNull$$$0(15);
        }
        return visitor2.visitWildcardType(this);
    }

    @Override
    public boolean isValid() {
        return this.myBound == null || this.myBound.isValid();
    }

    public boolean isExtends() {
        return this.myBound != null && this.myIsExtending;
    }

    public boolean isSuper() {
        return this.myBound != null && !this.myIsExtending;
    }

    public boolean isBounded() {
        return this.myBound != null;
    }

    @NotNull
    public PsiType getExtendsBound() {
        if (this.myBound == null || !this.myIsExtending) {
            PsiClassType psiClassType = PsiWildcardType.getJavaLangObject(this.myManager, this.getResolveScope());
            if (psiClassType == null) {
                PsiWildcardType.$$$reportNull$$$0(16);
            }
            return psiClassType;
        }
        PsiType psiType = this.myBound;
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(17);
        }
        return psiType;
    }

    @NotNull
    public PsiType getSuperBound() {
        PsiType psiType = this.myBound == null || this.myIsExtending ? (PsiPrimitiveType)PsiTypes.nullType() : this.myBound;
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(18);
        }
        return psiType;
    }

    @NotNull
    public JvmType upperBound() {
        PsiType psiType = this.getExtendsBound();
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(19);
        }
        return psiType;
    }

    @NotNull
    public JvmType lowerBound() {
        PsiType psiType = this.getSuperBound();
        if (psiType == null) {
            PsiWildcardType.$$$reportNull$$$0(20);
        }
        return psiType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bound";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/PsiWildcardType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnbounded";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalCanonicalText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolveScope";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getManager";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsBound";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperBound";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "upperBound";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "lowerBound";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUnbounded";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExtends";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createSuper";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "equalsToText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

