/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.management;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.initialization.resolve.MutableVersionCatalogContainer;
import org.gradle.api.internal.AbstractNamedDomainObjectContainer;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.catalog.DefaultVersionCatalogBuilder;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.code.UserCodeApplicationContext;
import org.gradle.internal.reflect.Instantiator;

public class DefaultVersionCatalogBuilderContainer
extends AbstractNamedDomainObjectContainer<VersionCatalogBuilder>
implements MutableVersionCatalogContainer {
    private static final String VALID_EXTENSION_NAME = "[a-z]([a-zA-Z0-9])+";
    private static final Pattern VALID_EXTENSION_PATTERN = Pattern.compile("[a-z]([a-zA-Z0-9])+");
    private final Interner<String> strings = Interners.newStrongInterner();
    private final Interner<ImmutableVersionConstraint> versions = Interners.newStrongInterner();
    private final Supplier<DependencyResolutionServices> dependencyResolutionServices;
    private final ObjectFactory objects;
    private final UserCodeApplicationContext context;

    @Inject
    public DefaultVersionCatalogBuilderContainer(Instantiator instantiator, CollectionCallbackActionDecorator callbackActionDecorator, ObjectFactory objects, UserCodeApplicationContext context, Supplier<DependencyResolutionServices> dependencyResolutionServices) {
        super(VersionCatalogBuilder.class, instantiator, callbackActionDecorator);
        this.objects = objects;
        this.context = context;
        this.dependencyResolutionServices = dependencyResolutionServices;
    }

    private static void validateName(String name) {
        if (!VALID_EXTENSION_PATTERN.matcher(name).matches()) {
            throw new InvalidUserDataException("Invalid model name '" + name + "': it must match the following regular expression: " + VALID_EXTENSION_NAME);
        }
    }

    public VersionCatalogBuilder create(String name, Action<? super VersionCatalogBuilder> configureAction) throws InvalidUserDataException {
        DefaultVersionCatalogBuilderContainer.validateName(name);
        return (VersionCatalogBuilder)super.create(name, model -> {
            UserCodeApplicationContext.Application current = this.context.current();
            DefaultVersionCatalogBuilder builder = (DefaultVersionCatalogBuilder)model;
            builder.withContext(current == null ? "Settings" : current.getSource().getDisplayName().getDisplayName(), () -> configureAction.execute(model));
        });
    }

    protected VersionCatalogBuilder doCreate(String name) {
        return (VersionCatalogBuilder)this.objects.newInstance(DefaultVersionCatalogBuilder.class, new Object[]{name, this.strings, this.versions, this.objects, this.dependencyResolutionServices});
    }

    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(MutableVersionCatalogContainer.class);
    }
}

