/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel.exit;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.channel.AbstractChannelRequestHandler;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.util.EventNotifier;
import org.apache.sshd.common.util.buffer.Buffer;

public abstract class AbstractChannelExitRequestHandler<V>
extends AbstractChannelRequestHandler
implements NamedResource {
    protected final AtomicReference<V> holder;
    protected final EventNotifier<? super String> notifier;

    protected AbstractChannelExitRequestHandler(AtomicReference<V> holder, EventNotifier<? super String> notifier) {
        this.holder = Objects.requireNonNull(holder, "No exit status holder");
        this.notifier = Objects.requireNonNull(notifier, "No event notifier");
    }

    @Override
    public RequestHandler.Result process(Channel channel, String request, boolean wantReply, Buffer buffer) throws Exception {
        V value;
        String name = this.getName();
        if (name.equals(request) && (value = this.processRequestValue(channel, request, buffer)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("process({})[{}] wantReply={}: {}", new Object[]{channel, request, wantReply, value});
            }
            this.holder.set(value);
            this.notifyStateChanged(channel, request, value);
            return RequestHandler.Result.ReplySuccess;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("process({}) wantReply={} ignore request={}", new Object[]{channel, wantReply, request});
        }
        return RequestHandler.Result.Unsupported;
    }

    protected abstract V processRequestValue(Channel var1, String var2, Buffer var3) throws Exception;

    protected void notifyStateChanged(Channel channel, String request, V value) {
        String event = this.getEvent(channel, request, value);
        try {
            this.notifier.notifyEvent((Object)event);
            if (this.log.isDebugEnabled()) {
                this.log.debug("notifyStateChanged({})[{}] event={}", new Object[]{channel, request, event});
            }
        }
        catch (Exception e) {
            this.warn("notifyStateChanged({})[{}] Failed ({}) to notify event={}: {}", channel, request, e.getClass().getSimpleName(), event, e.getMessage(), e);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException(e);
        }
    }

    protected String getEvent(Channel channel, String request, V value) {
        return this.getName();
    }
}

