/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.walkers;

import java.util.Stack;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import jlibs.core.graph.Navigator;
import jlibs.core.graph.Path;
import jlibs.core.graph.Sequence;
import jlibs.core.graph.Walker;
import jlibs.core.graph.WalkerUtil;
import jlibs.core.graph.sequences.AbstractSequence;
import jlibs.core.graph.sequences.DuplicateSequence;
import jlibs.core.graph.sequences.EmptySequence;
import jlibs.core.graph.sequences.EnumeratedSequence;

public class PreorderWalker<E>
extends AbstractSequence<E>
implements Walker<E> {
    private Sequence<? extends E> seq;
    private Navigator<E> navigator;
    private Stack<Children> stack = new Stack();
    private Path path;

    public PreorderWalker(Sequence<? extends E> seq, Navigator<E> navigator) {
        this.seq = seq;
        this.navigator = navigator;
        this._reset();
    }

    public PreorderWalker(E elem, Navigator<E> navigator) {
        this(new DuplicateSequence<E>(elem), navigator);
    }

    @Override
    public void reset() {
        super.reset();
        this._reset();
    }

    private void _reset() {
        this.path = null;
        this.stack.clear();
        this.stack.push(new Children(this.seq.copy()));
    }

    @Override
    public PreorderWalker<E> copy() {
        return new PreorderWalker<Sequence<? extends E>>(this.seq.copy(), this.navigator);
    }

    @Override
    protected E findNext() {
        while (!this.stack.isEmpty()) {
            Children elem = this.stack.peek();
            if (elem.seq.next() != null) break;
            if (elem.breakpoint) {
                return null;
            }
            this.stack.pop();
            if (this.path == null) continue;
            this.path = this.path.getParentPath();
        }
        if (this.stack.isEmpty()) {
            return null;
        }
        Sequence peekSeq = this.stack.peek().seq;
        Object current = peekSeq.current();
        this.path = this.path == null ? new Path(current) : this.path.append(current, peekSeq.index());
        this.path.lastElem = !peekSeq.hasNext();
        this.stack.push(new Children(this.navigator.children(current)));
        return current;
    }

    @Override
    public Path getCurrentPath() {
        return this.path;
    }

    @Override
    public void skip() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("can't skip of descendants of null");
        }
        this.stack.peek().seq = EmptySequence.getInstance();
    }

    @Override
    public void addBreakpoint() {
        if (this.stack.isEmpty()) {
            throw new IllegalStateException("can't add breakpoint on empty sequence");
        }
        this.stack.peek().breakpoint = true;
    }

    @Override
    public boolean isPaused() {
        return !this.stack.isEmpty() && this.stack.peek().breakpoint;
    }

    @Override
    public void resume() {
        if (this.isPaused()) {
            this.stack.peek().breakpoint = false;
            this.current.set(this.current.index() - 1, this.path.getElement());
        }
    }

    public static void main(String[] args) {
        Class<Number> c1 = Number.class;
        Class<Integer> c2 = Integer.class;
        System.out.println(c1.isAssignableFrom(c2));
        System.out.println(c1.isAssignableFrom(c2));
        JFrame frame = new JFrame();
        JTree tree = new JTree();
        frame.getContentPane().add(new JScrollPane(tree));
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        PreorderWalker<DefaultMutableTreeNode> seq = new PreorderWalker<DefaultMutableTreeNode>((DefaultMutableTreeNode)tree.getModel().getRoot(), new Navigator<DefaultMutableTreeNode>(){

            @Override
            public Sequence<DefaultMutableTreeNode> children(DefaultMutableTreeNode elem) {
                return new EnumeratedSequence<TreeNode>(elem.children());
            }
        });
        WalkerUtil.print(seq, null);
    }

    private class Children {
        boolean breakpoint;
        Sequence<? extends E> seq;

        public Children(Sequence<? extends E> seq) {
            this.seq = seq;
        }
    }
}

