/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.context;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;

public class DefaultContext
implements Context {
    private final ConcurrentMap<Object, Object> contextData = new ConcurrentHashMap<Object, Object>();
    private final AtomicBoolean readOnly = new AtomicBoolean(false);

    public DefaultContext() {
    }

    public DefaultContext(Map<Object, Object> contextData) {
        if (contextData == null) {
            throw new NullPointerException("contextData is null");
        }
        for (Map.Entry<Object, Object> entry : contextData.entrySet()) {
            Object key2 = entry.getKey();
            Object value = entry.getValue();
            if (key2 == null) {
                throw new IllegalArgumentException("Key is null");
            }
            if (value == null) continue;
            this.contextData.put(key2, value);
        }
    }

    @Override
    public boolean contains(Object key2) {
        Object data = this.contextData.get(key2);
        return data != null;
    }

    @Override
    public Object get(Object key2) throws ContextException {
        Object data = this.contextData.get(key2);
        if (data == null) {
            throw new ContextException("Unable to resolve context key: " + key2);
        }
        return data;
    }

    @Override
    public void put(Object key2, Object value) throws IllegalStateException {
        this.checkWriteable();
        if (key2 == null) {
            throw new IllegalArgumentException("Key is null");
        }
        if (value == null) {
            this.contextData.remove(key2);
        } else {
            this.contextData.put(key2, value);
        }
    }

    @Override
    public void hide(Object key2) throws IllegalStateException {
        this.checkWriteable();
        this.contextData.remove(key2);
    }

    @Override
    public Map<Object, Object> getContextData() {
        return Collections.unmodifiableMap(this.contextData);
    }

    @Override
    public void makeReadOnly() {
        this.readOnly.set(true);
    }

    protected void checkWriteable() throws IllegalStateException {
        if (this.readOnly.get()) {
            throw new IllegalStateException("Context is read only and can not be modified");
        }
    }

    public String toString() {
        return this.contextData.toString();
    }
}

