/*
 * Decompiled with CFR 0.152.
 */
package mill.util;

import java.io.Serializable;
import mill.moduledefs.Scaladoc;
import mill.util.SpanningForest$;
import os.Path;
import scala.Function1;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import ujson.Obj;

@Scaladoc(value="/**\n * Algorithm to compute the minimal spanning forest of a directed acyclic graph\n * that covers a particular subset of [[importantVertices]] (a \"Steiner Forest\"),\n * minimizing the maximum height of the resultant trees. When multiple solutions\n * exist with the same height, one chosen is arbitrarily. (This is much simpler\n * than the \"real\" algorithm which aims to minimize the sum of edge/vertex weights)\n *\n * Returns the forest as a [[Node]] structure with the top-level node containing\n * the roots of the forest\n */")
@ScalaSignature(bytes="\u0006\u0005\t\rtA\u0002\u0012$\u0011\u0003)sE\u0002\u0004*G!\u0005QE\u000b\u0005\u0006c\u0005!\ta\r\u0005\u0006i\u0005!\t!\u000e\u0005\u0006Q\u0006!\t!\u001b\u0005\b\u0003\u0013\tA\u0011AA\u0006\u0011\u001d\ty\"\u0001C\u0001\u0003C1a!a\u000b\u0002\u0001\u00065\u0002BCA\u001e\u000f\tU\r\u0011\"\u0001\u0002>!Q\u0011\u0011K\u0004\u0003\u0012\u0003\u0006I!a\u0010\t\rE:A\u0011AA*\u0011%\t9fBA\u0001\n\u0003\tI\u0006C\u0005\u0002^\u001d\t\n\u0011\"\u0001\u0002`!I\u0011QO\u0004\u0002\u0002\u0013\u0005\u0013q\u000f\u0005\n\u0003\u000f;\u0011\u0011!C\u0001\u0003\u0013C\u0011\"a#\b\u0003\u0003%\t!!$\t\u0013\u0005Mu!!A\u0005B\u0005U\u0005\"CAP\u000f\u0005\u0005I\u0011AAQ\u0011%\tYkBA\u0001\n\u0003\ni\u000bC\u0005\u00022\u001e\t\t\u0011\"\u0011\u00024\"I\u0011QW\u0004\u0002\u0002\u0013\u0005\u0013q\u0017\u0005\n\u0003s;\u0011\u0011!C!\u0003w;\u0011\"a1\u0002\u0003\u0003E\t!!2\u0007\u0013\u0005-\u0012!!A\t\u0002\u0005\u001d\u0007BB\u0019\u0018\t\u0003\ty\u000eC\u0005\u00026^\t\t\u0011\"\u0012\u00028\"I\u0011\u0011]\f\u0002\u0002\u0013\u0005\u00151\u001d\u0005\n\u0003O<\u0012\u0013!C\u0001\u0003?B\u0011\"!;\u0018\u0003\u0003%\t)a;\t\u0013\u0005]x#%A\u0005\u0002\u0005}\u0003\"CA}/\u0005\u0005I\u0011BA~\u0011\u001d\t\t/\u0001C\u0001\u0005\u0007AqA!\u0005\u0002\t\u0003\u0011\u0019\u0002C\u0004\u0003.\u0005!\tAa\f\u0002\u001dM\u0003\u0018M\u001c8j]\u001e4uN]3ti*\u0011A%J\u0001\u0005kRLGNC\u0001'\u0003\u0011i\u0017\u000e\u001c7\u0011\u0005!\nQ\"A\u0012\u0003\u001dM\u0003\u0018M\u001c8j]\u001e4uN]3tiN\u0011\u0011a\u000b\t\u0003Y=j\u0011!\f\u0006\u0002]\u0005)1oY1mC&\u0011\u0001'\f\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012aJ\u0001\u0012OJ\f\u0007\u000f['baR{\u0017J\u001c3jG\u0016\u001cXC\u0001\u001cH)\r9tK\u0019\t\u0005YaR4+\u0003\u0002:[\t1A+\u001e9mKJ\u0002Ba\u000f\"F!:\u0011A\b\u0011\t\u0003{5j\u0011A\u0010\u0006\u0003\u007fI\na\u0001\u0010:p_Rt\u0014BA!.\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0004\u001b\u0006\u0004(BA!.!\t1u\t\u0004\u0001\u0005\u000b!\u001b!\u0019A%\u0003\u0003Q\u000b\"AS'\u0011\u00051Z\u0015B\u0001'.\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\f(\n\u0005=k#aA!osB\u0011A&U\u0005\u0003%6\u00121!\u00138u!\raCKV\u0005\u0003+6\u0012Q!\u0011:sCf\u00042\u0001\f+Q\u0011\u0015A6\u00011\u0001Z\u0003!1XM\u001d;jG\u0016\u001c\bc\u0001.`\u000b:\u00111,\u0018\b\u0003{qK\u0011AL\u0005\u0003=6\nq\u0001]1dW\u0006<W-\u0003\u0002aC\nA\u0011\n^3sC\ndWM\u0003\u0002_[!)1m\u0001a\u0001I\u0006)Q\rZ4fgB!1HQ#f!\rQf-R\u0005\u0003O\u0006\u00141aU3r\u000359(/\u001b;f\u0015N|gNR5mKR)!.\\;xyB\u0011Af[\u0005\u0003Y6\u0012A!\u00168ji\")a\u000e\u0002a\u0001_\u0006!\u0001/\u0019;i!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018AA8t\u0013\t!\u0018O\u0001\u0003QCRD\u0007\"\u0002<\u0005\u0001\u0004\u0019\u0016AC5oI\u0016DX\tZ4fg\")\u0001\u0010\u0002a\u0001s\u0006\u0011\u0012N\u001c;fe\u0016\u001cH/\u001b8h\u0013:$\u0017nY3t!\rY$\u0010U\u0005\u0003w\u0012\u00131aU3u\u0011\u0015iH\u00011\u0001\u007f\u0003\u0019\u0011XM\u001c3feB)Af )\u0002\u0004%\u0019\u0011\u0011A\u0017\u0003\u0013\u0019+hn\u0019;j_:\f\u0004cA\u001e\u0002\u0006%\u0019\u0011q\u0001#\u0003\rM#(/\u001b8h\u0003%9(/\u001b;f\u0015N|g\u000e\u0006\u0005\u0002\u000e\u0005e\u00111DA\u000f!\u0011\ty!!\u0006\u000e\u0005\u0005E!BAA\n\u0003\u0015)(n]8o\u0013\u0011\t9\"!\u0005\u0003\u0007=\u0013'\u000eC\u0003w\u000b\u0001\u00071\u000bC\u0003y\u000b\u0001\u0007\u0011\u0010C\u0003~\u000b\u0001\u0007a0\u0001\fta\u0006tg.\u001b8h)J,W\rV8Kg>tGK]3f)\u0019\ti!a\t\u0002@\"9\u0011Q\u0005\u0004A\u0002\u0005\u001d\u0012\u0001\u00028pI\u0016\u00042!!\u000b\b\u001d\tA\u0003A\u0001\u0003O_\u0012,7CB\u0004,\u0003_\t)\u0004E\u0002-\u0003cI1!a\r.\u0005\u001d\u0001&o\u001c3vGR\u00042AWA\u001c\u0013\r\tI$\u0019\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007m\u0006dW/Z:\u0016\u0005\u0005}\u0002cBA!\u0003\u0017\u0002\u0016QJ\u0007\u0003\u0003\u0007RA!!\u0012\u0002H\u00059Q.\u001e;bE2,'bAA%[\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007\r\u000b\u0019\u0005E\u0002\u0002P\u001di\u0011!A\u0001\bm\u0006dW/Z:!)\u0011\ti%!\u0016\t\u0013\u0005m\"\u0002%AA\u0002\u0005}\u0012\u0001B2paf$B!!\u0014\u0002\\!I\u00111H\u0006\u0011\u0002\u0003\u0007\u0011qH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tG\u000b\u0003\u0002@\u0005\r4FAA3!\u0011\t9'!\u001d\u000e\u0005\u0005%$\u0002BA6\u0003[\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=T&\u0001\u0006b]:|G/\u0019;j_:LA!a\u001d\u0002j\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\b\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0007\u000bAA[1wC&!\u0011qAA?\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005\u0001\u0016A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004\u001b\u0006=\u0005\u0002CAI\u001f\u0005\u0005\t\u0019\u0001)\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t9\nE\u0003\u0002\u001a\u0006mU*\u0004\u0002\u0002H%!\u0011QTA$\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\r\u0016\u0011\u0016\t\u0004Y\u0005\u0015\u0016bAAT[\t9!i\\8mK\u0006t\u0007\u0002CAI#\u0005\u0005\t\u0019A'\u0002%A\u0014x\u000eZ;di\u0016cW-\\3oi:\u000bW.\u001a\u000b\u0005\u0003s\ny\u000b\u0003\u0005\u0002\u0012J\t\t\u00111\u0001Q\u0003!A\u0017m\u001d5D_\u0012,G#\u0001)\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001f\u0002\r\u0015\fX/\u00197t)\u0011\t\u0019+!0\t\u0011\u0005EU#!AA\u00025Ca!!1\u0007\u0001\u0004q\u0018!C:ue&tw-\u001b4z\u0003\u0011qu\u000eZ3\u0011\u0007\u0005=scE\u0003\u0018\u0003\u0013\f)\u000e\u0005\u0005\u0002L\u0006E\u0017qHA'\u001b\t\tiMC\u0002\u0002P6\nqA];oi&lW-\u0003\u0003\u0002T\u00065'!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocA!\u0011q[Ao\u001b\t\tIN\u0003\u0003\u0002\\\u0006\u0005\u0015AA5p\u0013\u0011\tI$!7\u0015\u0005\u0005\u0015\u0017!B1qa2LH\u0003BA'\u0003KD\u0011\"a\u000f\u001b!\u0003\u0005\r!a\u0010\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIE\nq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002n\u0006M\b#\u0002\u0017\u0002p\u0006}\u0012bAAy[\t1q\n\u001d;j_:D\u0011\"!>\u001d\u0003\u0003\u0005\r!!\u0014\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003{\u0004B!a\u001f\u0002\u0000&!!\u0011AA?\u0005\u0019y%M[3diRA\u0011Q\nB\u0003\u0005\u0013\u0011i\u0001\u0003\u0004\u0003\b}\u0001\raU\u0001\u0010S:$W\r_$sCBDW\tZ4fg\"1!1B\u0010A\u0002e\f\u0011#[7q_J$\u0018M\u001c;WKJ$\u0018nY3t\u0011\u001d\u0011ya\ba\u0001\u0003G\u000b\u0001\u0004\\5nSR$v.S7q_J$\u0018M\u001c;WKJ$\u0018nY3t\u00031\u0011'/Z1ei\"4\u0015N]:u+\u0011\u0011)B!\b\u0015\t\t]!\u0011\u0006\u000b\u0005\u00053\u0011y\u0002\u0005\u0003[M\nm\u0001c\u0001$\u0003\u001e\u0011)\u0001\n\tb\u0001\u0013\"11\r\ta\u0001\u0005C\u0001b\u0001L@\u0003\u001c\t\r\u0002#\u0002.\u0003&\tm\u0011b\u0001B\u0014C\na\u0011\n^3sC\ndWm\u00148dK\"9!1\u0006\u0011A\u0002\t\r\u0012!B:uCJ$\u0018\u0001\u0004:fm\u0016\u00148/Z#eO\u0016\u001cXC\u0002B\u0019\u0005\u0007\u00129\u0004\u0006\u0003\u00034\t\u0015\u0003CB\u001eC\u0005k\u0011Y\u0004E\u0002G\u0005o!aA!\u000f\"\u0005\u0004I%!\u0001,\u0011\u000bi\u0013iD!\u0011\n\u0007\t}\u0012M\u0001\u0004WK\u000e$xN\u001d\t\u0004\r\n\rC!\u0002%\"\u0005\u0004I\u0005BB2\"\u0001\u0004\u00119\u0005\u0005\u0003[?\n%\u0003C\u0002\u00179\u0005\u0003\u0012Y\u0005\u0005\u0003[?\nU\u0002fB\u0001\u0003P\tm#Q\f\t\u0005\u0005#\u00129&\u0004\u0002\u0003T)\u0019!QK\u0013\u0002\u00155|G-\u001e7fI\u001647/\u0003\u0003\u0003Z\tM#\u0001C*dC2\fGm\\2\u0002\u000bY\fG.^3\"\u0005\t}\u0013\u0001b\u00070U)R\u0001E\u000b\u0011BY\u001e|'/\u001b;i[\u0002\"x\u000eI2p[B,H/\u001a\u0011uQ\u0016\u0004S.\u001b8j[\u0006d\u0007e\u001d9b]:Lgn\u001a\u0011g_J,7\u000f\u001e\u0011pM\u0002\n\u0007\u0005Z5sK\u000e$X\r\u001a\u0011bGf\u001cG.[2!OJ\f\u0007\u000f\u001b\u0006!U\u0001\"\b.\u0019;!G>4XM]:!C\u0002\u0002\u0018M\u001d;jGVd\u0017M\u001d\u0011tk\n\u001cX\r\u001e\u0011pM\u0002Z6,[7q_J$\u0018M\u001c;WKJ$\u0018nY3t;v\u0003\u0003&\u0019\u0011#'R,\u0017N\\3sA\u0019{'/Z:uE%b#\u0002\t\u0016![&t\u0017.\\5{S:<\u0007\u0005\u001e5fA5\f\u00070[7v[\u0002BW-[4ii\u0002zg\r\t;iK\u0002\u0012Xm];mi\u0006tG\u000f\t;sK\u0016\u001ch\u0006I,iK:\u0004S.\u001e7uSBdW\rI:pYV$\u0018n\u001c8t\u0015\u0001R\u0003%\u001a=jgR\u0004s/\u001b;iAQDW\rI:b[\u0016\u0004\u0003.Z5hQRd\u0003e\u001c8fA\rDwn]3oA%\u001c\b%\u0019:cSR\u0014\u0018M]5ms:\u0002\u0003\u0006\u00165jg\u0002J7\u000fI7vG\"\u00043/[7qY\u0016\u0014(\u0002\t\u0016!i\"\fg\u000e\t;iK\u0002\u0012#/Z1mE\u0001\nGnZ8sSRDW\u000eI<iS\u000eD\u0007%Y5ng\u0002\"x\u000eI7j]&l\u0017N_3!i\",\u0007e];nA=4\u0007%\u001a3hK>2XM\u001d;fq\u0002:X-[4iiNL#\u0002\t\u0016\u000bA)\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0019|'/Z:uA\u0005\u001c\b%\u0019\u0011\\7:{G-Z/^AM$(/^2ukJ,\u0007e^5uQ\u0002\"\b.\u001a\u0011u_BlC.\u001a<fY\u0002rw\u000eZ3!G>tG/Y5oS:<'\u0002\t\u0016!i\",\u0007E]8piN\u0004sN\u001a\u0011uQ\u0016\u0004cm\u001c:fgRT\u0001EK\u0018)\u000f\u0001\u0011yEa\u0017\u0003^\u0001")
public final class SpanningForest {
    public static <T, V> Map<V, Vector<T>> reverseEdges(Iterable<Tuple2<T, Iterable<V>>> edges) {
        return SpanningForest$.MODULE$.reverseEdges(edges);
    }

    public static <T> Seq<T> breadthFirst(IterableOnce<T> start, Function1<T, IterableOnce<T>> edges) {
        return SpanningForest$.MODULE$.breadthFirst(start, edges);
    }

    public static Node apply(int[][] indexGraphEdges, Set<Object> importantVertices, boolean limitToImportantVertices) {
        return SpanningForest$.MODULE$.apply(indexGraphEdges, importantVertices, limitToImportantVertices);
    }

    public static Obj spanningTreeToJsonTree(Node node, Function1<Object, String> stringify) {
        return SpanningForest$.MODULE$.spanningTreeToJsonTree(node, stringify);
    }

    public static Obj writeJson(int[][] indexEdges, Set<Object> interestingIndices, Function1<Object, String> render) {
        return SpanningForest$.MODULE$.writeJson(indexEdges, interestingIndices, render);
    }

    public static void writeJsonFile(Path path, int[][] indexEdges, Set<Object> interestingIndices, Function1<Object, String> render) {
        SpanningForest$.MODULE$.writeJsonFile(path, indexEdges, interestingIndices, render);
    }

    public static <T> Tuple2<Map<T, Object>, int[][]> graphMapToIndices(Iterable<T> vertices, Map<T, Seq<T>> edges) {
        return SpanningForest$.MODULE$.graphMapToIndices(vertices, edges);
    }

    public static class Node
    implements Product,
    Serializable {
        private final scala.collection.mutable.Map<Object, Node> values;

        @Override
        public Iterator<String> productElementNames() {
            return Product.productElementNames$(this);
        }

        public scala.collection.mutable.Map<Object, Node> values() {
            return this.values;
        }

        public Node copy(scala.collection.mutable.Map<Object, Node> values2) {
            return new Node(values2);
        }

        public scala.collection.mutable.Map<Object, Node> copy$default$1() {
            return this.values();
        }

        @Override
        public String productPrefix() {
            return "Node";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.values();
                }
            }
            return Statics.ioobe(x$1);
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Node;
        }

        @Override
        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "values";
                }
            }
            return (String)Statics.ioobe(x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Node)) return false;
            boolean bl = true;
            if (!bl) return false;
            Node node = (Node)x$1;
            scala.collection.mutable.Map<Object, Node> map = this.values();
            scala.collection.mutable.Map<Object, Node> map2 = node.values();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            if (!node.canEqual(this)) return false;
            return true;
        }

        public Node(scala.collection.mutable.Map<Object, Node> values2) {
            this.values = values2;
            Product.$init$(this);
        }
    }
}

