/*
 * Decompiled with CFR 0.152.
 */
package mill.runner.client;

import io.github.alexarchambault.windowsansi.WindowsAnsi;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import mill.main.client.OutFiles;
import mill.main.client.Util;
import mill.runner.client.CoursierClient;

public class MillProcessLauncher {
    private static AtomicReference<String> memoizedTerminalDims = new AtomicReference();

    static int launchMillNoServer(String[] stringArray) throws Exception {
        boolean bl = System.getProperty("jna.nosys") == null;
        String string = String.format("%08x", UUID.randomUUID().hashCode());
        Path path2 = Paths.get(".", new String[0]).resolve(OutFiles.out).resolve("mill-no-server").resolve(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(MillProcessLauncher.millLaunchJvmCommand(bl));
        arrayList.add("mill.runner.MillMain");
        arrayList.add(path2.toAbsolutePath().toString());
        arrayList.addAll(Util.readOptsFileLines(MillProcessLauncher.millOptsFile()));
        arrayList.addAll(Arrays.asList(stringArray));
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(arrayList).inheritIO();
        boolean bl2 = false;
        try {
            MillProcessLauncher.prepareMillRunFolder(path2);
            Process process = MillProcessLauncher.configureRunMillProcess(processBuilder, path2);
            int n = process.waitFor();
            return n;
        }
        catch (InterruptedException interruptedException) {
            bl2 = true;
            throw interruptedException;
        }
        finally {
            if (!bl2) {
                Files.walk(path2, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> path.toFile().delete());
            }
        }
    }

    static void launchMillServer(Path path, boolean bl) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(MillProcessLauncher.millLaunchJvmCommand(bl));
        arrayList.add("mill.runner.MillServerMain");
        arrayList.add(path.toFile().getCanonicalPath());
        ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command(arrayList).redirectOutput(path.resolve("stdout").toFile()).redirectError(path.resolve("stderr").toFile());
        MillProcessLauncher.configureRunMillProcess(processBuilder, path);
    }

    static Process configureRunMillProcess(ProcessBuilder processBuilder, Path path) throws Exception {
        Path path2 = path.resolve("sandbox");
        Files.createDirectories(path2, new FileAttribute[0]);
        processBuilder.environment().put("MILL_WORKSPACE_ROOT", new File("").getCanonicalPath());
        processBuilder.directory(path2.toFile());
        return processBuilder.start();
    }

    static Path millJvmVersionFile() {
        String string = System.getenv("MILL_JVM_VERSION_PATH");
        if (string == null || string.trim().equals("")) {
            string = ".mill-jvm-version";
        }
        return Paths.get(string, new String[0]).toAbsolutePath();
    }

    static Path millJvmOptsFile() {
        String string = System.getenv("MILL_JVM_OPTS_PATH");
        if (string == null || string.trim().equals("")) {
            string = ".mill-jvm-opts";
        }
        return Paths.get(string, new String[0]).toAbsolutePath();
    }

    static Path millOptsFile() {
        String string = System.getenv("MILL_OPTS_PATH");
        if (string == null || string.trim().equals("")) {
            string = ".mill-opts";
        }
        return Paths.get(string, new String[0]).toAbsolutePath();
    }

    static boolean millJvmOptsAlreadyApplied() {
        String string = System.getProperty("mill.jvm_opts_applied");
        return string != null && string.equals("true");
    }

    static String millServerTimeout() {
        return System.getenv("MILL_SERVER_TIMEOUT_MILLIS");
    }

    static boolean isWin() {
        return System.getProperty("os.name", "").startsWith("Windows");
    }

    static String javaHome() throws IOException {
        Path path = MillProcessLauncher.millJvmVersionFile();
        String string = null;
        if (Files.exists(path, new LinkOption[0])) {
            String string2 = Files.readString(path).trim();
            string = CoursierClient.resolveJavaHome(string2).getAbsolutePath();
        }
        if (string == null || string.isEmpty()) {
            string = System.getProperty("java.home");
        }
        if (string == null || string.isEmpty()) {
            string = System.getenv("JAVA_HOME");
        }
        return string;
    }

    static String javaExe() throws IOException {
        String string = MillProcessLauncher.javaHome();
        if (string == null) {
            return "java";
        }
        Path path = Paths.get(string + File.separator + "bin" + File.separator + "java" + (MillProcessLauncher.isWin() ? ".exe" : ""), new String[0]);
        return path.toAbsolutePath().toString();
    }

    static String[] millClasspath() throws Exception {
        String[] stringArray;
        String string = "";
        LinkedList linkedList = new LinkedList();
        String string2 = System.getProperty("MILL_OPTIONS_PATH");
        if (string2 != null) {
            stringArray = new Properties();
            try (InputStream inputStream = Files.newInputStream(Paths.get(string2, new String[0]), new OpenOption[0]);){
                stringArray.load(inputStream);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Could not load '" + string2 + "'", iOException);
            }
            for (String string3 : stringArray.stringPropertyNames()) {
                String string4 = stringArray.getProperty(string3);
                if (!"MILL_CLASSPATH".equals(string3)) continue;
                string = string4;
            }
        } else {
            string = System.getProperty("MILL_CLASSPATH");
        }
        if (string == null || string.trim().isEmpty()) {
            string = System.getProperty("java.class.path").replace(File.pathSeparator, ",");
        }
        if (string == null || string.trim().isEmpty()) {
            string = MillProcessLauncher.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        }
        if (string == null || string.trim().isEmpty()) {
            throw new RuntimeException("MILL_CLASSPATH is empty!");
        }
        stringArray = string.split("[,]");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = new File(stringArray[i]).getCanonicalPath();
        }
        return stringArray;
    }

    static List<String> millLaunchJvmCommand(boolean bl) throws Exception {
        Path path;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(MillProcessLauncher.javaExe());
        if (bl) {
            arrayList.add("-Djna.nosys=true");
        }
        Properties properties = System.getProperties();
        for (String object2 : properties.stringPropertyNames()) {
            if (!object2.startsWith("MILL_") || "MILL_CLASSPATH".equals(object2)) continue;
            arrayList.add("-D" + object2 + "=" + properties.getProperty(object2));
        }
        String string = MillProcessLauncher.millServerTimeout();
        if (string != null) {
            arrayList.add("-Dmill.server_timeout=" + (String)string);
        }
        if (Files.exists(path = MillProcessLauncher.millJvmOptsFile(), new LinkOption[0])) {
            arrayList.addAll(Util.readOptsFileLines(path));
        }
        arrayList.add("-XX:+HeapDumpOnOutOfMemoryError");
        arrayList.add("-cp");
        arrayList.add(String.join((CharSequence)File.pathSeparator, MillProcessLauncher.millClasspath()));
        return arrayList;
    }

    static List<String> readMillJvmOpts() throws Exception {
        return Util.readOptsFileLines(MillProcessLauncher.millJvmOptsFile());
    }

    static int getTerminalDim(String string, boolean bl) throws Exception {
        Process process = new ProcessBuilder(new String[0]).command("tput", string).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectInput(ProcessBuilder.Redirect.INHERIT).redirectError(bl ? ProcessBuilder.Redirect.INHERIT : ProcessBuilder.Redirect.PIPE).start();
        int n = process.waitFor();
        if (n != 0) {
            throw new Exception("tput failed");
        }
        return Integer.parseInt(new String(process.getInputStream().readAllBytes()).trim());
    }

    static void writeTerminalDims(boolean bl, Path path) throws Exception {
        Object object;
        String string;
        try {
            if (System.console() == null) {
                string = "0 0";
            } else if (MillProcessLauncher.isWin()) {
                object = WindowsAnsi.terminalSize();
                int n = ((WindowsAnsi.Size)object).getWidth();
                int n2 = ((WindowsAnsi.Size)object).getHeight();
                string = n + " " + n2;
            } else {
                string = !bl ? "78 24" : MillProcessLauncher.getTerminalDim("cols", true) + " " + MillProcessLauncher.getTerminalDim("lines", true);
            }
        }
        catch (Exception exception) {
            string = "0 0";
        }
        object = memoizedTerminalDims.getAndSet(string);
        if (object == null || !((String)object).equals(string)) {
            Files.write(path.resolve("terminfo"), string.getBytes(), new OpenOption[0]);
        }
    }

    public static boolean checkTputExists() {
        try {
            MillProcessLauncher.getTerminalDim("cols", false);
            MillProcessLauncher.getTerminalDim("lines", false);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void prepareMillRunFolder(Path path) throws Exception {
        Files.deleteIfExists(path.resolve("exitCode"));
        Files.deleteIfExists(path.resolve("terminfo"));
        Files.deleteIfExists(path.resolve("runArgs"));
        Path path2 = path.resolve("sandbox");
        Files.createDirectories(path2, new FileAttribute[0]);
        boolean bl = MillProcessLauncher.checkTputExists();
        MillProcessLauncher.writeTerminalDims(bl, path);
        Thread thread = new Thread(() -> {
            try {
                while (true) {
                    MillProcessLauncher.writeTerminalDims(bl, path);
                    Thread.sleep(100L);
                }
            }
            catch (Exception exception) {
                return;
            }
        }, "TermInfoPropagatorThread");
        thread.start();
    }
}

