/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.engine.Rasterizer;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.function.Consumer;
import javax.imageio.ImageIO;

public class Renderer {
    private static final Consumer<Graphics2D> NOP_GRAPHICS_CONFIGURER = Graphics2D2 -> {};
    private final Graphviz graphviz;
    private final Consumer<Graphics2D> graphicsConfigurer;
    private final Format output;

    Renderer(Graphviz graphviz, Format output) {
        this(graphviz, NOP_GRAPHICS_CONFIGURER, output);
    }

    Renderer(Graphviz graphviz, Consumer<Graphics2D> graphicsConfigurer, Format output) {
        this.graphviz = graphviz;
        this.graphicsConfigurer = graphicsConfigurer;
        this.output = output;
    }

    public Renderer withGraphics(Consumer<Graphics2D> graphicsConfigurer) {
        return new Renderer(this.graphviz, graphicsConfigurer, this.output);
    }

    public String toString() {
        return this.execute().map(file -> {
            throw new IllegalArgumentException("Expected a String result, but found a File. Use toFile / toImage instead of toString or use a different Rasterizer (not the built-in).");
        }, string -> string);
    }

    public File toFile(File file) throws IOException {
        return this.execute().mapIO(fileRes -> this.toFile((File)fileRes, file), string -> this.toFile((String)string, file));
    }

    private File toFile(File source, File target) throws IOException {
        File out = this.withExt(target, this.getExt(source));
        Files.createDirectories(target.getAbsoluteFile().getParentFile().toPath(), new FileAttribute[0]);
        Files.copy(source.toPath(), out.toPath(), StandardCopyOption.REPLACE_EXISTING);
        return out;
    }

    private File toFile(String content, File file) throws IOException {
        File target = this.withExt(file, this.output.fileExtension);
        Files.createDirectories(file.getAbsoluteFile().getParentFile().toPath(), new FileAttribute[0]);
        if (this.output.image) {
            this.writeToFile(target, this.output.name().toLowerCase(Locale.ENGLISH), this.toImage(content));
        } else {
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(target), StandardCharsets.UTF_8);){
                out.write(content);
            }
        }
        return target;
    }

    private File withExt(File file, String ext) {
        return file.getName().contains(".") ? file : new File(file.getParentFile(), file.getName() + "." + ext);
    }

    private String getExt(File file) {
        return file.getName().substring(file.getName().lastIndexOf(46) + 1);
    }

    public void toOutputStream(OutputStream outputStream) throws IOException {
        this.execute().mapIO(file -> Files.copy(file.toPath(), outputStream), string -> this.toOutputStream((String)string, outputStream));
    }

    private long toOutputStream(String content, OutputStream outputStream) throws IOException {
        if (this.output.image) {
            this.writeToOutputStream(outputStream, this.output.name().toLowerCase(Locale.ENGLISH), this.toImage(content));
        } else {
            try (OutputStreamWriter out = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);){
                out.write(content);
            }
        }
        return 0L;
    }

    public BufferedImage toImage() {
        return this.toImage(this.execute());
    }

    private BufferedImage toImage(EngineResult result2) {
        return result2.map(this::toImage, this::toImage);
    }

    private BufferedImage toImage(String content) {
        if (this.graphviz.rasterizer == Rasterizer.NONE) {
            throw new IllegalStateException("- Rasterizer explicitly set no null or\n- neither 'guru.nidi.com.kitfox:svgSalamander' nor 'org.apache.xmlgraphics:batik-rasterizer' found on classpath.");
        }
        return this.graphviz.rasterizer.rasterize(this.graphviz, this.graphicsConfigurer, content);
    }

    private BufferedImage toImage(File file) {
        try {
            BufferedImage image = ImageIO.read(file);
            if (image == null) {
                throw new IllegalArgumentException("Could not convert the resulting file into an Image");
            }
            return image;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not convert the resulting file into an Image", e);
        }
    }

    private EngineResult execute() {
        return this.graphviz.execute();
    }

    private void writeToFile(File output, String format, BufferedImage img) {
        try {
            ImageIO.write((RenderedImage)img, format, output);
        }
        catch (IOException e) {
            throw new GraphvizException("Problem writing to file", e);
        }
    }

    private void writeToOutputStream(OutputStream outputStream, String format, BufferedImage img) {
        try (OutputStream closing = outputStream;){
            ImageIO.write((RenderedImage)img, format, closing);
        }
        catch (IOException e) {
            throw new GraphvizException("Problem writing to output stream", e);
        }
    }
}

