/*
 * Decompiled with CFR 0.152.
 */
package coursier.cache;

import coursier.cache.CacheDefaults$;
import coursier.cache.CacheLocks$;
import coursier.cache.DigestArtifact;
import coursier.cache.DigestBasedCache$;
import coursier.cache.internal.Retry;
import coursier.util.Sync;
import coursier.util.Task;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\u0005Eg\u0001B\u0010!\u0005\u0015B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t!\u0010\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005}!A\u0011\n\u0001BC\u0002\u0013\u0005!\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003L\u0011!\u0011\u0006A!b\u0001\n\u0007\u0019\u0006\u0002\u00035\u0001\u0005\u0003\u0005\u000b\u0011\u0002+\t\u000b%\u0004A\u0011\u00016\t\u000b%\u0004A\u0011A9\t\u000bU\u0004A\u0011\u0002<\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0005\b\u0003G\u0001A\u0011AA\u0013\u0011\u001d\tI\u0003\u0001C\u0001\u0003WAq!a\f\u0001\t\u0003\n\t\u0004C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u0005-\u0003\u0001\"\u0011\u0002N!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA.\u0001\u0011%\u0011Q\f\u0005\b\u0003K\u0002A\u0011IA4\u0011\u001d\tI\u0007\u0001C!\u0003WBq!!\u001c\u0001\t\u0003\ny\u0007C\u0004\u0002v\u0001!\t%a\u001e\b\u000f\u0005m\u0004\u0005#\u0001\u0002~\u00191q\u0004\tE\u0001\u0003\u007fBa![\r\u0005\u0002\u0005-\u0005bBAG3\u0011\u0005\u0011q\u0012\u0005\b\u0003\u001bKB\u0011AAM\u0011\u001d\ti)\u0007C\u0001\u0003_C\u0011\"a2\u001a\u0003\u0003%I!!3\u0003!\u0011Kw-Z:u\u0005\u0006\u001cX\rZ\"bG\",'BA\u0011#\u0003\u0015\u0019\u0017m\u00195f\u0015\u0005\u0019\u0013\u0001C2pkJ\u001c\u0018.\u001a:\u0004\u0001U\u0011a\u0005X\n\u0005\u0001\u001dj\u0003\u0007\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003Q9J!aL\u0015\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011'\u000f\b\u0003e]r!a\r\u001c\u000e\u0003QR!!\u000e\u0013\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0013B\u0001\u001d*\u0003\u001d\u0001\u0018mY6bO\u0016L!AO\u001e\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005aJ\u0013\u0001\u00037pG\u0006$\u0018n\u001c8\u0016\u0003y\u0002\"a\u0010$\u000e\u0003\u0001S!!\u0011\"\u0002\t\u0019LG.\u001a\u0006\u0003\u0007\u0012\u000b1A\\5p\u0015\u0005)\u0015\u0001\u00026bm\u0006L!a\u0012!\u0003\tA\u000bG\u000f[\u0001\nY>\u001c\u0017\r^5p]\u0002\nQA]3uef,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0002\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003!6\u0013QAU3uef\faA]3uef\u0004\u0013\u0001B:z]\u000e,\u0012\u0001\u0016\t\u0004+bSV\"\u0001,\u000b\u0005]\u0013\u0013\u0001B;uS2L!!\u0017,\u0003\tMKhn\u0019\t\u00037rc\u0001\u0001B\u0003^\u0001\t\u0007aLA\u0001G+\tyf-\u0005\u0002aGB\u0011\u0001&Y\u0005\u0003E&\u0012qAT8uQ&tw\r\u0005\u0002)I&\u0011Q-\u000b\u0002\u0004\u0003:LH!B4]\u0005\u0004y&\u0001B0%IE\nQa]=oG\u0002\na\u0001P5oSRtDcA6paR\u0011AN\u001c\t\u0004[\u0002QV\"\u0001\u0011\t\u000bI;\u00019\u0001+\t\u000bq:\u0001\u0019\u0001 \t\u000b%;\u0001\u0019A&\u0015\u0005I$HC\u00017t\u0011\u0015\u0011\u0006\u0002q\u0001U\u0011\u0015a\u0004\u00021\u0001?\u0003\u001d\u0001\u0018\r\u001e5G_J$\"AP<\t\u000baL\u0001\u0019A=\u0002\r\u0011Lw-Z:u!\tQhP\u0004\u0002|yB\u00111'K\u0005\u0003{&\na\u0001\u0015:fI\u00164\u0017bA@\u0002\u0002\t11\u000b\u001e:j]\u001eT!!`\u0015\u0002\r%l\u0007o\u001c:u)\rq\u0014q\u0001\u0005\b\u0003\u0013Q\u0001\u0019AA\u0006\u0003!\t'\u000f^5gC\u000e$\bcA7\u0002\u000e%\u0019\u0011q\u0002\u0011\u0003\u001d\u0011Kw-Z:u\u0003J$\u0018NZ1di\u0006\u0019q-\u001a;\u0015\t\u0005U\u00111\u0004\t\u0005Q\u0005]a(C\u0002\u0002\u001a%\u0012aa\u00149uS>t\u0007\"\u0002=\f\u0001\u0004I\u0018\u0001D<ji\"dunY1uS>tGc\u00017\u0002\"!)A\b\u0004a\u0001}\u0005Iq/\u001b;i%\u0016$(/\u001f\u000b\u0004Y\u0006\u001d\u0002\"B%\u000e\u0001\u0004Y\u0015\u0001C<ji\"\u001c\u0016P\\2\u0015\u00071\fi\u0003C\u0003S\u001d\u0001\u0007A+\u0001\u0005u_N#(/\u001b8h)\t\t\u0019\u0004\u0005\u0003\u00026\u0005mRBAA\u001c\u0015\r\tI\u0004R\u0001\u0005Y\u0006tw-C\u0002\u0000\u0003o\t\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0003\n9\u0005E\u0002)\u0003\u0007J1!!\u0012*\u0005\u001d\u0011un\u001c7fC:Da!!\u0013\u0011\u0001\u0004\u0019\u0017aA8cU\u00061Q-];bYN$B!!\u0011\u0002P!1\u0011\u0011J\tA\u0002\r\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003+\u00022\u0001KA,\u0013\r\tI&\u000b\u0002\u0004\u0013:$\u0018!\u0002;va2,WCAA0!\u0019A\u0013\u0011\r L)&\u0019\u00111M\u0015\u0003\rQ+\b\u000f\\34\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u00111G\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003+\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002d\u0003cBq!a\u001d\u0017\u0001\u0004\t)&A\u0001o\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005M\u0012\u0011\u0010\u0005\b\u0003g:\u0002\u0019AA+\u0003A!\u0015nZ3ti\n\u000b7/\u001a3DC\u000eDW\r\u0005\u0002n3M!\u0011dJAA!\u0011\t\u0019)!#\u000e\u0005\u0005\u0015%bAAD\t\u0006\u0011\u0011n\\\u0005\u0004u\u0005\u0015ECAA?\u0003\u0015\t\u0007\u000f\u001d7z)\t\t\t\n\u0005\u0003n\u0001\u0005M\u0005cA+\u0002\u0016&\u0019\u0011q\u0013,\u0003\tQ\u000b7o[\u000b\u0005\u00037\u000b\u0019\u000b\u0006\u0003\u0002\u001e\u00065F\u0003BAP\u0003S\u0003B!\u001c\u0001\u0002\"B\u00191,a)\u0005\ruc\"\u0019AAS+\ry\u0016q\u0015\u0003\u0007O\u0006\r&\u0019A0\t\rIc\u00029AAV!\u0011)\u0006,!)\t\u000bqb\u0002\u0019\u0001 \u0016\t\u0005E\u0016\u0011\u0018\u000b\u0007\u0003g\u000b\u0019-!2\u0015\t\u0005U\u0016q\u0018\t\u0005[\u0002\t9\fE\u0002\\\u0003s#a!X\u000fC\u0002\u0005mVcA0\u0002>\u00121q-!/C\u0002}CaAU\u000fA\u0004\u0005\u0005\u0007\u0003B+Y\u0003oCQ\u0001P\u000fA\u0002yBQ!S\u000fA\u0002-\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a3\u0011\t\u0005U\u0012QZ\u0005\u0005\u0003\u001f\f9D\u0001\u0004PE*,7\r\u001e")
public final class DigestBasedCache<F>
implements Product,
Serializable {
    private final Path location;
    private final Retry retry;
    private final Sync<F> sync;

    public static <F> DigestBasedCache<F> apply(Path location, Retry retry, Sync<F> sync) {
        return DigestBasedCache$.MODULE$.apply(location, retry, sync);
    }

    public static <F> DigestBasedCache<F> apply(Path location, Sync<F> sync) {
        return DigestBasedCache$.MODULE$.apply(location, sync);
    }

    public static DigestBasedCache<Task> apply() {
        return DigestBasedCache$.MODULE$.apply();
    }

    @Override
    public Iterator<Object> productIterator() {
        return Product.productIterator$(this);
    }

    @Override
    public Iterator<String> productElementNames() {
        return Product.productElementNames$(this);
    }

    public Path location() {
        return this.location;
    }

    public Retry retry() {
        return this.retry;
    }

    public Sync<F> sync() {
        return this.sync;
    }

    private Path pathFor(String digest) {
        Predef$.MODULE$.assert(digest.length() > 2);
        return this.location().resolve(new StringBuilder(1).append(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(digest), 2)).append("/").append(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(digest), 2)).toString());
    }

    public Path import(DigestArtifact artifact) {
        Path path = this.pathFor(artifact.digest());
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return (Path)CacheLocks$.MODULE$.withLockOr(this.location().toFile(), path.toFile(), this.retry(), (Function0<Path> & Serializable)() -> {
            Object object;
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Path tmpPath = path.getParent().resolve(new StringBuilder(5).append(".").append(((Object)path.getFileName()).toString()).append(".tmp").toString());
                try {
                    Files.deleteIfExists(tmpPath);
                    Files.copy(artifact.path(), tmpPath, new CopyOption[0]);
                    object = Files.move(tmpPath, path, StandardCopyOption.ATOMIC_MOVE);
                }
                finally {
                    Files.deleteIfExists(tmpPath);
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            return path;
        }, (Function0<None$> & Serializable)() -> None$.MODULE$);
    }

    public Option<Path> get(String digest) {
        Path path = this.pathFor(digest);
        if (Files.exists(path, new LinkOption[0])) {
            return new Some<Path>(path);
        }
        return None$.MODULE$;
    }

    public DigestBasedCache<F> withLocation(Path location) {
        return new DigestBasedCache<F>(location, this.retry(), this.sync());
    }

    public DigestBasedCache<F> withRetry(Retry retry) {
        return new DigestBasedCache<F>(this.location(), retry, this.sync());
    }

    public DigestBasedCache<F> withSync(Sync<F> sync) {
        return new DigestBasedCache<F>(this.location(), this.retry(), sync);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("DigestBasedCache(");
        b.append(String.valueOf(this.location()));
        b.append(", ");
        b.append(String.valueOf(this.retry()));
        b.append(", ");
        b.append(String.valueOf(this.sync()));
        b.append(")");
        return b.toString();
    }

    @Override
    public boolean canEqual(Object obj) {
        return obj != null && obj instanceof DigestBasedCache && true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!this.canEqual(obj)) return false;
        DigestBasedCache other = (DigestBasedCache)obj;
        if (!true) return false;
        Path path = this.location();
        Path path2 = other.location();
        if (path == null) {
            if (path2 != null) {
                return false;
            }
        } else if (!((Object)path).equals(path2)) return false;
        Retry retry = this.retry();
        Retry retry2 = other.retry();
        if (retry == null) {
            if (retry2 != null) {
                return false;
            }
        } else if (!((Object)retry).equals(retry2)) return false;
        Sync<F> sync = this.sync();
        Sync<F> sync2 = other.sync();
        if (sync == null) {
            if (sync2 == null) return true;
            return false;
        } else {
            if (!sync.equals(sync2)) return false;
            return true;
        }
    }

    public int hashCode() {
        int code = 17 + Statics.anyHash("DigestBasedCache");
        code = 37 * code + Statics.anyHash(this.location());
        code = 37 * code + Statics.anyHash(this.retry());
        code = 37 * code + Statics.anyHash(this.sync());
        return 37 * code;
    }

    private Tuple3<Path, Retry, Sync<F>> tuple() {
        return new Tuple3<Path, Retry, Sync<F>>(this.location(), this.retry(), this.sync());
    }

    @Override
    public String productPrefix() {
        return "DigestBasedCache";
    }

    @Override
    public int productArity() {
        return 3;
    }

    @Override
    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this.location();
            }
            case 1: {
                return this.retry();
            }
            case 2: {
                return this.sync();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    @Override
    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "location";
            }
            case 1: {
                return "retry";
            }
            case 2: {
                return "sync";
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(n2));
    }

    public DigestBasedCache(Path location, Retry retry, Sync<F> sync) {
        this.location = location;
        this.retry = retry;
        this.sync = sync;
        Product.$init$(this);
    }

    public DigestBasedCache(Path location, Sync<F> sync) {
        this(location, new Retry(CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier()), sync);
    }
}

