/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8;

import com.eclipsesource.v8.JavaCallback;
import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.LibraryLoader;
import com.eclipsesource.v8.ReferenceHandler;
import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Locker;
import com.eclipsesource.v8.V8Object;
import com.eclipsesource.v8.V8ResultUndefined;
import com.eclipsesource.v8.V8RuntimeException;
import com.eclipsesource.v8.V8Value;
import com.eclipsesource.v8.utils.V8Executor;
import com.eclipsesource.v8.utils.V8Map;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class V8
extends V8Object {
    private static Object lock = new Object();
    private static volatile int runtimeCounter = 0;
    private static String v8Flags = null;
    private static boolean initialized = false;
    private final V8Locker locker;
    private long objectReferences = 0L;
    private long v8RuntimePtr = 0L;
    private List<Releasable> resources = null;
    private V8Map<V8Executor> executors = null;
    private boolean forceTerminateExecutors = false;
    private Map<Long, MethodDescriptor> functionRegistry = new HashMap<Long, MethodDescriptor>();
    private LinkedList<ReferenceHandler> referenceHandlers = new LinkedList();
    private static boolean nativeLibraryLoaded = false;
    private static Error nativeLoadError = null;
    private static Exception nativeLoadException = null;
    private static V8Value undefined = new V8Object.Undefined();
    private static Object invalid = new Object();

    private static synchronized void load(String tmpDirectory) {
        try {
            LibraryLoader.loadLibrary(tmpDirectory);
            nativeLibraryLoaded = true;
        }
        catch (Error e) {
            nativeLoadError = e;
        }
        catch (Exception e) {
            nativeLoadException = e;
        }
    }

    public static boolean isLoaded() {
        return nativeLibraryLoaded;
    }

    public static void setFlags(String flags) {
        v8Flags = flags;
        initialized = false;
    }

    public static V8 createV8Runtime() {
        return V8.createV8Runtime(null, null);
    }

    public static V8 createV8Runtime(String globalAlias) {
        return V8.createV8Runtime(globalAlias, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static V8 createV8Runtime(String globalAlias, String tempDirectory) {
        if (!nativeLibraryLoaded) {
            Object object = lock;
            synchronized (object) {
                if (!nativeLibraryLoaded) {
                    V8.load(tempDirectory);
                }
            }
        }
        V8.checkNativeLibraryLoaded();
        if (!initialized) {
            V8._setFlags(v8Flags);
            initialized = true;
        }
        V8 runtime = new V8(globalAlias);
        Object object = lock;
        synchronized (object) {
            ++runtimeCounter;
        }
        return runtime;
    }

    public void addReferenceHandler(ReferenceHandler handler) {
        this.referenceHandlers.add(0, handler);
    }

    public void removeReferenceHandler(ReferenceHandler handler) {
        this.referenceHandlers.remove(handler);
    }

    private void notifyReferenceCreated(V8Value object) {
        for (ReferenceHandler referenceHandler : this.referenceHandlers) {
            referenceHandler.v8HandleCreated(object);
        }
    }

    private void notifyReferenceDisposed(V8Value object) {
        for (ReferenceHandler referenceHandler : this.referenceHandlers) {
            referenceHandler.v8HandleDisposed(object);
        }
    }

    private static void checkNativeLibraryLoaded() {
        if (!nativeLibraryLoaded) {
            if (nativeLoadError != null) {
                throw new IllegalStateException("J2V8 native library not loaded", nativeLoadError);
            }
            if (nativeLoadException != null) {
                throw new IllegalStateException("J2V8 native library not loaded", nativeLoadException);
            }
            throw new IllegalStateException("J2V8 native library not loaded");
        }
    }

    protected V8() {
        this((String)null);
    }

    protected V8(String globalAlias) {
        super(null);
        this.released = false;
        this.locker = new V8Locker();
        this.checkThread();
        this.v8RuntimePtr = this._createIsolate(globalAlias);
        this.objectHandle = this._getGlobalObject(this.v8RuntimePtr);
    }

    public static V8Value getUndefined() {
        return undefined;
    }

    public static int getActiveRuntimes() {
        return runtimeCounter;
    }

    public long getObjectReferenceCount() {
        return this.objectReferences;
    }

    protected long getV8RuntimePtr() {
        return this.v8RuntimePtr;
    }

    public static String getV8Version() {
        return V8._getVersion();
    }

    @Override
    public void release() {
        this.release(true);
    }

    public void terminateExecution() {
        this.forceTerminateExecutors = true;
        this.terminateExecution(this.v8RuntimePtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(boolean reportMemoryLeaks) {
        if (this.isReleased()) {
            return;
        }
        this.checkThread();
        this.releaseResources();
        this.shutdownExecutors(this.forceTerminateExecutors);
        if (this.executors != null) {
            this.executors.clear();
        }
        this.releaseNativeMethodDescriptors();
        Object object = lock;
        synchronized (object) {
            --runtimeCounter;
        }
        this._releaseRuntime(this.v8RuntimePtr);
        this.v8RuntimePtr = 0L;
        this.released = true;
        if (reportMemoryLeaks && this.objectReferences > 0L) {
            throw new IllegalStateException(this.objectReferences + " Object(s) still exist in runtime");
        }
    }

    private void releaseNativeMethodDescriptors() {
        Set<Long> nativeMethodDescriptors = this.functionRegistry.keySet();
        for (Long nativeMethodDescriptor : nativeMethodDescriptors) {
            this.releaseMethodDescriptor(this.v8RuntimePtr, nativeMethodDescriptor);
        }
    }

    private void releaseResources() {
        if (this.resources != null) {
            for (Releasable releasable : this.resources) {
                releasable.release();
            }
            this.resources.clear();
            this.resources = null;
        }
    }

    public void registerV8Executor(V8Object key2, V8Executor executor) {
        this.checkThread();
        if (this.executors == null) {
            this.executors = new V8Map();
        }
        this.executors.put(key2, executor);
    }

    public V8Executor removeExecutor(V8Object key2) {
        this.checkThread();
        if (this.executors == null) {
            return null;
        }
        return this.executors.remove(key2);
    }

    public V8Executor getExecutor(V8Object key2) {
        this.checkThread();
        if (this.executors == null) {
            return null;
        }
        return this.executors.get(key2);
    }

    public void shutdownExecutors(boolean forceTerminate) {
        this.checkThread();
        if (this.executors == null) {
            return;
        }
        for (V8Executor executor : this.executors.values()) {
            if (forceTerminate) {
                executor.forceTermination();
                continue;
            }
            executor.shutdown();
        }
    }

    public void registerResource(Releasable resource) {
        this.checkThread();
        if (this.resources == null) {
            this.resources = new ArrayList<Releasable>();
        }
        this.resources.add(resource);
    }

    public int executeIntegerScript(String script) {
        return this.executeIntegerScript(script, null, 0);
    }

    public int executeIntegerScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeIntegerScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected void createTwin(V8Value value, V8Value twin) {
        this.checkThread();
        this.createTwin(this.v8RuntimePtr, value.getHandle(), twin.getHandle());
    }

    public double executeDoubleScript(String script) {
        return this.executeDoubleScript(script, null, 0);
    }

    public double executeDoubleScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeDoubleScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public String executeStringScript(String script) {
        return this.executeStringScript(script, null, 0);
    }

    public String executeStringScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeStringScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public boolean executeBooleanScript(String script) {
        return this.executeBooleanScript(script, null, 0);
    }

    public boolean executeBooleanScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeBooleanScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public V8Array executeArrayScript(String script) {
        return this.executeArrayScript(script, null, 0);
    }

    public V8Array executeArrayScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        Object result2 = this.executeScript(script, scriptName, lineNumber);
        if (result2 instanceof V8Array) {
            return (V8Array)result2;
        }
        throw new V8ResultUndefined();
    }

    public Object executeScript(String script) {
        return this.executeScript(script, null, 0);
    }

    public Object executeScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        return this.executeScript(this.getV8RuntimePtr(), 0, script, scriptName, lineNumber);
    }

    public V8Object executeObjectScript(String script) {
        return this.executeObjectScript(script, null, 0);
    }

    public V8Object executeObjectScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        Object result2 = this.executeScript(script, scriptName, lineNumber);
        if (result2 instanceof V8Object) {
            return (V8Object)result2;
        }
        throw new V8ResultUndefined();
    }

    public void executeVoidScript(String script) {
        this.executeVoidScript(script, null, 0);
    }

    public void executeVoidScript(String script, String scriptName, int lineNumber) {
        this.checkThread();
        V8.checkScript(script);
        this.executeVoidScript(this.v8RuntimePtr, script, scriptName, lineNumber);
    }

    public V8Locker getLocker() {
        return this.locker;
    }

    public long getBuildID() {
        return this._getBuildID();
    }

    void checkThread() {
        this.locker.checkThread();
        if (this.isReleased()) {
            throw new Error("Runtime disposed error");
        }
    }

    static void checkScript(String script) {
        if (script == null) {
            throw new NullPointerException("Script is null");
        }
    }

    void registerCallback(Object object, Method method, long objectHandle, String jsFunctionName, boolean includeReceiver) {
        MethodDescriptor methodDescriptor = new MethodDescriptor();
        methodDescriptor.object = object;
        methodDescriptor.method = method;
        methodDescriptor.includeReceiver = includeReceiver;
        long methodID = this.registerJavaMethod(this.getV8RuntimePtr(), objectHandle, jsFunctionName, this.isVoidMethod(method));
        this.functionRegistry.put(methodID, methodDescriptor);
    }

    void registerVoidCallback(JavaVoidCallback callback, long objectHandle, String jsFunctionName) {
        MethodDescriptor methodDescriptor = new MethodDescriptor();
        methodDescriptor.voidCallback = callback;
        long methodID = this.registerJavaMethod(this.getV8RuntimePtr(), objectHandle, jsFunctionName, true);
        this.functionRegistry.put(methodID, methodDescriptor);
    }

    void registerCallback(JavaCallback callback, long objectHandle, String jsFunctionName) {
        long methodID = this.registerJavaMethod(this.getV8RuntimePtr(), objectHandle, jsFunctionName, false);
        this.createAndRegisterMethodDescriptor(callback, methodID);
    }

    void createAndRegisterMethodDescriptor(JavaCallback callback, long methodID) {
        MethodDescriptor methodDescriptor = new MethodDescriptor();
        methodDescriptor.callback = callback;
        this.functionRegistry.put(methodID, methodDescriptor);
    }

    private boolean isVoidMethod(Method method) {
        Class<?> returnType = method.getReturnType();
        return returnType.equals(Void.TYPE);
    }

    private Object getDefaultValue(Class<?> type) {
        if (type.equals(V8Object.class)) {
            return new V8Object.Undefined();
        }
        if (type.equals(V8Array.class)) {
            return new V8Array.Undefined();
        }
        return invalid;
    }

    protected void disposeMethodID(long methodID) {
        this.functionRegistry.remove(methodID);
    }

    protected Object callObjectJavaMethod(long methodID, V8Object receiver, V8Array parameters) throws Throwable {
        MethodDescriptor methodDescriptor = this.functionRegistry.get(methodID);
        if (methodDescriptor.callback != null) {
            return this.checkResult(methodDescriptor.callback.invoke(receiver, parameters));
        }
        boolean hasVarArgs = methodDescriptor.method.isVarArgs();
        Object[] args = this.getArgs(receiver, methodDescriptor, parameters, hasVarArgs);
        this.checkArgs(args);
        try {
            Object result2 = methodDescriptor.method.invoke(methodDescriptor.object, args);
            Object object = this.checkResult(result2);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            this.releaseArguments(args, hasVarArgs);
        }
    }

    private Object checkResult(Object result2) {
        if (result2 == null) {
            return result2;
        }
        if (result2 instanceof Float) {
            return ((Float)result2).doubleValue();
        }
        if (result2 instanceof Integer || result2 instanceof Double || result2 instanceof Boolean || result2 instanceof String) {
            return result2;
        }
        if (result2 instanceof V8Value) {
            if (((V8Value)result2).isReleased()) {
                throw new V8RuntimeException("V8Value already released");
            }
            return result2;
        }
        throw new V8RuntimeException("Unknown return type: " + result2.getClass());
    }

    protected void callVoidJavaMethod(long methodID, V8Object receiver, V8Array parameters) throws Throwable {
        MethodDescriptor methodDescriptor = this.functionRegistry.get(methodID);
        if (methodDescriptor.voidCallback != null) {
            methodDescriptor.voidCallback.invoke(receiver, parameters);
            return;
        }
        boolean hasVarArgs = methodDescriptor.method.isVarArgs();
        Object[] args = this.getArgs(receiver, methodDescriptor, parameters, hasVarArgs);
        this.checkArgs(args);
        try {
            methodDescriptor.method.invoke(methodDescriptor.object, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (IllegalAccessException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        finally {
            this.releaseArguments(args, hasVarArgs);
        }
    }

    private void checkArgs(Object[] args) {
        for (Object argument : args) {
            if (argument != invalid) continue;
            throw new IllegalArgumentException("argument type mismatch");
        }
    }

    private void releaseArguments(Object[] args, boolean hasVarArgs) {
        if (hasVarArgs && args.length > 0 && args[args.length - 1] instanceof Object[]) {
            Object[] varArgs;
            Object[] objectArray = varArgs = (Object[])args[args.length - 1];
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                if (!(object instanceof V8Value)) continue;
                ((V8Value)object).release();
            }
        }
        for (Object arg2 : args) {
            if (!(arg2 instanceof V8Value)) continue;
            ((V8Value)arg2).release();
        }
    }

    private Object[] getArgs(V8Object receiver, MethodDescriptor methodDescriptor, V8Array parameters, boolean hasVarArgs) {
        int numberOfParameters = methodDescriptor.method.getParameterTypes().length;
        int varArgIndex = hasVarArgs ? numberOfParameters - 1 : numberOfParameters;
        Object[] args = this.setDefaultValues(new Object[numberOfParameters], methodDescriptor.method.getParameterTypes(), receiver, methodDescriptor.includeReceiver);
        ArrayList<Object> varArgs = new ArrayList<Object>();
        this.populateParamters(parameters, varArgIndex, args, varArgs, methodDescriptor.includeReceiver);
        if (hasVarArgs) {
            Object varArgContainer = this.getVarArgContainer(methodDescriptor.method.getParameterTypes(), varArgs.size());
            System.arraycopy(varArgs.toArray(), 0, varArgContainer, 0, varArgs.size());
            args[varArgIndex] = varArgContainer;
        }
        return args;
    }

    private Object getVarArgContainer(Class<?>[] parameterTypes, int size2) {
        Class<?> clazz = parameterTypes[parameterTypes.length - 1];
        if (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        Object result2 = Array.newInstance(clazz, size2);
        return result2;
    }

    private void populateParamters(V8Array parameters, int varArgIndex, Object[] args, List<Object> varArgs, boolean includeReceiver) {
        int start = 0;
        if (includeReceiver) {
            start = 1;
        }
        for (int i = start; i < parameters.length() + start; ++i) {
            if (i >= varArgIndex) {
                varArgs.add(this.getArrayItem(parameters, i - start));
                continue;
            }
            args[i] = this.getArrayItem(parameters, i - start);
        }
    }

    private Object[] setDefaultValues(Object[] parameters, Class<?>[] parameterTypes, V8Object receiver, boolean includeReceiver) {
        int start = 0;
        if (includeReceiver) {
            start = 1;
            parameters[0] = receiver;
        }
        for (int i = start; i < parameters.length; ++i) {
            parameters[i] = this.getDefaultValue(parameterTypes[i]);
        }
        return parameters;
    }

    private Object getArrayItem(V8Array array, int index) {
        try {
            int type = array.getType(index);
            switch (type) {
                case 1: {
                    return array.getInteger(index);
                }
                case 2: {
                    return array.getDouble(index);
                }
                case 3: {
                    return array.getBoolean(index);
                }
                case 4: {
                    return array.getString(index);
                }
                case 5: 
                case 8: {
                    return array.getArray(index);
                }
                case 6: {
                    return array.getObject(index);
                }
                case 7: {
                    return array.getObject(index);
                }
                case 10: {
                    return array.get(index);
                }
                case 99: {
                    return V8.getUndefined();
                }
            }
        }
        catch (V8ResultUndefined v8ResultUndefined) {
            // empty catch block
        }
        return null;
    }

    void createNodeRuntime(String fileName) {
        V8._startNodeJS(this.v8RuntimePtr, fileName);
    }

    boolean pumpMessageLoop() {
        return V8._pumpMessageLoop(this.v8RuntimePtr);
    }

    boolean isRunning() {
        return V8._isRunning(this.v8RuntimePtr);
    }

    protected long initNewV8Object(long v8RuntimePtr) {
        return this._initNewV8Object(v8RuntimePtr);
    }

    protected void createTwin(long v8RuntimePtr, long objectHandle, long twinHandle) {
        this._createTwin(v8RuntimePtr, objectHandle, twinHandle);
    }

    protected int executeIntegerScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeIntegerScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected double executeDoubleScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeDoubleScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected String executeStringScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeStringScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected boolean executeBooleanScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        return this._executeBooleanScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected Object executeScript(long v8RuntimePtr, int expectedType, String script, String scriptName, int lineNumber) {
        return this._executeScript(v8RuntimePtr, expectedType, script, scriptName, lineNumber);
    }

    protected void executeVoidScript(long v8RuntimePtr, String script, String scriptName, int lineNumber) {
        this._executeVoidScript(v8RuntimePtr, script, scriptName, lineNumber);
    }

    protected void release(long v8RuntimePtr, long objectHandle) {
        this._release(v8RuntimePtr, objectHandle);
    }

    protected boolean contains(long v8RuntimePtr, long objectHandle, String key2) {
        return this._contains(v8RuntimePtr, objectHandle, key2);
    }

    protected String[] getKeys(long v8RuntimePtr, long objectHandle) {
        return this._getKeys(v8RuntimePtr, objectHandle);
    }

    protected int getInteger(long v8RuntimePtr, long objectHandle, String key2) {
        return this._getInteger(v8RuntimePtr, objectHandle, key2);
    }

    protected boolean getBoolean(long v8RuntimePtr, long objectHandle, String key2) {
        return this._getBoolean(v8RuntimePtr, objectHandle, key2);
    }

    protected double getDouble(long v8RuntimePtr, long objectHandle, String key2) {
        return this._getDouble(v8RuntimePtr, objectHandle, key2);
    }

    protected String getString(long v8RuntimePtr, long objectHandle, String key2) {
        return this._getString(v8RuntimePtr, objectHandle, key2);
    }

    protected Object get(long v8RuntimePtr, int expectedType, long objectHandle, String key2) {
        return this._get(v8RuntimePtr, expectedType, objectHandle, key2);
    }

    protected int executeIntegerFunction(long v8RuntimePtr, long objectHandle, String name, long parametersHandle) {
        return this._executeIntegerFunction(v8RuntimePtr, objectHandle, name, parametersHandle);
    }

    protected double executeDoubleFunction(long v8RuntimePtr, long objectHandle, String name, long parametersHandle) {
        return this._executeDoubleFunction(v8RuntimePtr, objectHandle, name, parametersHandle);
    }

    protected String executeStringFunction(long v8RuntimePtr, long handle, String name, long parametersHandle) {
        return this._executeStringFunction(v8RuntimePtr, handle, name, parametersHandle);
    }

    protected boolean executeBooleanFunction(long v8RuntimePtr, long handle, String name, long parametersHandle) {
        return this._executeBooleanFunction(v8RuntimePtr, handle, name, parametersHandle);
    }

    protected Object executeFunction(long v8RuntimePtr, int expectedType, long objectHandle, String name, long parametersHandle) {
        return this._executeFunction(v8RuntimePtr, expectedType, objectHandle, name, parametersHandle);
    }

    protected Object executeFunction(long v8RuntimePtr, long receiverHandle, long functionHandle, long parametersHandle) {
        return this._executeFunction(v8RuntimePtr, receiverHandle, functionHandle, parametersHandle);
    }

    protected void executeVoidFunction(long v8RuntimePtr, long objectHandle, String name, long parametersHandle) {
        this._executeVoidFunction(v8RuntimePtr, objectHandle, name, parametersHandle);
    }

    protected boolean equals(long v8RuntimePtr, long objectHandle, long that) {
        return this._equals(v8RuntimePtr, objectHandle, that);
    }

    protected String toString(long v8RuntimePtr, long objectHandle) {
        return this._toString(v8RuntimePtr, objectHandle);
    }

    protected boolean strictEquals(long v8RuntimePtr, long objectHandle, long that) {
        return this._strictEquals(v8RuntimePtr, objectHandle, that);
    }

    protected boolean sameValue(long v8RuntimePtr, long objectHandle, long that) {
        return this._sameValue(v8RuntimePtr, objectHandle, that);
    }

    protected int identityHash(long v8RuntimePtr, long objectHandle) {
        return this._identityHash(v8RuntimePtr, objectHandle);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key2, int value) {
        this._add(v8RuntimePtr, objectHandle, key2, value);
    }

    protected void addObject(long v8RuntimePtr, long objectHandle, String key2, long value) {
        this._addObject(v8RuntimePtr, objectHandle, key2, value);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key2, boolean value) {
        this._add(v8RuntimePtr, objectHandle, key2, value);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key2, double value) {
        this._add(v8RuntimePtr, objectHandle, key2, value);
    }

    protected void add(long v8RuntimePtr, long objectHandle, String key2, String value) {
        this._add(v8RuntimePtr, objectHandle, key2, value);
    }

    protected void addUndefined(long v8RuntimePtr, long objectHandle, String key2) {
        this._addUndefined(v8RuntimePtr, objectHandle, key2);
    }

    protected void addNull(long v8RuntimePtr, long objectHandle, String key2) {
        this._addNull(v8RuntimePtr, objectHandle, key2);
    }

    protected long registerJavaMethod(long v8RuntimePtr, long objectHandle, String functionName, boolean voidMethod) {
        return this._registerJavaMethod(v8RuntimePtr, objectHandle, functionName, voidMethod);
    }

    protected long initNewV8ArrayBuffer(long v8RuntimePtr, ByteBuffer buffer, int capacity) {
        return this._initNewV8ArrayBuffer(v8RuntimePtr, buffer, capacity);
    }

    protected long initNewV8ArrayBuffer(long v8RuntimePtr, int capacity) {
        return this._initNewV8ArrayBuffer(v8RuntimePtr, capacity);
    }

    public long initNewV8Int32Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8Int32Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8Float32Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8Float32Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8Float64Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8Float64Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8UInt32Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8UInt32Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8UInt16Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8UInt16Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8Int16Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8Int16Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8UInt8Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8UInt8Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8Int8Array(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8Int8Array(runtimePtr, bufferHandle, offset, size2);
    }

    public long initNewV8UInt8ClampedArray(long runtimePtr, long bufferHandle, int offset, int size2) {
        return this._initNewV8UInt8ClampedArray(runtimePtr, bufferHandle, offset, size2);
    }

    protected ByteBuffer createV8ArrayBufferBackingStore(long v8RuntimePtr, long objectHandle, int capacity) {
        return this._createV8ArrayBufferBackingStore(v8RuntimePtr, objectHandle, capacity);
    }

    protected long initNewV8Array(long v8RuntimePtr) {
        return this._initNewV8Array(v8RuntimePtr);
    }

    protected long[] initNewV8Function(long v8RuntimePtr) {
        this.checkThread();
        return this._initNewV8Function(v8RuntimePtr);
    }

    protected int arrayGetSize(long v8RuntimePtr, long arrayHandle) {
        return this._arrayGetSize(v8RuntimePtr, arrayHandle);
    }

    protected int arrayGetInteger(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetInteger(v8RuntimePtr, arrayHandle, index);
    }

    protected boolean arrayGetBoolean(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetBoolean(v8RuntimePtr, arrayHandle, index);
    }

    protected byte arrayGetByte(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetByte(v8RuntimePtr, arrayHandle, index);
    }

    protected double arrayGetDouble(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetDouble(v8RuntimePtr, arrayHandle, index);
    }

    protected String arrayGetString(long v8RuntimePtr, long arrayHandle, int index) {
        return this._arrayGetString(v8RuntimePtr, arrayHandle, index);
    }

    protected Object arrayGet(long v8RuntimePtr, int expectedType, long arrayHandle, int index) {
        return this._arrayGet(v8RuntimePtr, expectedType, arrayHandle, index);
    }

    protected void addArrayIntItem(long v8RuntimePtr, long arrayHandle, int value) {
        this._addArrayIntItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayBooleanItem(long v8RuntimePtr, long arrayHandle, boolean value) {
        this._addArrayBooleanItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayDoubleItem(long v8RuntimePtr, long arrayHandle, double value) {
        this._addArrayDoubleItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayStringItem(long v8RuntimePtr, long arrayHandle, String value) {
        this._addArrayStringItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayObjectItem(long v8RuntimePtr, long arrayHandle, long value) {
        this._addArrayObjectItem(v8RuntimePtr, arrayHandle, value);
    }

    protected void addArrayUndefinedItem(long v8RuntimePtr, long arrayHandle) {
        this._addArrayUndefinedItem(v8RuntimePtr, arrayHandle);
    }

    protected void addArrayNullItem(long v8RuntimePtr, long arrayHandle) {
        this._addArrayNullItem(v8RuntimePtr, arrayHandle);
    }

    protected int getType(long v8RuntimePtr, long objectHandle, String key2) {
        return this._getType(v8RuntimePtr, objectHandle, key2);
    }

    protected int getType(long v8RuntimePtr, long objectHandle, int index) {
        return this._getType(v8RuntimePtr, objectHandle, index);
    }

    protected int getArrayType(long v8RuntimePtr, long objectHandle) {
        return this._getArrayType(v8RuntimePtr, objectHandle);
    }

    protected int getType(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._getType(v8RuntimePtr, objectHandle, index, length);
    }

    protected void setPrototype(long v8RuntimePtr, long objectHandle, long prototypeHandle) {
        this._setPrototype(v8RuntimePtr, objectHandle, prototypeHandle);
    }

    protected int[] arrayGetIntegers(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetIntegers(v8RuntimePtr, objectHandle, index, length);
    }

    protected double[] arrayGetDoubles(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetDoubles(v8RuntimePtr, objectHandle, index, length);
    }

    protected boolean[] arrayGetBooleans(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetBooleans(v8RuntimePtr, objectHandle, index, length);
    }

    protected byte[] arrayGetBytes(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetBytes(v8RuntimePtr, objectHandle, index, length);
    }

    protected String[] arrayGetStrings(long v8RuntimePtr, long objectHandle, int index, int length) {
        return this._arrayGetStrings(v8RuntimePtr, objectHandle, index, length);
    }

    protected int arrayGetIntegers(long v8RuntimePtr, long objectHandle, int index, int length, int[] resultArray) {
        return this._arrayGetIntegers(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetDoubles(long v8RuntimePtr, long objectHandle, int index, int length, double[] resultArray) {
        return this._arrayGetDoubles(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetBooleans(long v8RuntimePtr, long objectHandle, int index, int length, boolean[] resultArray) {
        return this._arrayGetBooleans(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetBytes(long v8RuntimePtr, long objectHandle, int index, int length, byte[] resultArray) {
        return this._arrayGetBytes(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected int arrayGetStrings(long v8RuntimePtr, long objectHandle, int index, int length, String[] resultArray) {
        return this._arrayGetStrings(v8RuntimePtr, objectHandle, index, length, resultArray);
    }

    protected void terminateExecution(long v8RuntimePtr) {
        this._terminateExecution(v8RuntimePtr);
    }

    protected void releaseMethodDescriptor(long v8RuntimePtr, long methodDescriptor) {
        this._releaseMethodDescriptor(v8RuntimePtr, methodDescriptor);
    }

    private native long _initNewV8Object(long var1);

    private native void _createTwin(long var1, long var3, long var5);

    private native void _releaseRuntime(long var1);

    private native long _createIsolate(String var1);

    private native int _executeIntegerScript(long var1, String var3, String var4, int var5);

    private native double _executeDoubleScript(long var1, String var3, String var4, int var5);

    private native String _executeStringScript(long var1, String var3, String var4, int var5);

    private native boolean _executeBooleanScript(long var1, String var3, String var4, int var5);

    private native Object _executeScript(long var1, int var3, String var4, String var5, int var6);

    private native void _executeVoidScript(long var1, String var3, String var4, int var5);

    private native void _release(long var1, long var3);

    private native void _releaseMethodDescriptor(long var1, long var3);

    private native boolean _contains(long var1, long var3, String var5);

    private native String[] _getKeys(long var1, long var3);

    private native int _getInteger(long var1, long var3, String var5);

    private native boolean _getBoolean(long var1, long var3, String var5);

    private native double _getDouble(long var1, long var3, String var5);

    private native String _getString(long var1, long var3, String var5);

    private native Object _get(long var1, int var3, long var4, String var6);

    private native int _executeIntegerFunction(long var1, long var3, String var5, long var6);

    private native double _executeDoubleFunction(long var1, long var3, String var5, long var6);

    private native String _executeStringFunction(long var1, long var3, String var5, long var6);

    private native boolean _executeBooleanFunction(long var1, long var3, String var5, long var6);

    private native Object _executeFunction(long var1, int var3, long var4, String var6, long var7);

    private native Object _executeFunction(long var1, long var3, long var5, long var7);

    private native void _executeVoidFunction(long var1, long var3, String var5, long var6);

    private native boolean _equals(long var1, long var3, long var5);

    private native String _toString(long var1, long var3);

    private native boolean _strictEquals(long var1, long var3, long var5);

    private native boolean _sameValue(long var1, long var3, long var5);

    private native int _identityHash(long var1, long var3);

    private native void _add(long var1, long var3, String var5, int var6);

    private native void _addObject(long var1, long var3, String var5, long var6);

    private native void _add(long var1, long var3, String var5, boolean var6);

    private native void _add(long var1, long var3, String var5, double var6);

    private native void _add(long var1, long var3, String var5, String var6);

    private native void _addUndefined(long var1, long var3, String var5);

    private native void _addNull(long var1, long var3, String var5);

    private native long _registerJavaMethod(long var1, long var3, String var5, boolean var6);

    private native long _initNewV8Array(long var1);

    private native long[] _initNewV8Function(long var1);

    private native int _arrayGetSize(long var1, long var3);

    private native int _arrayGetInteger(long var1, long var3, int var5);

    private native boolean _arrayGetBoolean(long var1, long var3, int var5);

    private native byte _arrayGetByte(long var1, long var3, int var5);

    private native double _arrayGetDouble(long var1, long var3, int var5);

    private native String _arrayGetString(long var1, long var3, int var5);

    private native Object _arrayGet(long var1, int var3, long var4, int var6);

    private native void _addArrayIntItem(long var1, long var3, int var5);

    private native void _addArrayBooleanItem(long var1, long var3, boolean var5);

    private native void _addArrayDoubleItem(long var1, long var3, double var5);

    private native void _addArrayStringItem(long var1, long var3, String var5);

    private native void _addArrayObjectItem(long var1, long var3, long var5);

    private native void _addArrayUndefinedItem(long var1, long var3);

    private native void _addArrayNullItem(long var1, long var3);

    private native int _getType(long var1, long var3, String var5);

    private native int _getType(long var1, long var3, int var5);

    private native int _getArrayType(long var1, long var3);

    private native void _setPrototype(long var1, long var3, long var5);

    private native int _getType(long var1, long var3, int var5, int var6);

    private native double[] _arrayGetDoubles(long var1, long var3, int var5, int var6);

    private native int[] _arrayGetIntegers(long var1, long var3, int var5, int var6);

    private native boolean[] _arrayGetBooleans(long var1, long var3, int var5, int var6);

    private native byte[] _arrayGetBytes(long var1, long var3, int var5, int var6);

    private native String[] _arrayGetStrings(long var1, long var3, int var5, int var6);

    private native int _arrayGetIntegers(long var1, long var3, int var5, int var6, int[] var7);

    private native int _arrayGetDoubles(long var1, long var3, int var5, int var6, double[] var7);

    private native int _arrayGetBooleans(long var1, long var3, int var5, int var6, boolean[] var7);

    private native int _arrayGetBytes(long var1, long var3, int var5, int var6, byte[] var7);

    private native int _arrayGetStrings(long var1, long var3, int var5, int var6, String[] var7);

    private native long _initNewV8ArrayBuffer(long var1, int var3);

    private native long _initNewV8ArrayBuffer(long var1, ByteBuffer var3, int var4);

    private native long _initNewV8Int32Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8UInt32Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8Float32Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8Float64Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8Int16Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8UInt16Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8Int8Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8UInt8Array(long var1, long var3, int var5, int var6);

    private native long _initNewV8UInt8ClampedArray(long var1, long var3, int var5, int var6);

    private native ByteBuffer _createV8ArrayBufferBackingStore(long var1, long var3, int var5);

    private static native String _getVersion();

    private static native void _setFlags(String var0);

    private native void _terminateExecution(long var1);

    private native long _getGlobalObject(long var1);

    private native long _getBuildID();

    private static native void _startNodeJS(long var0, String var2);

    private static native boolean _pumpMessageLoop(long var0);

    private static native boolean _isRunning(long var0);

    void addObjRef(V8Value reference) {
        ++this.objectReferences;
        if (!this.referenceHandlers.isEmpty()) {
            this.notifyReferenceCreated(reference);
        }
    }

    void releaseObjRef(V8Value reference) {
        if (!this.referenceHandlers.isEmpty()) {
            this.notifyReferenceDisposed(reference);
        }
        --this.objectReferences;
    }

    private class MethodDescriptor {
        Object object;
        Method method;
        JavaCallback callback;
        JavaVoidCallback voidCallback;
        boolean includeReceiver;

        private MethodDescriptor() {
        }
    }
}

