/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform.utils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.internal.classpath.TransformedClassPath;

public class InstrumentationTransformUtils {
    public static final String ANALYSIS_OUTPUT_DIR = "analysis";
    public static final String MERGE_OUTPUT_DIR = "merge";
    public static final String TYPE_HIERARCHY_ANALYSIS_FILE_NAME = "instrumentation-hierarchy.bin";
    public static final String DEPENDENCY_ANALYSIS_FILE_NAME = "instrumentation-dependencies.bin";

    public static InstrumentationInputType getInputType(File input) {
        if (InstrumentationTransformUtils.isInstrumentationMarkerFile(input)) {
            return InstrumentationInputType.INSTRUMENTATION_MARKER;
        }
        if (InstrumentationTransformUtils.isDependencyAnalysisFile(input)) {
            return InstrumentationInputType.DEPENDENCY_ANALYSIS_DATA;
        }
        if (InstrumentationTransformUtils.isTypeHierarchyAnalysisFile(input)) {
            return InstrumentationInputType.TYPE_HIERARCHY_ANALYSIS_DATA;
        }
        return InstrumentationInputType.ORIGINAL_ARTIFACT;
    }

    public static boolean isDependencyAnalysisFile(File input) {
        return input.getName().equals(DEPENDENCY_ANALYSIS_FILE_NAME);
    }

    public static boolean isTypeHierarchyAnalysisFile(File input) {
        return input.getName().equals(TYPE_HIERARCHY_ANALYSIS_FILE_NAME);
    }

    public static boolean isInstrumentationMarkerFile(File input) {
        return input.getName().equals(TransformedClassPath.FileMarker.INSTRUMENTATION_CLASSPATH_MARKER.getFileName());
    }

    public static void outputOriginalArtifact(TransformOutputs outputs, File originalArtifact) {
        if (originalArtifact.isDirectory()) {
            outputs.dir((Object)originalArtifact);
        } else {
            outputs.file((Object)originalArtifact);
        }
    }

    public static void createNewFile(File file) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void createInstrumentationClasspathMarker(TransformOutputs outputs) {
        InstrumentationTransformUtils.createNewFile(outputs.file((Object)TransformedClassPath.FileMarker.INSTRUMENTATION_CLASSPATH_MARKER.getFileName()));
    }

    public static enum InstrumentationInputType {
        DEPENDENCY_ANALYSIS_DATA,
        TYPE_HIERARCHY_ANALYSIS_DATA,
        INSTRUMENTATION_MARKER,
        ORIGINAL_ARTIFACT;

    }
}

