/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.waiter;

import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import java.beans.ConstructorProperties;

public class WaiterConfiguration {
    private final TerminationStrategy terminationStrategy;
    private final DelayStrategy delayStrategy;

    public TerminationStrategy getTerminationStrategy() {
        return this.terminationStrategy;
    }

    public DelayStrategy getDelayStrategy() {
        return this.delayStrategy;
    }

    public String toString() {
        return "WaiterConfiguration(terminationStrategy=" + this.getTerminationStrategy() + ", delayStrategy=" + this.getDelayStrategy() + ")";
    }

    @ConstructorProperties(value={"terminationStrategy", "delayStrategy"})
    public WaiterConfiguration(TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        this.terminationStrategy = terminationStrategy;
        this.delayStrategy = delayStrategy;
    }

    public static class WaitContext {
        private final long startTime;
        private int attemptsMade;
        private long currentTime;

        public WaitContext(long startTime) {
            this.startTime = startTime;
            this.attemptsMade = 0;
            this.currentTime = startTime;
        }

        void setCurrentTime(long currentTime) {
            this.currentTime = currentTime;
        }

        public void incrementAttempts() {
            ++this.attemptsMade;
        }

        public String toString() {
            return "WaiterConfiguration.WaitContext(startTime=" + this.getStartTime() + ", attemptsMade=" + this.getAttemptsMade() + ", currentTime=" + this.getCurrentTime() + ")";
        }

        public long getStartTime() {
            return this.startTime;
        }

        public int getAttemptsMade() {
            return this.attemptsMade;
        }

        public long getCurrentTime() {
            return this.currentTime;
        }
    }
}

