/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.ParseException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxDataContainer;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelation;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelationSettings;
import org.openstreetmap.josm.data.gpx.GpxImageDatumSettings;
import org.openstreetmap.josm.data.gpx.GpxTimeOffset;
import org.openstreetmap.josm.data.gpx.GpxTimezone;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractModifiableLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.geoimage.AdjustTimezoneAndOffsetDialog;
import org.openstreetmap.josm.gui.layer.geoimage.AdvancedCorrelationSettingsDialog;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelationSupportLayer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDirectionPositionPanel;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.layer.geoimage.SynchronizeTimeFromPhotoDialog;
import org.openstreetmap.josm.gui.layer.gpx.GpxDataHelper;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmComboBoxModel;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;

public class CorrelateGpxWithImages
extends AbstractAction
implements ExpertToggleAction.ExpertModeChangeListener,
Destroyable {
    private static JosmComboBoxModel<GpxDataWrapper> gpxModel;
    private static boolean forceTags;
    private final transient GeoImageLayer yLayer;
    private transient CorrelationSupportLayer supportLayer;
    private transient GpxTimezone timezone;
    private transient GpxTimeOffset delta;
    private ExtendedDialog syncDialog;
    private JPanel outerPanel;
    private JPanel expertPanel;
    private JosmComboBox<GpxDataWrapper> cbGpx;
    private JButton buttonSupport;
    private JosmTextField tfTimezone;
    private JosmTextField tfOffset;
    private JCheckBox cbExifImg;
    private JCheckBox cbTaggedImg;
    private JCheckBox cbShowThumbs;
    private JSeparator sepExtendedTags;
    private JLabel labelExtTags;
    private JLabel labelDatum;
    private JLabel statusBarText;
    private JSeparator sepDirectionPosition;
    private ImageDirectionPositionPanel pDirectionPosition;
    private JCheckBox cbAddGpsDatum;
    private JosmTextField tfDatum;
    private int lastNumMatched;
    private final transient StatusBarUpdater statusBarUpdater = new StatusBarUpdater(false);
    private final transient StatusBarUpdater statusBarUpdaterWithRepaint = new StatusBarUpdater(true);

    public CorrelateGpxWithImages(GeoImageLayer layer) {
        super(I18n.tr("Correlate to GPX", new Object[0]));
        new ImageProvider("dialogs/geoimage/gpx2img").getResource().attachImageIcon(this, true);
        this.yLayer = layer;
        ExpertToggleAction.addExpertModeChangeListener(this);
    }

    private void removeSupportLayer() {
        if (this.supportLayer != null) {
            MainApplication.getLayerManager().removeLayer(this.supportLayer);
            this.supportLayer = null;
        }
    }

    private void constructGpxModel(NoGpxDataWrapper nogdw) {
        gpxModel = new JosmComboBoxModel();
        GpxDataWrapper defaultItem = null;
        for (AbstractModifiableLayer cur : MainApplication.getLayerManager().getLayersOfType(AbstractModifiableLayer.class)) {
            if (!(cur instanceof GpxDataContainer)) continue;
            GpxData data = ((GpxDataContainer)((Object)cur)).getGpxData();
            GpxDataWrapper gdw = new GpxDataWrapper(cur.getName(), data, data.storageFile);
            cur.addPropertyChangeListener(new GpxLayerRenamedListener(gdw));
            gpxModel.addElement(gdw);
            if (!data.equals(this.yLayer.gpxData) && defaultItem != null) continue;
            defaultItem = gdw;
        }
        if (gpxModel.getSize() == 0) {
            gpxModel.addElement(nogdw);
        } else if (defaultItem != null) {
            gpxModel.setSelectedItem(defaultItem);
        }
        MainApplication.getLayerManager().addLayerChangeListener(new GpxLayerAddedListener());
    }

    static GpxTimezone loadTimezone() {
        try {
            String tz = Config.getPref().get("geoimage.timezone");
            if (!tz.isEmpty()) {
                return GpxTimezone.parseTimezone(tz);
            }
            return new GpxTimezone((double)TimeUnit.MILLISECONDS.toMinutes(TimeZone.getDefault().getRawOffset()) / 60.0);
        }
        catch (ParseException e) {
            Logging.trace(e);
            return GpxTimezone.ZERO;
        }
    }

    static GpxTimeOffset loadDelta() {
        try {
            return GpxTimeOffset.parseOffset(Config.getPref().get("geoimage.delta", "0"));
        }
        catch (ParseException e) {
            Logging.trace(e);
            return GpxTimeOffset.ZERO;
        }
    }

    static String loadGpsDatum() {
        return Config.getPref().get("geoimage.datum", "WGS-84");
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        NoGpxDataWrapper nogdw = new NoGpxDataWrapper();
        if (gpxModel == null) {
            this.constructGpxModel(nogdw);
        }
        JPanel panelCb = new JPanel();
        panelCb.add(new JLabel(I18n.tr("GPX track: ", new Object[0])));
        this.cbGpx = new JosmComboBox<GpxDataWrapper>(gpxModel);
        this.cbGpx.setPrototypeDisplayValue(nogdw);
        this.cbGpx.addActionListener(this.statusBarUpdaterWithRepaint);
        panelCb.add(this.cbGpx);
        JButton buttonOpen = new JButton(I18n.tr("Open another GPX trace", new Object[0]));
        buttonOpen.addActionListener(new LoadGpxDataActionListener());
        panelCb.add(buttonOpen);
        this.buttonSupport = new JButton(I18n.tr("Use support layer", new Object[0]));
        this.buttonSupport.addActionListener(new UseSupportLayerActionListener());
        panelCb.add(this.buttonSupport);
        JPanel panelTf = new JPanel(new GridBagLayout());
        this.timezone = CorrelateGpxWithImages.loadTimezone();
        this.tfTimezone = new JosmTextField(10);
        this.tfTimezone.setText(this.timezone.formatTimezone());
        this.delta = CorrelateGpxWithImages.loadDelta();
        this.tfOffset = new JosmTextField(10);
        this.tfOffset.setText(this.delta.formatOffset());
        JButton buttonViewGpsPhoto = new JButton(I18n.tr("<html>Use photo of an accurate clock,<br>e.g. GPS receiver display</html>", new Object[0]));
        buttonViewGpsPhoto.setIcon(ImageProvider.get("clock"));
        buttonViewGpsPhoto.addActionListener(new SetOffsetActionListener());
        JButton buttonAutoGuess = new JButton(I18n.tr("Auto-Guess", new Object[0]));
        buttonAutoGuess.setToolTipText(I18n.tr("Matches first photo with first gpx point", new Object[0]));
        buttonAutoGuess.addActionListener(new AutoGuessActionListener());
        JButton buttonAdjust = new JButton(I18n.tr("Manual adjust", new Object[0]));
        buttonAdjust.addActionListener(new AdjustActionListener());
        JButton buttonAdvanced = new JButton(I18n.tr("Advanced settings...", new Object[0]));
        buttonAdvanced.addActionListener(new AdvancedSettingsActionListener());
        JLabel labelPosition = new JLabel(I18n.tr("Override position for: ", new Object[0]));
        int numAll = this.yLayer.getSortedImgList(true, true).size();
        int numExif = numAll - this.yLayer.getSortedImgList(false, true).size();
        int numTagged = numAll - this.yLayer.getSortedImgList(true, false).size();
        this.cbExifImg = new JCheckBox(I18n.tr("Images with geo location in exif data ({0}/{1})", numExif, numAll));
        this.cbExifImg.setEnabled(numExif != 0);
        this.cbTaggedImg = new JCheckBox(I18n.tr("Images that are already tagged ({0}/{1})", numTagged, numAll), true);
        this.cbTaggedImg.setEnabled(numTagged != 0);
        labelPosition.setEnabled(this.cbExifImg.isEnabled() || this.cbTaggedImg.isEnabled());
        boolean ticked = this.yLayer.thumbsLoaded || Config.getPref().getBoolean("geoimage.showThumbs", false);
        this.cbShowThumbs = new JCheckBox(I18n.tr("Show Thumbnail images on the map", new Object[0]), ticked);
        this.cbShowThumbs.setEnabled(!this.yLayer.thumbsLoaded);
        int y = 0;
        panelTf.add((Component)panelCb, GBC.eol().grid(0, y++));
        GBC gbc = GBC.eol().grid(0, y++).fill(2).insets(0, 0, 0, 12);
        panelTf.add((Component)new JSeparator(0), gbc);
        panelTf.add((Component)new JLabel(I18n.tr("Timezone: ", new Object[0])), GBC.std(0, y));
        gbc = GBC.std(1, y++).fill(2);
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfTimezone, gbc);
        gbc = GBC.std(0, y);
        panelTf.add((Component)new JLabel(I18n.tr("Offset:", new Object[0])), gbc);
        gbc = GBC.std(1, y++).fill(2);
        gbc.weightx = 1.0;
        panelTf.add((Component)this.tfOffset, gbc);
        gbc = GBC.std(2, y - 2).insets(5, 5, 5, 5).span(2, 2);
        gbc.fill = 1;
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonViewGpsPhoto, gbc);
        gbc = GBC.std(1, y++).fill(1).insets(5, 5, 5, 5);
        gbc.weightx = 0.5;
        panelTf.add((Component)buttonAdvanced, gbc);
        gbc.gridx = 2;
        panelTf.add((Component)buttonAutoGuess, gbc);
        gbc.gridx = 3;
        panelTf.add((Component)buttonAdjust, gbc);
        gbc = GBC.eol().grid(0, y++).fill(2).insets(0, 12, 0, 0);
        panelTf.add((Component)new JSeparator(0), gbc);
        panelTf.add((Component)labelPosition, GBC.eol().grid(0, y++));
        panelTf.add((Component)this.cbExifImg, GBC.eol().grid(1, y++));
        panelTf.add((Component)this.cbTaggedImg, GBC.eol().grid(1, y++));
        panelTf.add((Component)this.cbShowThumbs, GBC.eol().grid(0, y++));
        gbc = GBC.eol().fill(2).insets(0, 12, 0, 0);
        this.sepDirectionPosition = new JSeparator(0);
        gbc.gridy = y++;
        panelTf.add((Component)this.sepDirectionPosition, gbc);
        gbc = GBC.eol();
        gbc.gridwidth = 3;
        gbc.gridy = y++;
        this.pDirectionPosition = ImageDirectionPositionPanel.forGpxTrace();
        panelTf.add((Component)this.pDirectionPosition, gbc);
        this.expertPanel = new JPanel(new GridBagLayout());
        gbc = GBC.eol().grid(0, 0).fill(2).insets(0, 12, 0, 0);
        this.sepExtendedTags = new JSeparator(0);
        this.expertPanel.add((Component)this.sepExtendedTags, gbc);
        this.labelExtTags = new JLabel(I18n.tr("Extended tags", new Object[0]));
        this.cbAddGpsDatum = new JCheckBox(I18n.tr("Set datum for images coordinates", new Object[0]));
        this.cbAddGpsDatum.addActionListener(e -> this.tfDatum.setEnabled(!this.tfDatum.isEnabled()));
        this.labelDatum = new JLabel(I18n.tr("Datum: ", new Object[0]));
        this.tfDatum = new JosmTextField(CorrelateGpxWithImages.loadGpsDatum(), 8);
        this.tfDatum.setToolTipText(I18n.tr("<html>Enter the datum for your images coordinates. Default value is WGS-84.<br>For RTK it could be your local CRS epsg code.<br>(e.g. EPSG:9782 for France mainland.)</html>", new Object[0]));
        this.tfDatum.setEnabled(false);
        this.expertPanel.add((Component)this.labelExtTags, GBC.eol().grid(0, 1));
        this.expertPanel.add((Component)this.cbAddGpsDatum, GBC.eol().grid(0, 2));
        this.expertPanel.add((Component)this.labelDatum, GBC.std(1, 3));
        this.expertPanel.add((Component)this.tfDatum, GBC.eol().grid(2, 3));
        gbc = GBC.eol().fill(2).insets(0, 12, 0, 0);
        gbc.gridy = y++;
        panelTf.add((Component)this.expertPanel, gbc);
        JPanel statusPanel = new JPanel(new FlowLayout(1, 10, 10));
        statusPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBarText = new JLabel(" ");
        this.statusBarText.setFont(this.statusBarText.getFont().deriveFont(0, 12.0f));
        statusPanel.add(this.statusBarText);
        gbc = GBC.eol().fill(2).insets(20, 12, 20, 0);
        gbc.gridy = y;
        panelTf.add((Component)statusPanel, gbc);
        this.expertChanged(ExpertToggleAction.isExpert());
        RepaintTheMapListener repaintTheMap = new RepaintTheMapListener(this.yLayer);
        this.pDirectionPosition.addFocusListenerOnComponent(repaintTheMap);
        this.tfTimezone.addFocusListener(repaintTheMap);
        this.tfOffset.addFocusListener(repaintTheMap);
        this.tfTimezone.getDocument().addDocumentListener(this.statusBarUpdater);
        this.tfOffset.getDocument().addDocumentListener(this.statusBarUpdater);
        this.cbExifImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbTaggedImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbAddGpsDatum.addItemListener(this.statusBarUpdaterWithRepaint);
        this.tfDatum.getDocument().addDocumentListener(this.statusBarUpdater);
        this.pDirectionPosition.addChangeListenerOnComponents(this.statusBarUpdaterWithRepaint);
        this.pDirectionPosition.addItemListenerOnComponents(this.statusBarUpdaterWithRepaint);
        this.outerPanel = new JPanel(new BorderLayout());
        if (!GraphicsEnvironment.isHeadless()) {
            CorrelateGpxWithImages.forEachLayer(CorrelateGpxWithImages::closeDialog);
            this.syncDialog = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("Correlate", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.syncDialog.setContent(panelTf, false);
            this.syncDialog.setButtonIcons("ok", "cancel");
            this.syncDialog.setupDialog();
            this.outerPanel.add((Component)this.syncDialog.getContentPane(), "First");
            this.syncDialog.setContentPane(this.outerPanel);
            this.syncDialog.pack();
            this.syncDialog.addWindowListener(new SyncDialogWindowListener());
            this.syncDialog.showDialog();
            this.statusBarUpdater.matchAndUpdateStatusBar();
            this.yLayer.updateBufferAndRepaint();
        }
    }

    public GpxImageDatumSettings getSettings() {
        return new GpxImageDatumSettings(this.cbAddGpsDatum.isSelected(), this.tfDatum.getText());
    }

    @Override
    public void expertChanged(boolean isExpert) {
        if (this.buttonSupport != null) {
            this.buttonSupport.setVisible(isExpert);
        }
        if (this.sepDirectionPosition != null) {
            this.sepDirectionPosition.setVisible(isExpert);
        }
        if (this.pDirectionPosition != null) {
            this.pDirectionPosition.setVisible(isExpert);
        }
        if (this.expertPanel != null) {
            this.expertPanel.setVisible(isExpert);
        }
        if (this.syncDialog != null) {
            this.syncDialog.pack();
        }
    }

    private static void removeDuplicates(File file) {
        for (int i = gpxModel.getSize() - 1; i >= 0; --i) {
            GpxDataWrapper wrapper = gpxModel.getElementAt(i);
            if (!(wrapper instanceof NoGpxDataWrapper) && (file == null || !file.equals(wrapper.file))) continue;
            gpxModel.removeElement(wrapper);
        }
    }

    private static void forEachLayer(Consumer<CorrelateGpxWithImages> action) {
        MainApplication.getLayerManager().getLayersOfType(GeoImageLayer.class).forEach(geo -> action.accept(geo.getGpxCorrelateAction()));
    }

    void closeDialog() {
        if (this.syncDialog != null) {
            this.syncDialog.setVisible(false);
            new SyncDialogWindowListener().windowDeactivated(null);
            this.syncDialog.dispose();
            this.syncDialog = null;
        }
    }

    void repaintCombobox() {
        if (this.cbGpx != null) {
            this.cbGpx.repaint();
        }
    }

    static Pair<GpxTimezone, GpxTimeOffset> autoGuess(List<ImageEntry> imgs, GpxData gpx) throws NoGpxTimestamps {
        long firstExifDate = imgs.get(0).getExifInstant().toEpochMilli();
        long firstGPXDate = gpx.tracks.stream().flatMap(trk -> trk.getSegments().stream()).flatMap(segment -> segment.getWayPoints().stream()).filter(WayPoint::hasDate).map(WayPoint::getTimeInMillis).findFirst().orElseThrow(NoGpxTimestamps::new);
        return GpxTimeOffset.milliseconds(firstExifDate - firstGPXDate).splitOutTimezone();
    }

    private List<ImageEntry> getSortedImgList() {
        return this.yLayer.getSortedImgList(this.cbExifImg.isSelected(), this.cbTaggedImg.isSelected());
    }

    private static GpxDataWrapper selectedGPX(boolean complain) {
        Object item = gpxModel.getSelectedItem();
        if (item == null || ((GpxDataWrapper)item).data == null) {
            if (complain) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("You should select a GPX track", new Object[0]), I18n.tr("No selected GPX track", new Object[0]), 0);
            }
            return null;
        }
        return (GpxDataWrapper)item;
    }

    @Override
    public void destroy() {
        ExpertToggleAction.removeExpertModeChangeListener(this);
        if (this.cbGpx != null) {
            this.cbGpx.setModel(new DefaultComboBoxModel());
            this.cbGpx = null;
        }
        this.closeDialog();
        this.outerPanel = null;
        this.tfTimezone = null;
        this.tfOffset = null;
        this.cbExifImg = null;
        this.cbTaggedImg = null;
        this.cbShowThumbs = null;
        this.statusBarText = null;
        this.sepDirectionPosition = null;
        this.pDirectionPosition = null;
    }

    private final class AutoGuessActionListener
    implements ActionListener {
        private AutoGuessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GpxDataWrapper gpxW = CorrelateGpxWithImages.selectedGPX(true);
            if (gpxW == null) {
                return;
            }
            GpxData gpx = gpxW.data;
            List<ImageEntry> imgs = CorrelateGpxWithImages.this.getSortedImgList();
            try {
                Pair<GpxTimezone, GpxTimeOffset> r = CorrelateGpxWithImages.autoGuess(imgs, gpx);
                CorrelateGpxWithImages.this.timezone = (GpxTimezone)r.a;
                CorrelateGpxWithImages.this.delta = (GpxTimeOffset)r.b;
            }
            catch (IndexOutOfBoundsException ex) {
                Logging.debug(ex);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("The selected photos do not contain time information.", new Object[0]), I18n.tr("Photos do not contain time information", new Object[0]), 2);
                return;
            }
            catch (NoGpxTimestamps ex) {
                Logging.debug(ex);
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("The selected GPX track does not contain timestamps. Please select another one.", new Object[0]), I18n.tr("GPX Track has no time information", new Object[0]), 2);
                return;
            }
            CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
            CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
            CorrelateGpxWithImages.this.tfOffset.requestFocus();
            CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.statusBarUpdater.matchAndUpdateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    static class NoGpxTimestamps
    extends Exception {
        NoGpxTimestamps() {
        }
    }

    private final class AdjustActionListener
    implements ActionListener {
        private AdjustActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GpxTimeOffset offset = GpxTimeOffset.milliseconds(CorrelateGpxWithImages.this.delta.getMilliseconds() + Math.round(CorrelateGpxWithImages.this.timezone.getHours() * (double)TimeUnit.HOURS.toMillis(1L)));
            int dayOffset = offset.getDayOffset();
            Pair<GpxTimezone, GpxTimeOffset> timezoneOffsetPair = offset.withoutDayOffset().splitOutTimezone();
            AdjustTimezoneAndOffsetDialog.AdjustListener listener = (tz, min, sec) -> {
                CorrelateGpxWithImages.this.timezone = tz;
                CorrelateGpxWithImages.this.delta = GpxTimeOffset.milliseconds(100L * (long)sec + TimeUnit.MINUTES.toMillis(min) + TimeUnit.DAYS.toMillis(dayOffset));
                CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
                CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
                CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                CorrelateGpxWithImages.this.statusBarUpdater.matchAndUpdateStatusBar();
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                return CorrelateGpxWithImages.this.statusBarText.getText();
            };
            new AdjustTimezoneAndOffsetDialog((Component)MainApplication.getMainFrame(), (GpxTimezone)timezoneOffsetPair.a, (GpxTimeOffset)timezoneOffsetPair.b, dayOffset).adjustListener(listener).showDialog();
        }
    }

    static class RepaintTheMapListener
    implements FocusListener {
        private final GeoImageLayer yLayer;

        RepaintTheMapListener(GeoImageLayer yLayer) {
            this.yLayer = Objects.requireNonNull(yLayer);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            this.yLayer.updateBufferAndRepaint();
        }
    }

    private class StatusBarUpdater
    implements DocumentListener,
    ItemListener,
    ChangeListener,
    ActionListener,
    GpxData.GpxDataChangeListener {
        private final boolean doRepaint;

        StatusBarUpdater(boolean doRepaint) {
            this.doRepaint = doRepaint;
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.matchAndUpdateStatusBar();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.matchAndUpdateStatusBar();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.matchAndUpdateStatusBar();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.matchAndUpdateStatusBar();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.matchAndUpdateStatusBar();
        }

        @Override
        public void gpxDataChanged(GpxData.GpxDataChangeEvent e) {
            this.matchAndUpdateStatusBar();
        }

        public void matchAndUpdateStatusBar() {
            if (CorrelateGpxWithImages.this.syncDialog != null && CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                CorrelateGpxWithImages.this.statusBarText.setText(this.matchAndGetStatusText());
                if (this.doRepaint) {
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                }
            }
        }

        private String matchAndGetStatusText() {
            try {
                CorrelateGpxWithImages.this.timezone = GpxTimezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                CorrelateGpxWithImages.this.delta = GpxTimeOffset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                return e.getMessage();
            }
            CorrelateGpxWithImages.this.yLayer.discardTmp();
            List<ImageEntry> dateImgLst = CorrelateGpxWithImages.this.getSortedImgList();
            dateImgLst.forEach(ie -> ie.createTmp().unflagNewGpsData());
            GpxDataWrapper selGpx = CorrelateGpxWithImages.selectedGPX(false);
            if (selGpx == null) {
                return I18n.tr("No gpx selected", new Object[0]);
            }
            long offsetMs = (long)(CorrelateGpxWithImages.this.timezone.getHours() * (double)TimeUnit.HOURS.toMillis(1L)) + CorrelateGpxWithImages.this.delta.getMilliseconds();
            CorrelateGpxWithImages.this.lastNumMatched = GpxImageCorrelation.matchGpxTrack(dateImgLst, selGpx.data, CorrelateGpxWithImages.this.pDirectionPosition.isVisible() ? new GpxImageCorrelationSettings(offsetMs, forceTags, CorrelateGpxWithImages.this.pDirectionPosition.getSettings(), new GpxImageDatumSettings(CorrelateGpxWithImages.this.cbAddGpsDatum.isSelected(), CorrelateGpxWithImages.this.tfDatum.getText())) : new GpxImageCorrelationSettings(offsetMs, forceTags));
            return I18n.trn("<html>Matched <b>{0}</b> of <b>{1}</b> photo to GPX track.</html>", "<html>Matched <b>{0}</b> of <b>{1}</b> photos to GPX track.</html>", dateImgLst.size(), CorrelateGpxWithImages.this.lastNumMatched, dateImgLst.size());
        }
    }

    private static class GpxLayerRenamedListener
    implements PropertyChangeListener {
        private final GpxDataWrapper gdw;

        GpxLayerRenamedListener(GpxDataWrapper gdw) {
            this.gdw = gdw;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (Layer.NAME_PROP.equals(e.getPropertyName())) {
                this.gdw.setName(e.getNewValue().toString());
            }
        }
    }

    private static final class GpxLayerAddedListener
    implements LayerManager.LayerChangeListener {
        private GpxLayerAddedListener() {
        }

        @Override
        public void layerAdded(LayerManager.LayerAddEvent e) {
            Layer layer = e.getAddedLayer();
            if (layer instanceof GpxDataContainer) {
                GpxData gpx = ((GpxDataContainer)((Object)layer)).getGpxData();
                File file = gpx.storageFile;
                CorrelateGpxWithImages.removeDuplicates(file);
                GpxDataWrapper gdw = new GpxDataWrapper(layer.getName(), gpx, file);
                layer.addPropertyChangeListener(new GpxLayerRenamedListener(gdw));
                gpxModel.addElement(gdw);
                CorrelateGpxWithImages.forEachLayer(correlateAction -> {
                    correlateAction.repaintCombobox();
                    if (layer.equals(correlateAction.supportLayer)) {
                        correlateAction.buttonSupport.setEnabled(false);
                    }
                });
            }
        }

        @Override
        public void layerRemoving(LayerManager.LayerRemoveEvent e) {
            Layer layer = e.getRemovedLayer();
            if (layer instanceof GpxDataContainer) {
                GpxData removedGpxData = ((GpxDataContainer)((Object)layer)).getGpxData();
                for (int i = gpxModel.getSize() - 1; i >= 0; --i) {
                    GpxData data = CorrelateGpxWithImages.gpxModel.getElementAt((int)i).data;
                    if (!data.equals(removedGpxData) && (removedGpxData != null || !data.isEmpty())) continue;
                    gpxModel.removeElementAt(i);
                    CorrelateGpxWithImages.forEachLayer(correlateAction -> {
                        correlateAction.repaintCombobox();
                        if (layer.equals(correlateAction.supportLayer)) {
                            correlateAction.supportLayer.getGpxData().removeChangeListener(correlateAction.statusBarUpdaterWithRepaint);
                            correlateAction.supportLayer = null;
                            correlateAction.buttonSupport.setEnabled(true);
                        }
                    });
                    break;
                }
            }
        }

        @Override
        public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
        }
    }

    private final class SetOffsetActionListener
    implements ActionListener {
        private SetOffsetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isOk = false;
            while (!isOk) {
                long delta;
                SynchronizeTimeFromPhotoDialog ed = new SynchronizeTimeFromPhotoDialog((Component)MainApplication.getMainFrame(), CorrelateGpxWithImages.this.yLayer.getImageData().getImages());
                int answer = ed.showDialog().getValue();
                if (answer != 1) {
                    return;
                }
                try {
                    delta = ed.getDelta();
                }
                catch (ParseException ex) {
                    JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Error while parsing the date.\nPlease use the requested format", new Object[0]), I18n.tr("Invalid date", new Object[0]), 0);
                    continue;
                }
                SynchronizeTimeFromPhotoDialog.TimeZoneItem selectedTz = ed.getTimeZoneItem();
                Config.getPref().put("geoimage.timezoneid", selectedTz.getID());
                Config.getPref().putBoolean("geoimage.timezoneid.dst", ed.isDstSelected());
                CorrelateGpxWithImages.this.tfOffset.setText(GpxTimeOffset.milliseconds(delta).formatOffset());
                CorrelateGpxWithImages.this.tfTimezone.setText(selectedTz.getFormattedString());
                isOk = true;
            }
            CorrelateGpxWithImages.this.statusBarUpdater.matchAndUpdateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private final class AdvancedSettingsActionListener
    implements ActionListener {
        private AdvancedSettingsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AdvancedCorrelationSettingsDialog ed = new AdvancedCorrelationSettingsDialog((Component)MainApplication.getMainFrame(), forceTags);
            if (ed.showDialog().getValue() == 1) {
                forceTags = ed.isForceTaggingSelected();
                CorrelateGpxWithImages.this.statusBarUpdater.matchAndUpdateStatusBar();
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }
    }

    private final class UseSupportLayerActionListener
    implements ActionListener {
        private UseSupportLayerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Optional.ofNullable(CorrelateGpxWithImages.selectedGPX(true)).ifPresent(gpx -> {
                CorrelateGpxWithImages.this.supportLayer = new CorrelationSupportLayer(gpx.data);
                CorrelateGpxWithImages.this.supportLayer.getGpxData().addChangeListener(CorrelateGpxWithImages.this.statusBarUpdaterWithRepaint);
                MainApplication.getLayerManager().addLayer(CorrelateGpxWithImages.this.supportLayer);
            });
        }
    }

    private final class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            File sel = GpxDataHelper.chooseGpxDataFile();
            if (sel != null) {
                try {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    CorrelateGpxWithImages.removeDuplicates(sel);
                    GpxData data = GpxDataHelper.loadGpxData(sel);
                    if (data != null) {
                        GpxDataWrapper elem = new GpxDataWrapper(sel.getName(), data, sel);
                        gpxModel.addElement(elem);
                        gpxModel.setSelectedItem(elem);
                        CorrelateGpxWithImages.this.statusBarUpdater.matchAndUpdateStatusBar();
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    private static class NoGpxDataWrapper
    extends GpxDataWrapper {
        NoGpxDataWrapper() {
            super(null, null, null);
        }

        @Override
        public String toString() {
            return I18n.tr("<No GPX track loaded yet>", new Object[0]);
        }
    }

    private static class GpxDataWrapper {
        private String name;
        private final GpxData data;
        private final File file;

        GpxDataWrapper(String name, GpxData data, File file) {
            this.name = name;
            this.data = data;
            this.file = file;
        }

        void setName(String name) {
            this.name = name;
            CorrelateGpxWithImages.forEachLayer(CorrelateGpxWithImages::repaintCombobox);
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SyncDialogWindowListener
    extends WindowAdapter {
        private static final int CANCEL = -1;
        private static final int DONE = 0;
        private static final int AGAIN = 1;
        private static final int NOTHING = 2;

        private SyncDialogWindowListener() {
        }

        private int checkAndSave() {
            if (CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                return 2;
            }
            int answer = CorrelateGpxWithImages.this.syncDialog.getValue();
            if (answer != 1) {
                return -1;
            }
            try {
                CorrelateGpxWithImages.this.timezone = GpxTimezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getMessage(), I18n.tr("Invalid timezone", new Object[0]), 0);
                return 1;
            }
            try {
                CorrelateGpxWithImages.this.delta = GpxTimeOffset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException e) {
                JOptionPane.showMessageDialog(MainApplication.getMainFrame(), e.getMessage(), I18n.tr("Invalid offset", new Object[0]), 0);
                return 1;
            }
            if (CorrelateGpxWithImages.this.lastNumMatched == 0 && new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Correlate images with GPX track", new Object[0]), I18n.tr("OK", new Object[0]), I18n.tr("Try Again", new Object[0])).setContent(I18n.tr("No images could be matched!", new Object[0])).setButtonIcons("ok", "dialogs/refresh").showDialog().getValue() == 2) {
                return 1;
            }
            return 0;
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
            int result = this.checkAndSave();
            switch (result) {
                case 2: {
                    break;
                }
                case -1: {
                    if (CorrelateGpxWithImages.this.yLayer != null) {
                        CorrelateGpxWithImages.this.yLayer.discardTmp();
                        CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    }
                    if (!Config.getPref().getBoolean("geoimage.supportlayer.delete_on_close", true)) break;
                    CorrelateGpxWithImages.this.removeSupportLayer();
                    break;
                }
                case 1: {
                    CorrelateGpxWithImages.this.actionPerformed(null);
                    break;
                }
                case 0: {
                    Config.getPref().put("geoimage.timezone", CorrelateGpxWithImages.this.timezone.formatTimezone());
                    Config.getPref().put("geoimage.delta", CorrelateGpxWithImages.this.delta.formatOffset());
                    Config.getPref().putBoolean("geoimage.showThumbs", CorrelateGpxWithImages.this.yLayer.useThumbs);
                    Config.getPref().put("geoimage.datum", CorrelateGpxWithImages.this.tfDatum.getText());
                    CorrelateGpxWithImages.this.yLayer.useThumbs = CorrelateGpxWithImages.this.cbShowThumbs.isSelected();
                    CorrelateGpxWithImages.this.yLayer.startLoadThumbs();
                    boolean boundingBoxedLayerFound = false;
                    for (Layer l : MainApplication.getLayerManager().getLayers()) {
                        if (l == CorrelateGpxWithImages.this.yLayer) continue;
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        l.visitBoundingBox(bbox);
                        if (bbox.getBounds() == null) continue;
                        boundingBoxedLayerFound = true;
                        break;
                    }
                    if (!boundingBoxedLayerFound) {
                        BoundingXYVisitor bbox = new BoundingXYVisitor();
                        CorrelateGpxWithImages.this.yLayer.visitBoundingBox(bbox);
                        MainApplication.getMap().mapView.zoomTo(bbox);
                    }
                    CorrelateGpxWithImages.this.yLayer.applyTmp();
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    if (!Config.getPref().getBoolean("geoimage.supportlayer.delete_on_close", true)) break;
                    CorrelateGpxWithImages.this.removeSupportLayer();
                    break;
                }
                default: {
                    throw new IllegalStateException(Integer.toString(result));
                }
            }
        }
    }
}

