/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileUtils;

public final class ProcessJsAnnotationsTask
extends Task {
    private File classes;
    private Path cp;
    private File asm;

    public void setClasses(File f) {
        this.classes = f;
    }

    public void setAsm(File f) {
        this.asm = f;
    }

    public Path createClasspath() {
        if (this.cp == null) {
            this.cp = new Path(this.getProject());
        }
        return this.cp.createPath();
    }

    public void execute() throws BuildException {
        if (this.classes == null) {
            throw new BuildException("root of classes must be specified!");
        }
        File master = new File(new File(this.classes, "META-INF"), "net.java.html.js.classes");
        if (!master.exists()) {
            return;
        }
        LinkedList<URL> arr = new LinkedList<URL>();
        boolean foundAsm = false;
        for (String s : this.cp.list()) {
            File f = FileUtils.getFileUtils().resolveFile(this.getProject().getBaseDir(), s);
            if (f == null) continue;
            if (f.getName().contains("asm")) {
                foundAsm = true;
            }
            try {
                arr.add(f.toURI().toURL());
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if (!foundAsm) {
            URL loc;
            if (this.asm == null || !this.asm.exists()) {
                throw new BuildException("Cannot find asm!");
            }
            try {
                loc = this.asm.toURI().toURL();
            }
            catch (MalformedURLException ex) {
                throw new BuildException((Throwable)ex);
            }
            arr.addFirst(loc);
        }
        try {
            arr.addFirst(this.classes.toURI().toURL());
            URLClassLoader l = new URLClassLoader(arr.toArray(new URL[arr.size()]));
            this.processClasses(l, master, this.classes);
        }
        catch (IOException ex) {
            throw new BuildException("Problem converting JavaScriptXXX annotations", (Throwable)ex);
        }
    }

    private void processClasses(ClassLoader l, File master, File f) throws IOException {
        if (!f.exists()) {
            return;
        }
        if (f.isDirectory()) {
            boolean classes = new File(f, "net.java.html.js.classes").exists();
            File[] arr = f.listFiles();
            if (arr != null) {
                for (File file : arr) {
                    if (!classes && !file.isDirectory()) continue;
                    this.processClasses(l, master, file);
                }
            }
            return;
        }
        if (!f.getName().endsWith(".class")) {
            return;
        }
        byte[] arr = new byte[(int)f.length()];
        try (FileInputStream is = new FileInputStream(f);){
            ProcessJsAnnotationsTask.readArr(arr, is);
        }
        byte[] newArr = null;
        try {
            Class<?> fnUtils = l.loadClass("org.netbeans.html.boot.impl.FnUtils");
            Method transform = fnUtils.getMethod("transform", byte[].class, ClassLoader.class);
            newArr = (byte[])transform.invoke(null, arr, l);
            if (newArr == null || newArr == arr) {
                return;
            }
            ProcessJsAnnotationsTask.filterClass(new File(f.getParentFile(), "net.java.html.js.classes"), f.getName());
            ProcessJsAnnotationsTask.filterClass(master, f.getName());
        }
        catch (Exception ex) {
            throw new BuildException("Can't process " + f, (Throwable)ex);
        }
        this.log("Processing " + f, 2);
        this.writeArr(f, newArr);
    }

    private void writeArr(File f, byte[] newArr) throws IOException, FileNotFoundException {
        try (FileOutputStream os = new FileOutputStream(f);){
            os.write(newArr);
        }
    }

    private static void readArr(byte[] arr, InputStream is) throws IOException {
        int read;
        for (int off = 0; off < arr.length && (read = is.read(arr, off, arr.length - off)) != -1; off += read) {
        }
    }

    private static void filterClass(File f, String className) throws IOException {
        if (!f.exists()) {
            return;
        }
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        ArrayList<String> arr = new ArrayList<String>();
        boolean modified = false;
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String line;
            while ((line = r.readLine()) != null) {
                if (line.endsWith(className)) {
                    modified = true;
                    continue;
                }
                arr.add(line);
            }
        }
        if (modified) {
            if (arr.isEmpty()) {
                f.delete();
            } else {
                var5_5 = null;
                try (FileWriter w = new FileWriter(f);){
                    for (String l : arr) {
                        w.write(l);
                        w.write("\n");
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
            }
        }
    }
}

