/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.PlatformManager;

public class SlippyMapController
extends MouseAdapter {
    private static final Timer TIMER = new Timer(true);
    private MoveTask moveTask = new MoveTask();
    private static final long timerInterval = 20L;
    private static final double MAX_SPEED = 20.0;
    private static final double ACCELERATION = 0.1;
    private static final int MAC_MOUSE_BUTTON3_MASK = 1152;
    private static final String[] N = new String[]{",", ".", "up", "right", "down", "left"};
    private static final int[] K = new int[]{44, 46, 38, 39, 40, 37};
    private Point iStartSelectionPoint;
    private Point iEndSelectionPoint;
    private final SlippyMapBBoxChooser iSlippyMapChooser;
    private boolean isSelecting;

    public SlippyMapController(SlippyMapBBoxChooser navComp, JPanel contentPane) {
        this.iSlippyMapChooser = navComp;
        this.iSlippyMapChooser.addMouseListener(this);
        this.iSlippyMapChooser.addMouseMotionListener(this);
        if (contentPane != null) {
            for (int i = 0; i < N.length; ++i) {
                contentPane.getInputMap(2).put(KeyStroke.getKeyStroke(K[i], 128), "MapMover.Zoomer." + N[i]);
            }
        }
        this.isSelecting = false;
        InputMap inputMap = navComp.getInputMap(2);
        ActionMap actionMap = navComp.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "MOVE_RIGHT");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "MOVE_LEFT");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, false), "MOVE_UP");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, false), "MOVE_DOWN");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, true), "STOP_MOVE_HORIZONTALLY");
        inputMap.put(KeyStroke.getKeyStroke(37, 0, true), "STOP_MOVE_HORIZONTALLY");
        inputMap.put(KeyStroke.getKeyStroke(38, 0, true), "STOP_MOVE_VERTICALLY");
        inputMap.put(KeyStroke.getKeyStroke(40, 0, true), "STOP_MOVE_VERTICALLY");
        inputMap.put(KeyStroke.getKeyStroke(38, 128, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(38, 256, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(38, 512, false), "ZOOM_IN");
        inputMap.put(KeyStroke.getKeyStroke(107, 0, false), "ZOOM_IN_UNLESS_TYPING");
        inputMap.put(KeyStroke.getKeyStroke(521, 0, false), "ZOOM_IN_UNLESS_TYPING");
        inputMap.put(KeyStroke.getKeyStroke(61, 0, false), "ZOOM_IN_UNLESS_TYPING");
        inputMap.put(KeyStroke.getKeyStroke(61, 64, false), "ZOOM_IN_UNLESS_TYPING");
        inputMap.put(KeyStroke.getKeyStroke(40, 128, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(40, 256, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(40, 512, false), "ZOOM_OUT");
        inputMap.put(KeyStroke.getKeyStroke(109, 0, false), "ZOOM_OUT_UNLESS_TYPING");
        inputMap.put(KeyStroke.getKeyStroke(45, 0, false), "ZOOM_OUT_UNLESS_TYPING");
        actionMap.put("MOVE_RIGHT", new MoveXAction(1));
        actionMap.put("MOVE_LEFT", new MoveXAction(-1));
        actionMap.put("MOVE_UP", new MoveYAction(-1));
        actionMap.put("MOVE_DOWN", new MoveYAction(1));
        actionMap.put("STOP_MOVE_HORIZONTALLY", new MoveXAction(0));
        actionMap.put("STOP_MOVE_VERTICALLY", new MoveYAction(0));
        actionMap.put("ZOOM_IN", new ZoomInAction(false));
        actionMap.put("ZOOM_IN_UNLESS_TYPING", new ZoomInAction(true));
        actionMap.put("ZOOM_OUT", new ZoomOutAction(false));
        actionMap.put("ZOOM_OUT_UNLESS_TYPING", new ZoomOutAction(true));
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!(e.getButton() != 1 || PlatformManager.isPlatformOsx() && e.getModifiersEx() == 1152)) {
            this.iStartSelectionPoint = e.getPoint();
            this.iEndSelectionPoint = e.getPoint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!(this.iStartSelectionPoint == null || (e.getModifiersEx() & 0x400) != 1024 || PlatformManager.isPlatformOsx() && e.getModifiersEx() == 1152)) {
            this.iEndSelectionPoint = e.getPoint();
            this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, this.iEndSelectionPoint);
            this.isSelecting = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            if (this.isSelecting && e.getClickCount() == 1) {
                this.iSlippyMapChooser.setSelection(this.iStartSelectionPoint, e.getPoint());
                this.iEndSelectionPoint = null;
                this.iStartSelectionPoint = null;
                this.isSelecting = false;
            } else {
                this.iSlippyMapChooser.handleAttribution(e.getPoint(), true);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.iSlippyMapChooser.handleMouseMoved(e.getPoint());
        this.iSlippyMapChooser.handleAttribution(e.getPoint(), false);
    }

    static boolean isTyping() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner() instanceof JTextComponent;
    }

    private final class ZoomOutAction
    extends AbstractAction {
        private boolean suppressWhileTyping;

        ZoomOutAction(boolean suppressWhileTyping) {
            this.suppressWhileTyping = suppressWhileTyping;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.suppressWhileTyping && SlippyMapController.isTyping()) {
                return;
            }
            SlippyMapController.this.iSlippyMapChooser.zoomOut();
        }
    }

    private final class ZoomInAction
    extends AbstractAction {
        private boolean suppressWhileTyping;

        ZoomInAction(boolean suppressWhileTyping) {
            this.suppressWhileTyping = suppressWhileTyping;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.suppressWhileTyping && SlippyMapController.isTyping()) {
                return;
            }
            SlippyMapController.this.iSlippyMapChooser.zoomIn();
        }
    }

    private final class MoveTask
    extends TimerTask {
        private double speedX = 1.0;
        private double speedY = 1.0;
        private int directionX;
        private int directionY;
        boolean scheduled;

        private MoveTask() {
        }

        void setDirectionX(int directionX) {
            this.directionX = directionX;
            this.updateScheduleStatus();
        }

        void setDirectionY(int directionY) {
            this.directionY = directionY;
            this.updateScheduleStatus();
        }

        private void updateScheduleStatus() {
            boolean newMoveTaskState;
            boolean bl = newMoveTaskState = this.directionX != 0 || this.directionY != 0;
            if (newMoveTaskState != this.scheduled) {
                this.scheduled = newMoveTaskState;
                if (newMoveTaskState) {
                    TIMER.schedule((TimerTask)this, 0L, 20L);
                } else {
                    SlippyMapController.this.moveTask = new MoveTask();
                    this.cancel();
                }
            }
        }

        @Override
        public void run() {
            switch (this.directionX) {
                case -1: {
                    if (this.speedX > -1.0) {
                        this.speedX = -1.0;
                    }
                    if (!(this.speedX > -20.0)) break;
                    this.speedX -= 0.1;
                    break;
                }
                case 0: {
                    this.speedX = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedX < 1.0) {
                        this.speedX = 1.0;
                    }
                    if (!(this.speedX < 20.0)) break;
                    this.speedX += 0.1;
                    break;
                }
                default: {
                    throw new IllegalStateException(Integer.toString(this.directionX));
                }
            }
            switch (this.directionY) {
                case -1: {
                    if (this.speedY > -1.0) {
                        this.speedY = -1.0;
                    }
                    if (!(this.speedY > -20.0)) break;
                    this.speedY -= 0.1;
                    break;
                }
                case 0: {
                    this.speedY = 0.0;
                    break;
                }
                case 1: {
                    if (this.speedY < 1.0) {
                        this.speedY = 1.0;
                    }
                    if (!(this.speedY < 20.0)) break;
                    this.speedY += 0.1;
                    break;
                }
                default: {
                    throw new IllegalStateException(Integer.toString(this.directionY));
                }
            }
            int moveX = (int)Math.floor(this.speedX);
            int moveY = (int)Math.floor(this.speedY);
            if (moveX != 0 || moveY != 0) {
                SlippyMapController.this.iSlippyMapChooser.moveMap(moveX, moveY);
            }
        }
    }

    private class MoveYAction
    extends AbstractAction {
        private final int direction;

        MoveYAction(int direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SlippyMapController.this.moveTask.setDirectionY(this.direction);
        }
    }

    private class MoveXAction
    extends AbstractAction {
        private final int direction;

        MoveXAction(int direction) {
            this.direction = direction;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SlippyMapController.this.moveTask.setDirectionX(this.direction);
        }
    }
}

