/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelationMember;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.tools.AlphanumComparator;

public class RelationSorter {
    private static final Collection<AdditionalSorter> ADDITIONAL_SORTERS = Arrays.asList(new AssociatedStreetRoleStreetSorter(), new AssociatedStreetRoleAddressHouseSorter(), new PublicTransportRoleStopPlatformSorter(), new FromViaToSorter());

    public List<RelationMember> sortMembers(List<RelationMember> relationMembers) {
        ArrayList<RelationMember> newMembers = new ArrayList<RelationMember>();
        ArrayList<RelationMember> defaultMembers = new ArrayList<RelationMember>(relationMembers.size());
        LinkedHashMap<AdditionalSorter, List> customMap = new LinkedHashMap<AdditionalSorter, List>();
        for (RelationMember relationMember : relationMembers) {
            boolean wasAdded = false;
            for (AdditionalSorter sorter : ADDITIONAL_SORTERS) {
                if (!sorter.acceptsMember(relationMembers, relationMember)) continue;
                wasAdded = customMap.computeIfAbsent(sorter, k -> new LinkedList()).add(relationMember);
                break;
            }
            if (wasAdded) continue;
            defaultMembers.add(relationMember);
        }
        for (Map.Entry entry : customMap.entrySet()) {
            newMembers.addAll(((AdditionalSorter)entry.getKey()).sortMembers((List)entry.getValue()));
        }
        newMembers.addAll(RelationSorter.sortMembersByConnectivity(defaultMembers));
        return newMembers;
    }

    public static <T extends IRelationMember<? extends IPrimitive>> List<T> sortMembersByConnectivity(List<T> defaultMembers) {
        Integer first;
        RelationNodeMap<T> map = new RelationNodeMap<T>(defaultMembers);
        ArrayList allGroups = new ArrayList();
        while ((first = map.pop()) != null) {
            LinkedList<Integer> group = new LinkedList<Integer>();
            group.add(first);
            allGroups.add(group);
            Integer next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addLast(next);
            }
            next = first;
            while ((next = map.popAdjacent(next)) != null) {
                group.addFirst(next);
            }
        }
        List newMembers = allGroups.stream().flatMap(Collection::stream).map(defaultMembers::get).collect(Collectors.toList());
        for (Integer i : map.getNotSortableMembers()) {
            newMembers.add((IRelationMember)defaultMembers.get(i));
        }
        return newMembers;
    }

    private static final class FromViaToSorter
    implements AdditionalSorter {
        private static final List<String> ROLES = Arrays.asList("from", "via", "to");

        private FromViaToSorter() {
        }

        @Override
        public boolean acceptsMember(List<RelationMember> relationMembers, RelationMember m) {
            return ROLES.contains(m.getRole()) && relationMembers.stream().map(RelationMember::getRole).collect(Collectors.toSet()).containsAll(ROLES);
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            list.sort(Comparator.comparingInt(m -> ROLES.indexOf(m.getRole())));
            return list;
        }
    }

    private static final class PublicTransportRoleStopPlatformSorter
    implements AdditionalSorter {
        private PublicTransportRoleStopPlatformSorter() {
        }

        @Override
        public boolean acceptsMember(List<RelationMember> relationMembers, RelationMember m) {
            return m.getRole() != null && (m.getRole().startsWith("platform") || m.getRole().startsWith("stop"));
        }

        private static String getStopName(OsmPrimitive p) {
            return p.referrers(Relation.class).filter(ref -> ref.hasTag("type", "public_transport") && ref.hasTag("public_transport", "stop_area") && ref.getName() != null).map(IPrimitive::getName).findFirst().orElse(p.getName());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            HashMap platformByName = new HashMap();
            if (list.stream().filter(i -> i.getRole().startsWith("platform")).map(i -> platformByName.put(PublicTransportRoleStopPlatformSorter.getStopName(i.getMember()), i)).anyMatch(Objects::nonNull)) {
                return list;
            }
            ArrayList<RelationMember> sorted = new ArrayList<RelationMember>(list.size());
            for (RelationMember i2 : list) {
                if (!i2.getRole().startsWith("stop")) continue;
                sorted.add(i2);
                RelationMember platform = (RelationMember)platformByName.remove(PublicTransportRoleStopPlatformSorter.getStopName(i2.getMember()));
                if (platform == null) continue;
                sorted.add(platform);
            }
            sorted.addAll(platformByName.values());
            return sorted;
        }
    }

    private static final class AssociatedStreetRoleAddressHouseSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleAddressHouseSorter() {
        }

        @Override
        public boolean acceptsMember(List<RelationMember> relationMembers, RelationMember m) {
            return m.hasRole("address", "house");
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            list.sort((a, b) -> {
                int houseNumber = AlphanumComparator.getInstance().compare(a.getMember().get("addr:housenumber"), b.getMember().get("addr:housenumber"));
                if (houseNumber != 0) {
                    return houseNumber;
                }
                String aDisplayName = a.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                String bDisplayName = b.getMember().getDisplayName(DefaultNameFormatter.getInstance());
                return AlphanumComparator.getInstance().compare(aDisplayName, bDisplayName);
            });
            return list;
        }
    }

    private static final class AssociatedStreetRoleStreetSorter
    implements AdditionalSorter {
        private AssociatedStreetRoleStreetSorter() {
        }

        @Override
        public boolean acceptsMember(List<RelationMember> relationMembers, RelationMember m) {
            return "street".equals(m.getRole());
        }

        @Override
        public List<RelationMember> sortMembers(List<RelationMember> list) {
            return RelationSorter.sortMembersByConnectivity(list);
        }
    }

    private static interface AdditionalSorter {
        public boolean acceptsMember(List<RelationMember> var1, RelationMember var2);

        public List<RelationMember> sortMembers(List<RelationMember> var1);
    }
}

