/*
 * Decompiled with CFR 0.152.
 */
package uk.org.webcompere.systemstubs;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.concurrent.Callable;
import uk.org.webcompere.systemstubs.ThrowingRunnable;
import uk.org.webcompere.systemstubs.environment.EnvironmentVariables;
import uk.org.webcompere.systemstubs.properties.SystemProperties;
import uk.org.webcompere.systemstubs.resource.Resources;
import uk.org.webcompere.systemstubs.resource.TestResource;
import uk.org.webcompere.systemstubs.security.NoExitSecurityManager;
import uk.org.webcompere.systemstubs.security.SecurityManagerStub;
import uk.org.webcompere.systemstubs.security.SystemExit;
import uk.org.webcompere.systemstubs.stream.SystemErr;
import uk.org.webcompere.systemstubs.stream.SystemErrAndOut;
import uk.org.webcompere.systemstubs.stream.SystemIn;
import uk.org.webcompere.systemstubs.stream.SystemOut;
import uk.org.webcompere.systemstubs.stream.input.LinesAltStream;
import uk.org.webcompere.systemstubs.stream.output.DisallowWriteStream;
import uk.org.webcompere.systemstubs.stream.output.NoopStream;
import uk.org.webcompere.systemstubs.stream.output.Output;

public class SystemStubs {
    public static void assertNothingWrittenToSystemErr(ThrowingRunnable throwingRunnable) throws Exception {
        new SystemErr(new DisallowWriteStream()).execute(throwingRunnable);
    }

    public static void assertNothingWrittenToSystemOut(ThrowingRunnable throwingRunnable) throws Exception {
        new SystemOut(new DisallowWriteStream()).execute(throwingRunnable);
    }

    public static void assertNothingWrittenToSystemErrOrOut(ThrowingRunnable throwingRunnable) throws Exception {
        new SystemErrAndOut(new DisallowWriteStream()).execute(throwingRunnable);
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"})
    public static int catchSystemExit(ThrowingRunnable throwingRunnable) throws Exception {
        SystemExit exit = new SystemExit();
        exit.execute(throwingRunnable);
        return ((NoExitSecurityManager)exit.getSecurityManager()).checkSystemExit();
    }

    public static void muteSystemErr(ThrowingRunnable throwingRunnable) throws Exception {
        new SystemErr(new NoopStream()).execute(throwingRunnable);
    }

    public static void muteSystemOut(ThrowingRunnable throwingRunnable) throws Exception {
        new SystemOut(new NoopStream()).execute(throwingRunnable);
    }

    public static void restoreSystemProperties(ThrowingRunnable throwingRunnable) throws Exception {
        new SystemProperties().execute(throwingRunnable.asCallable());
    }

    public static String tapSystemErr(ThrowingRunnable throwingRunnable) throws Exception {
        SystemErr systemErr = SystemStubs.executeInTappedSystemError(throwingRunnable);
        return systemErr.getText();
    }

    private static SystemErr executeInTappedSystemError(ThrowingRunnable throwingRunnable) throws Exception {
        SystemErr systemErr = new SystemErr();
        systemErr.execute(throwingRunnable);
        return systemErr;
    }

    private static SystemOut executeInTappedSystemOut(ThrowingRunnable throwingRunnable) throws Exception {
        SystemOut systemOut = new SystemOut();
        systemOut.execute(throwingRunnable);
        return systemOut;
    }

    public static String tapSystemErrNormalized(ThrowingRunnable throwingRunnable) throws Exception {
        return SystemStubs.executeInTappedSystemError(throwingRunnable).getLinesNormalized();
    }

    public static String tapSystemOut(ThrowingRunnable throwingRunnable) throws Exception {
        SystemOut systemOut = new SystemOut();
        systemOut.execute(throwingRunnable);
        return systemOut.getText();
    }

    public static String tapSystemOutNormalized(ThrowingRunnable throwingRunnable) throws Exception {
        return SystemStubs.executeInTappedSystemOut(throwingRunnable).getLinesNormalized();
    }

    public static SystemOut withTapSystemOut() {
        return new SystemOut();
    }

    public static SystemErrAndOut withTapSystemErrAndOut() {
        return new SystemErrAndOut();
    }

    public static SystemErrAndOut withSystemErrAndOut(Output output) {
        return new SystemErrAndOut(output);
    }

    public static String tapSystemErrAndOut(ThrowingRunnable throwingRunnable) throws Exception {
        SystemErrAndOut tappedSystem = SystemStubs.withTapSystemErrAndOut();
        tappedSystem.execute(throwingRunnable);
        return tappedSystem.getText();
    }

    public static EnvironmentVariables withEnvironmentVariable(String name, String value) {
        return new EnvironmentVariables(Collections.singletonMap(name, value));
    }

    public static EnvironmentVariables withEnvironmentVariables(String name, String value, String ... values) {
        return new EnvironmentVariables(name, value, values);
    }

    public static EnvironmentVariables withEnvironmentVariables() {
        return new EnvironmentVariables();
    }

    public static <T> T execute(Callable<T> callable, TestResource ... resources) throws Exception {
        return Resources.execute(callable, resources);
    }

    public static void execute(ThrowingRunnable runnable, TestResource ... resources) throws Exception {
        Resources.execute(runnable.asCallable(), resources);
    }

    public static void withSecurityManager(SecurityManager securityManager, ThrowingRunnable throwingRunnable) throws Exception {
        new SecurityManagerStub<SecurityManager>(securityManager).execute(throwingRunnable.asCallable());
    }

    public static SystemIn withTextFromSystemIn(String ... lines) {
        return new SystemIn(new LinesAltStream(lines));
    }
}

