#include <sys/emx.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <sys/doscalls.h>

int __ioctl2 (int handle, int request, int arg)
{
    int attr;

    attr = dos_ioctl_getattr(handle);
    if (attr == -1) {
	return -1;
    }

    if (request == FGETHTYPE) {
	if (!(attr & 128))
	    attr = HT_FILE;
	else if (attr & 3)
	    attr = HT_DEV_CON;
	else if (attr & 4)
	    attr = HT_DEV_NUL;
	else if (attr & 8)
	    attr = HT_DEV_CLK;
	else
	    attr = HT_DEV_OTHER;

	* (int *) arg = attr;
	return 0;
    }
    else if (request >= TCGETA && request <= TCFLSH) {
	errno = EINVAL;
	return -1;
    }
    else if (request == FIONREAD) {
	errno = EINVAL;
	return -1;
    }
    else {
	errno = EINVAL;
	return -1;
    }
}
