{$IFDEF WINDOWS}
{$N-,V-}
{$ELSE}
{$N-,E-,V-,O+,F+}
{$ENDIF}

Unit biblist;

Interface

uses
{$IFDEF WINDOWS}
  WinDos, wbibdisp, wbibgui, wbibslct,
{$ELSE}
  bibwindo, Dos, bibCrt, BibMouse, bibdisp, bibselct,
{$ENDIF}
  bibstrg, bibreadb, bibvars, bibfile, bibutil, bibreach, bibtmplt, bibcache;


procedure ShowEntryList(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        Var Chosen,found: boolean);
procedure ShowOverview(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       Var FromBeginning,chosen,found: Boolean);

Implementation

procedure ShowEntryList(Entry: EntryRecPtr; Pattern: PatRecPtr;
                        Var Chosen,found: boolean);
type
  PlacesType = array[1..MaxListArr] of longint;
var
  ns,icode,i: integer;
  ntime,n,nabs,gt,gtnumber: longint;
  OPlace: longint;
  OldRealNum,OEntry,Initial,OnScreen,NumCols,NumToMake,In2: Word;
  ok,PgUp,PgDn,FromBeginning,FirstDisplay,UseTheIndex: boolean;
  line,gtname,tmp : string;
  fields : FieldArr;
  EntryList: ListArrPtr2;
  Spec : SpecArr;
  enums: array[1..MaxListArr,1..2] of Word;
  places: ^PlacesType;
  Srec: SortRecType;

procedure NextScreen(var ok: boolean);
var
  LastEnt: longint;
begin
  n:=1; ok:=true; AbortFlag:=false;
  while ok and (n<=onscreen) and (entry^.entrynum=nabs) do
  begin
    EntryList^[n]:=entry^.name;
    enums[n,1]:=entry^.entrynum;
    enums[n,2]:=entry^.realnum;
    if places<>Nil then places^[n]:=entry^.beginning;
    LastEnt:=Entry^.EntryNum;
    inc(n); inc(nabs);
    GetEntry(Entry,Nil,nabs,false,Pattern,ok);
  end;
  if (Entry^.EntryNum<Nabs) and not AbortFlag then
    EntryCache^.SetLast(LastEnt,Pattern);
  PgDn:=(entry^.entrynum=nabs) and (n=onscreen+1);
  PgUp:=(enums[1,1]>1);
  dec(n);
end;

begin                                 { ShowEntryList }
  EntryList:=Nil; Places:=Nil; FirstDisplay:=true;
  numcols:=(ScrWidth-5) div 15;
  onscreen:=numcols*(ScrLen-5); if onscreen>MaxListArr then OnScreen:=MaxListArr;
  NumToMake:=OnScreen;
  found:=false;
  OldRealNum:=entry^.realnum; OEntry:=entry^.entrynum;
  OPlace:=entry^.beginning;
  FromBeginning:=not StickyList;
  if FromBeginning then Initial:=0
  else begin
    DeSuspend;
    if entry^.entrynum>0 then Initial:=entry^.entrynum-1
    else Initial:=0;
  end;
  FromBeginning:=false;
  n:=1; nabs:=Initial+1; ntime:=-1; Gt:=-2;
  if Pattern^.on then SearchingMessage;
  if (Initial=0) or (Initial+1<entry^.entrynum) then
  begin
    ResetBib(Entry);
    GetEntry(Entry,Nil,Initial+1,false,Pattern,ok);
  end else if initial+1>entry^.entrynum then
    GetEntry(Entry,Nil,Initial+1,false,Pattern,ok)
  else ok:=true;
  if Pattern^.on then WaitingOff;
  if entry^.realnum=0 then
  begin
    ok:=false; Gt:=-2;
  end;
  Gtnumber:=entry^.entrynum;
  PgUp:=false; PgDn:=false;
  if OK then
  begin
    GetMem(EntryList,(NumToMake+1)*sizeof(ListArrRec2));
    GetMem(Places,(NumToMake+1)*sizeof(longint));
  end;
  MaxMemAvail;
  Spec[1]:=0;
  if ok then
  repeat
    found:=true;
    Gt:=0; ntime:=ntime+1; UseTheIndex:=false;
    SearchingMessage;

    if (Spec[1]=ChooseLast) and EntryCache^.UseCache(Pattern)
         and (EntryCache^.Last>-1) then
    begin
      Initial:=(EntryCache^.Last div OnScreen)*OnScreen;
      if Initial=EntryCache^.Last then Initial:=Initial-OnScreen;
      nabs:=Initial+1;
      GetEntry(Entry,Nil,nabs,true,Pattern,ok);
      NextScreen(ok);
    end else
    begin
      if (n=0) or (initial<>enums[n,2]) then
      begin
        nabs:=Initial+1;
        ResetBib(Entry);
        GetEntry(Entry,Nil,nabs,true,Pattern,ok);
      end;
      NextScreen(ok);
      while (Spec[1]=ChooseLast) and PgDn do
      begin
        Initial:=Initial+OnScreen;
        NextScreen(ok);
      end;
    end;
    WaitingOff;
    if ok then
    begin
      ns:=0; Spec[1]:=1;
      if not FirstDisplay then RemoveWindow;
      FieldChoose(EntryList^,n,numcols,15,Spec,ns,true,PgDn,
                  enums[1,1],enums[n,1],false,false);
      FirstDisplay:=false;
      if ns=1 then
      begin
        if Spec[1]<=n then
        begin
          Gt:=1;
          Gtnumber:=Spec[1]+initial;
        end else if (Spec[1]=ChoosePgUp) or (Spec[1]=ChooseFirst) then
        begin
          if (Initial<=onscreen) or (Spec[1]=ChooseFirst) then Initial:=0
          else Initial:=Initial-onscreen;
        end else if (Spec[1]=ChoosePgDn) or (Spec[1]=ChooseLast) then    {PgDn}
          Initial:=Initial+onscreen;
      end else Gt:=-2;
    end;
  until (not ok) or (Gt<>0);
  if not FirstDisplay then RemoveWindow;
  if Gt>0 then
  begin
    if Places<>Nil then
      ReachEntry(Entry,enums[Spec[1],2],enums[Spec[1],1],Places^[Spec[1]],true)
    else
      ReachNumber(Entry,Pattern,enums[Spec[1],2],enums[Spec[1],1]);
    chosen:=true;
  end else if Gt=-2 then
  begin
    ReachEntry(Entry,OldRealNum,OEntry,OPlace,false);
    chosen:=false;
  end;
  if Places<>Nil then FreeMem(Places,(NumToMake+1)*sizeof(longint)); 
  if EntryList<>Nil then FreeMem(EntryList,(NumToMake+1)*sizeof(ListArrRec2));
end;                                { ShowEntryList }

procedure ShowOverview(Entry: EntryRecPtr; Pattern: PatRecPtr;
                       Var FromBeginning,chosen,found: Boolean);
Const
  MaxDisp = MaxScrLen-5;
Type
  ELStringType = string[MaxScrWidth-4+MaxOverview];
  EntryListType = array[1..MaxDisp] of ELStringType;
  EListTypePtr = ^EntryListType;
var
  n,ns,icode,Index,i,j,k,x,y,Last,Next: integer;
  OldRealNum,OEntry,nabs,Initial,onscreen,Base,LineWidth,In2: Word;
  OPlace: longint;
  gtnumber,gt,ntime: LongInt;
  ok,PgUp,PgDn: boolean;
  line,tmp,gtname: string;
  UpLine : string[32];
  EntryList: EListTypePtr;
  OverLen: array[0..MaxOverView] of Byte;
  Esc,CR,PageU,PageD,Help,Space,FirstEnt,LastEnt,UseTheIndex: boolean;
  ch: char;
  xfirst,att,OldVerbosity,AddLen: Byte;
  enums: array[1..MaxDisp,1..2] of Word;
  places: array[1..MaxDisp] of longint;
  Srec: SortRecType;

procedure NextScreen;
var
  i,LastEnt: longint;
begin
  n:=1; ok:=true; AbortFlag:=false;
  for i:=0 to Noverview do OverLen[i]:=0;
  while ok and (n<=onscreen) and (entry^.entrynum=nabs) do
  begin
    EntryList^[n]:=entry^.name;
    if Overlen[0]<length(entry^.name) then OverLen[0]:=length(entry^.name);
    enums[n,1]:=entry^.entrynum;
    enums[n,2]:=entry^.realnum;
    places[n]:=entry^.beginning;
    if EditOnlyStrings then
    begin
      tmp:=entry^.content[1]; ChrDelL(tmp,' '); ChrDelR(tmp,' ');
      tmp:=' = '+tmp;
      EntryList^[n]:=EntryList^[n]+#9+tmp;
      if Overlen[1]<length(tmp) then OverLen[1]:=length(tmp);
    end else
    begin
      for i:=1 to Noverview do
      begin
        if Overview[i]=Nil then tmp:=''
        else FillTemplate(entry,tmp,Overview[i]^,VerbatimFormat,true,true);
        ChrDelL(tmp,' '); ChrDelR(tmp,' '); tmp:=' '+tmp;
        EntryList^[n]:=EntryList^[n]+#9+tmp;
        if Overlen[i]<length(tmp) then OverLen[i]:=length(tmp);
      end;
    end;
    LastEnt:=Entry^.EntryNum;
    inc(n); inc(nabs);
    GetEntry(Entry,Nil,nabs,true,Pattern,ok);
  end;
  dec(n);
  if (Entry^.EntryNum<Nabs) and not AbortFlag then
    EntryCache^.SetLast(LastEnt,Pattern);
  PgDn:=ok and (Entry^.entrynum=nabs) and (n=OnScreen);
  PgUp:=(Initial>0);
end;                             { NextScreen }

begin                                 { ShowOverview }
  LineWidth:=ScrWidth-5;
  found:=false; chosen:=false; ok:=false; Entrylist:=Nil;
  OldVerbosity:=Verbosity; Verbosity:=0;
  onscreen:=ScrLen-5; if onscreen>MaxDisp then onscreen:=MaxDisp;
  UpLine:=''; ChrFill(UpLine,#205,15);
  if FromBeginning then Initial:=0
  else begin
    if entry^.entrynum>0 then Initial:=entry^.entrynum-1
    else Initial:=0;
  end;
  FromBeginning:=false;
  OldRealnum:=entry^.realnum; OEntry:=entry^.entrynum;
  OPlace:=entry^.beginning;
  n:=1; nabs:=Initial+1; ntime:=-1; Gt:=-2; ok:=true;
  if Pattern^.on then SearchingMessage;
  if nabs<entry^.entrynum then
  begin
    ResetBib(Entry);
    GetEntry(Entry,Nil,nabs,true,Pattern,ok);
  end else if nabs>entry^.entrynum then
    GetEntry(Entry,Nil,nabs,true,Pattern,ok)
  else ok:=true;
  if Pattern^.on then WaitingOff;
  if entry^.realnum=0 then
  begin
    ok:=false; Gt:=-2;
    Verbosity:=OldVerbosity; Exit;
  end;
  if ok then
  begin
    found:=true;
    Gtnumber:=entry^.entrynum;
    PgUp:=false; PgDn:=false;
    GetMem(EntryList,onscreen*sizeof(ELStringType)+8);
    MakeWindowNo(3,2,ScrLen-3,ScrWidth-2,ListNorm,ListNorm,2,ListNorm,0,0);
    TitleWindow(2,ListNorm,'Overview');
    TitleWindow(1,ListNorm,'['+#254+']');
    if UseMouse then
    begin
      WaitForRelease(255);
      ShowMouseCursor; ShowMouseCursor;
      HideMouseCursor;
    end;
    MaxMemAvail;
    LastEnt:=false;
    repeat
      found:=true;
      Gt:=0; ntime:=ntime+1; UseTheIndex:=false;
      SearchingMessage;
      if LastEnt and EntryCache^.UseCache(Pattern)
           and (EntryCache^.Last>-1) then
      begin
        Initial:=(EntryCache^.Last div OnScreen)*OnScreen;
        if Initial=EntryCache^.Last then Initial:=Initial-OnScreen;
        nabs:=Initial+1;
        GetEntry(Entry,Nil,nabs,true,Pattern,ok);
        NextScreen;
      end else
      begin
        if (n=0) or (initial<>enums[n,2]) then
        begin
          nabs:=Initial+1;
          ResetBib(Entry);
          GetEntry(Entry,Nil,nabs,true,Pattern,ok);
        end;
        NextScreen;
        while LastEnt and PgDn do
        begin
          Initial:=Initial+OnScreen; NextScreen;
        end;
      end;
      LastEnt:=false;
      WaitingOff;
      TitleWindow(3,ListNorm,UpLine);
      if n>0 then
      begin
        TitleWindow(3,ListNorm,'('+num2str(Initial+1)+' to '+num2str(Initial+n)+')');
        ns:=0;
        for i:=1 to n do
        begin
          ch:=' '; if IsTagged(enums[i,2],Tags) then ch:=TagChar;
          FillChar(line[1],LineWidth,' '); line[0]:=Chr(LineWidth);
          base:=1; AddLen:=0;
          tmp:=EntryList^[i];
          for j:=0 to NoverView do
          if (Base<=sizeof(ELStringType)-1) and (EntryList^[i]<>'') then
          begin
            k:=Pos(#9,tmp); if k=0 then k:=length(tmp)+1;
            if k>1 then Move(tmp[1],line[base],k-1);
            if k<=length(tmp) then Delete(tmp,1,k)
            else tmp:='';
            base:=base+OverLen[j];
          end;
          PrtWindow(i,1,ch+line);
        end;
        TpwFillW(n+4,3,OnScreen-n,LineWidth+1,' ',ListNorm);

        line:='';
        if PgDn then line:=line+'[PgDn]'+#205;
        if PgUp then line:=line+'[PgUp]'+#205+'[First]'+#205;
        if PgDn then line:=line+'[Last]'+#205;
        for i:=length(line)+1 to 30 do line:=line+#205;
        TitleWindow(4,ListNorm,line);
        TpwAttr(4,4,1,LineWidth,ListRev);
        i:=Pos('F',line); if i>0 then TpwAttr(ScrLen-1,i+3,1,1,ListBright);
        i:=Pos('L',line); if i>0 then TpwAttr(ScrLen-1,i+3,1,1,ListBright);
        
        Last:=1; Next:=1;
        repeat
          Esc:=false; PageD:=false; PageU:=false; CR:=false; Help:=false;
          Space:=false; FirstEnt:=false; LastEnt:=false;
          if Next<>Last then
          begin
            if UseMouse then HideMouseCursor;
            TpwAttr(Last+3,4,1,LineWidth,ListNorm);
            TpwAttr(Next+3,4,1,LineWidth,ListRev);
            if UseMouse then ShowMouseCursor;
          end;
          Last:=Next;
          if UseMouse then ShowMouseCursor;
          ch:=ReadKeyMouse;
          if ch=#27 then Esc:=true
          else if ch=#13 then CR:=true
          else if ch=' ' then Space:=true
          else if PgUp and ((ch='f') or (ch='F') or (ch=#6))  then FirstEnt:=true
          else if PgDn and ((ch='l') or (ch='L') or (ch=#12)) then LastEnt:=true
          else if ch=#0 then
          begin
            ch:=ReadKey;
            if ch=#59 then
            begin
              if PgUp and PgDn then ContextHelp('Overview, PgUp, PgDn')
              else if PgUp then ContextHelp('Overview, PgUp')
              else if PgDn then ContextHelp('Overview, PgDn')
              else ContextHelp('Overview');
            end else if ch=#72 then
            begin
              Next:=Last-1; if Next=0 then Next:=n;
            end else if ch=#80 then
            begin
              Next:=Last+1; if Next>n then Next:=1;
            end else if ch=#71 then Next:=1   { Home }
            else if ch=#79 then Next:=n;        
            PageU:=(ch=#73) and PgUp;
            PageD:=(ch=#81) and PgDn;
            FirstEnt:=(ch=#33) and PgUp;
            LastEnt:=(ch=#38) and PgDn;
            ch:=#0;
          end else if Event.mpress then
          begin
            x:=Event.x-2; y:=Event.y-3;
            WaitForRelease(255);
            if (y=0) and (x<5) and (x>1) then
              Esc:=true
            else if (y=ScrLen-4) then
            begin
              ReadScrStr(tmp,x+2,ScrLen-1,xfirst,att,
                ['[',']','g','p','n','P','U','D','F','i','r','s','t','L','a']);
              if tmp='[PgUp]' then PageU:=true
              else if tmp='[PgDn]' then PageD:=true
              else if tmp='[First]' then FirstEnt:=true
              else if tmp='[Last]' then LastEnt:=true;
            end else if (x>0) and (x<ScrWidth-3) and (y>0) and (y<=n) then
            begin
              next:=y;
              if Event.LeftButton then CR:=true
              else Space:=true;
            end;
          end;
          if Space then
          begin
            Tag(enums[Next,2],TagToggle,Tags);
            if IsTagged(enums[Next,2],Tags) then PrtWindow(Next,1,TagChar)
            else PrtWindow(Next,1,' ');
          end;
        until Esc or CR or PageU or PageD or FirstEnt or LastEnt;
        if UseMouse then HideMouseCursor;
        if Esc then Gt:=-2
        else if CR then
        begin
          Gt:=1;
          Gtnumber:=next+Initial;
        end else if PageU or FirstEnt then    { PgUp and First Entry }
        begin
          if FirstEnt or (Initial<=OnScreen) then Initial:=0
          else Initial:=Initial-OnScreen;
        end else if PageD or LastEnt then    { PgDn }
          Initial:=Initial+OnScreen;
      end;
    until (not ok) or (Gt<>0);
    RemoveWindow;
    FreeMem(EntryList,onscreen*sizeof(ELStringType)+8);
  end;
  Verbosity:=OldVerbosity;
  Chosen:=true;
  if Gt>0 then
  begin
    ReachEntry(Entry,enums[next,2],enums[next,1],Places[next],true);
  end else if Gt=-2 then
  begin
    ReachEntry(Entry,OldRealNum,OEntry,OPlace,false);
    Chosen:=false;
  end;
end;                                { ShowOverview }

end.
