{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit wbibedhy;

Interface

uses
  wobjects, WinTypes, WinProcs, Strings,
  commdlg, windos, ShellAPI, win31,
  rc_strng, rc_id, wbibdisp, wbibgui, wc_help, SMAPI,
  bibstrg, bibvars, bibtmplt, bibfile, bibutil, lfnunit;

type
  IdListRec = record
    ids,row: array[1..18] of integer;
    Rects:   array[1..18] of TRect;
    Nids: integer;
  end;
  IdListType = array[1..MaxHyperTypes] of IdListRec;

  PEditHyperDlg = ^TEditHyperDlg;
  TEditHyperDlg = object(TBasicDialog)
    BasicEBox: PEdit;
    LeadingWhite,TrailingWhite,Selected: boolean;
    idlist: ^IdListType;
    Space: integer;
    OkRect,CancelRect,TestRect: TRect;
    EditBoxes: TCollection;
    constructor init(AParent: PWindowsObject; ABasicEBox: PEdit);
    procedure   InitIdList;
    procedure   ShowItems;
    procedure   Update;
    procedure   SetupWindow; virtual;
    procedure   ClassCBox(var Msg: TMessage); virtual id_first+dl_EditHyperClass;
    procedure   FailOnBtn(var Msg: TMessage); virtual id_first+dl_EditHyperFailOn;
    procedure   DDERepeat(var Msg: TMessage); virtual id_first+dl_EditHyperRepeatDDE;
    procedure   DDEAnother(var Msg: TMessage);virtual id_first+dl_EditHyperNewDDECmd;
    procedure   BrowseBtn(var Msg: TMessage); virtual id_first+dl_EditHyperBrowse;
    procedure   TestBtn(var Msg: TMessage);   virtual id_first+dl_EditHyperTest;
    function    CanClose: boolean; virtual;
    procedure   GetArg(Class: integer; P: PChar);
    procedure   ok(var Msg: TMessage); virtual id_first+id_ok;
    destructor  done; virtual;
  end;


procedure SubstituteHyper(Entry: EntryRecPtr; var tmp: string);
function  HyperEx_RunClass(W: HWnd; Entry: EntryRecPtr; F: PChar): boolean;
function  HyperEx_MailClass(W: HWnd; Entry: EntryRecPtr; F: PChar): boolean;
procedure Hyper_UserClassExpand(Entry: EntryRecPtr; Class: integer; F: PChar);
function  HyperEx_HelpClass(Entry: EntryRecPtr; H: HWnd; var S: string): boolean;

{====================================================================}

implementation

const
  Ind_To=1; Ind_CC=2; Ind_BCC=3;
type
  TRecip = record
    S: PChar;
    Slen,RecipCount: integer;
  end;

procedure ExpandTemplates(Entry: EntryRecPtr; var P: PChar);
const
  BufLen = $7FF0;
var
  Buf,P1,P2,PTmp: PChar;
  tmp: PString;
  ch: char;
begin
  if (P=Nil) or (StrScan(P,lbrace)=Nil) then Exit;
  GetMem(Buf,BufLen);
  GetMem(tmp,257); Ptmp:=PChar(tmp)+1;
  Buf[0]:=#0; P1:=P;
  while P1^<>#0 do
  begin
    P2:=P1;
    repeat
      P2:=StrScan(P2,lbrace);
      if (P2<>Nil) and (P2<>P1) and (PChar(P2-1)^='\') then inc(P2);
    until (P2=Nil) or (P2^=lbrace);
    if P2=Nil then
    begin
      StrLCat(Buf,P1,BufLen); P1:=P1+StrLen(P1);
    end else   { Template start }
    begin
      P2^:=#0; StrLCat(Buf,P1,BufLen);
      P1:=P2; P1^:=lbrace;
      repeat                { look for its end }
        P2:=StrScan(P2,rbrace);
        if (P2<>Nil) and (P2<>P1) and (PChar(P2-1)^='\') then inc(P2);
      until (P2=Nil) or (P2^=rbrace);
      if P2=Nil then     { Early string end }
      begin
        StrLCat(Buf,P1,BufLen); P1:=P1+StrLen(P1);
      end else                 { Expand the template }
      begin
        inc(P2); ch:=P2^; P2^:=#0;
        tmp^:=StrPas(P1);
        PrepareTemplate(tmp^);
        FillTemplate(Entry,tmp^,tmp^,DefaultFormat,true,true);
        Ptmp[length(tmp^)]:=#0;
        StrLCat(Buf,Ptmp,BufLen);
        P2^:=ch; P1:=P2;
      end;
    end;
  end;
  StrDispose(P); P:=StrNew(Buf);

  Dispose(tmp); FreeMem(Buf,BufLen);
end;                      { ExpandTemplates }

{ TEditHyperDlg methods }

constructor TEditHyperDlg.init(AParent: PWindowsObject; ABasicEBox: PEdit);
begin
  TBasicDialog.init(AParent,PChar(rc_EditHyperDlg));
  BasicEBox:=ABasicEBox;
  EditBoxes.init(20,20);
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperDesc,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperArg,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperURL,255,[#0..#32,'<','>','"',',',';'])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperHelpKey,255,[#0..#31])));
  EditBoxes.Insert(New(PEditNoCR,
    InitResource(@Self,dl_EditHyperEntry,255,NameForbid)));
  EditBoxes.Insert(New(PEditNoCR,
    InitResource(@Self,dl_EditHyperFile,PathNameLength,
                             [#0..#255]-FileNameSet-['*'])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperService1,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperTopic1,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperDDECmd1,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperService2,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperTopic2,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperDDECmd2,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperDDEExec,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperRecip,1023,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperCC,1023,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperBCC,1023,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperSubject,255,[#0..#31])));
  EditBoxes.Insert(New(PEditBalanced,
    InitResource(@Self,dl_EditHyperMessage,255,[#0..#31])));
  HelpContext:=hc_Hyperlinks;
end;                         { TEditHyperDlg.init }

procedure TEditHyperDlg.InitIdList;
var
  i,j,LastShift: integer;
  MainRect,Rect1,Rect2: TRect;

procedure GetRect(id: integer; var R: TRect);
var
  P: TPoint;
begin
  GetWindowRect(GetItemHandle(id),R);
  P.X:=R.Left; P.Y:=R.Top;
  ScreenToClient(HWindow,P);
  R.Left:=P.X; R.Top:=P.Y;
  P.X:=R.right; P.Y:=R.bottom;
  ScreenToClient(HWindow,P);
  R.right:=P.X; R.bottom:=P.Y;
end;

begin                { TEditHyperDlg.InitIdList }
  GetMem(IdList,(Hyper_User+1)*sizeof(IdListRec));
  with IdList^[Hyper_Cite] do
  begin
    ids[1]:=dl_EditHyperFile;      Row[1]:=1;
    ids[2]:=dl_EditHyperFileStat;  Row[2]:=0;
    ids[3]:=dl_EditHyperBrowse;    Row[3]:=0;
    ids[4]:=dl_EditHyperURL;       Row[4]:=2;
    ids[5]:=dl_EditHyperURLStat;   Row[5]:=0;
    ids[6]:=dl_EditHyperEntry;     Row[6]:=3;
    ids[7]:=dl_EditHyperEntryStat; Row[7]:=0;
    Nids:=7;
  end;
  with IdList^[Hyper_Run] do
  begin
    ids[1]:=dl_EditHyperArg;       Row[1]:=1;
    ids[2]:=dl_EditHyperArgStatic; Row[2]:=0;
    Nids:=2;
  end;
  with IdList^[Hyper_Help] do
  begin
    ids[1]:=dl_EditHyperFile;        Row[1]:=1;
    ids[2]:=dl_EditHyperFileStat;    Row[2]:=0;
    ids[3]:=dl_EditHyperBrowse;      Row[3]:=0;
    ids[4]:=dl_EditHyperHelpCmd;     Row[4]:=2;
    ids[5]:=dl_EditHyperHelpCmdStat; Row[5]:=0;
    ids[6]:=dl_EditHyperHelpKey;     Row[6]:=0;
    ids[7]:=dl_EditHyperKeyStat;     Row[7]:=0;
    Nids:=7;
  end;
  with IdList^[Hyper_DDE] do
  begin
    ids[ 1]:=dl_EditHyperService1;     Row[ 1]:=1;
    ids[ 2]:=dl_EditHyperService1Stat; Row[ 2]:=0;
    ids[ 3]:=dl_EditHyperTopic1;       Row[ 3]:=0;
    ids[ 4]:=dl_EditHyperTopic1Stat;   Row[ 4]:=0;
    ids[ 5]:=dl_EditHyperDDECmd1;      Row[ 5]:=0;
    ids[ 6]:=dl_EditHyperDDECmd1Stat;  Row[ 6]:=0;
    ids[ 7]:=dl_EditHyperFailGBox;     Row[ 7]:=0;
    ids[ 8]:=dl_EditHyperFailOn;       Row[ 8]:=0;
    ids[ 9]:=dl_EditHyperDDEExec;      Row[ 9]:=0;
    ids[10]:=dl_EditHyperDDEExecStat;  Row[10]:=0;
    ids[11]:=dl_EditHyperRepeatDDE;    Row[11]:=0;
    ids[12]:=dl_EditHyperNewDDECmd;    Row[12]:=0;
    ids[13]:=dl_EditHyperService2;     Row[13]:=0;
    ids[14]:=dl_EditHyperService2Stat; Row[14]:=0;
    ids[15]:=dl_EditHyperTopic2;       Row[15]:=0;
    ids[16]:=dl_EditHyperTopic2Stat;   Row[16]:=0;
    ids[17]:=dl_EditHyperDDECmd2;      Row[17]:=0;
    ids[18]:=dl_EditHyperDDECmd2Stat;  Row[18]:=0;
    Nids:=18;
  end;
  with IdList^[Hyper_Href] do
  begin
    ids[1]:=dl_EditHyperUrl;     Row[1]:=1;
    ids[2]:=dl_EditHyperUrlStat; Row[2]:=0;
    Nids:=2;
  end;
  with IdList^[Hyper_FTP] do
  begin
    ids[1]:=dl_EditHyperFile;     Row[1]:=1;
    ids[2]:=dl_EditHyperFileStat; Row[2]:=0;
    ids[3]:=dl_EditHyperBrowse;   Row[3]:=0;
    ids[4]:=dl_EditHyperUrl;      Row[4]:=2;
    ids[5]:=dl_EditHyperUrlStat;  Row[5]:=0;
    Nids:=5;
  end;
  with IdList^[Hyper_Mail] do
  begin
    ids[1] :=dl_EditHyperRecip;       Row[1] :=1;
    ids[2] :=dl_EditHyperRecipStat;   Row[2] :=0;
    ids[3] :=dl_EditHyperCC;          Row[3] :=0;
    ids[4] :=dl_EditHyperCCStat;      Row[4] :=0;
    ids[5] :=dl_EditHyperBCC;         Row[5] :=0;
    ids[6] :=dl_EditHyperBCCStat;     Row[6] :=0;
    ids[7] :=dl_EditHyperSubject;     Row[7] :=0;
    ids[8] :=dl_EditHyperSubjectStat; Row[8] :=0;
    ids[9] :=dl_EditHyperSend;        Row[9] :=0;
    ids[10]:=dl_EditHyperMessage;     Row[10]:=0;
    ids[11]:=dl_EditHyperMessageStat; Row[11]:=0;
    Nids:=11;
  end;
  with IdList^[Hyper_User] do
  begin
    ids[1]:=dl_EditHyperArg;       Row[1]:=1;
    ids[2]:=dl_EditHyperArgStatic; Row[2]:=0;
    Nids:=2;
  end;
  GetWindowRect(HWindow,MainRect);

  { Default spacing }
  GetRect(dl_EditHyperFile,Rect1);
  GetRect(dl_EditHyperURL,Rect2);
  Space:=rect2.top-rect1.top; if Space<0 then Space:=-Space;

  { Positions for all }
  GetRect(dl_EditHyperDesc,Rect1);
  GetRect(id_ok,OkRect); GetRect(id_Cancel,CancelRect);
  GetRect(dl_EditHyperTest,TestRect);
  i:=OkRect.Bottom-OkRect.Top;
  OkRect.Top:=OkRect.Top-rect1.Top; OkRect.Bottom:=Okrect.Top+i;
  CancelRect.Top:=OkRect.Top; CancelRect.Bottom:=OkRect.Bottom;
  TestRect.Top  :=OkRect.Top; TestRect.Bottom  :=OkRect.Bottom;
  for i:=1 to Hyper_User do
  begin
    LastShift:=0;
    with IdList^[i] do
    for j:=1 to Nids do
    begin
      GetRect(ids[j],Rects[j]);
      if Row[j]>0 then LastShift:=Rect1.top+Row[j]*Space-Rects[j].top;
      Rects[j].top:=Rects[j].top+LastShift;
      Rects[j].Bottom:=Rects[j].Bottom+LastShift;
    end;
  end;
end;            { TEditHyperDlg.InitIdList }

procedure TEditHyperDlg.ShowItems;
var
  i,j,Lowest,HyperInd: integer;
  MainRect,BaseRect: TRect;
  P: TPoint;

procedure PlaceItem(id: integer; R: TRect);
begin
  MoveWindow(GetItemHandle(id),R.Left,R.top,
             R.Right-R.Left,R.Bottom-R.Top,true); 
  if R.Top>Lowest then Lowest:=R.Top;
end;

begin                  { TEditHyperDlg.ShowItems }
  HyperInd:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0)+1;
  if HyperInd>Hyper_User then HyperInd:=Hyper_User;
  Lowest:=0;
  for i:=1 to Hyper_User do for j:=1 to IdList^[i].Nids do
    ShowWindow(GetItemHandle(IdList^[i].Ids[j]),sw_Hide);
  with IdList^[HyperInd] do
  begin
    for j:=1 to Nids do
    begin
      ShowWindow(GetItemHandle(ids[j]),sw_show);
      PlaceItem(ids[j],Rects[j]);
    end;
  end;
  with OkRect do
    SetWindowPos(GetItemHandle(id_ok),0,Left,Top+Lowest,0,0,
       SWP_NoSize or SWP_NoZOrder);
  with CancelRect do
    SetWindowPos(GetItemHandle(id_Cancel),0,Left,Top+Lowest,0,0,
       SWP_NoSize or SWP_NoZOrder);
  with TestRect do
    SetWindowPos(GetItemHandle(dl_EditHyperTest),0,Left,Top+Lowest,0,0,
       SWP_NoSize or SWP_NoZOrder);

  GetWindowRect(HWindow,MainRect);
  SetWindowPos(HWindow,0,0,0,MainRect.Right-MainRect.Left,
         OkRect.Bottom+Lowest+space+10, SWP_NoMove or SWP_NoZOrder);
  Update;
  InvalidateRect(HWindow,Nil,true);
end;                   { TEditHyperDlg.ShowItems }

procedure TEditHyperDlg.Update;
var
  HyperInd: integer;
  btmp: boolean;
begin
  HyperInd:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0)+1;
  if HyperInd=Hyper_DDE then
  begin
    btmp:=IsDlgButtonChecked(HWindow,dl_EditHyperFailOn)=bf_Checked;
    EnableWindow(GetItemHandle(dl_EditHyperDDEExec),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperDDEExecStat),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperRepeatDDE),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperNewDDECmd),btmp);

    btmp:=btmp and (IsDlgButtonChecked(HWindow,dl_EditHyperNewDDECmd)=bf_Checked);
    EnableWindow(GetItemHandle(dl_EditHyperService2Stat),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperService2),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperTopic2Stat),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperTopic2),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperDDECmd2Stat),btmp);
    EnableWindow(GetItemHandle(dl_EditHyperDDECmd2),btmp);
  end;
  if HyperInd>=Hyper_User then HyperInd:=HyperTypesArr^[HyperInd].Htype;
  if (HyperInd=Hyper_Run) or (HyperInd=Hyper_Help) or
     (UseMAPI and (HyperInd=Hyper_Mail)) then
  begin
    ShowWindow(GetItemHandle(dl_EditHyperTest),sw_Show);
  end else
  begin
    ShowWindow(GetItemHandle(dl_EditHyperTest),sw_Hide);
  end;
end;                      { TEditHyperDlg.Update }

procedure TEditHyperDlg.SetupWindow;
var
  i,StartPos,EndPos,SyntaxFound,j: integer;
  F: array[0..255] of char;
  P,P0: PChar;
  l: longint;

function ResolveHyper(P: PChar): integer;
var
  i,j,nbr: integer;
  tmp: string;
  P1,P2,PArg,PDesc,PMacro: PChar;
  l: longint;
  quoted: boolean;
  HyperEndChar: char;

procedure ParseArg(PArg: PChar; Ind: integer);
var
  Arg,tmp: Pstring;
  P,P1: PChar;
  i,nbr: integer;
  fine: boolean;

procedure ParseDDECmd(var S: string; id1,id2,id3: integer);
var
  i: integer;
begin
  if S='' then Exit;
  ChrDelL(S,' '); i:=Pos(',',S); if i=0 then i:=length(S)+1;
  StrPCopy(F,Copy(S,1,i-1)); Delete(S,1,i); ChrDelL(S,' ');
  SetDlgItemText(HWindow,id1,F);
  if S='' then Exit;
  i:=Pos(',',S); if i=0 then i:=length(S)+1;
  StrPCopy(F,Copy(S,1,i-1)); Delete(S,1,i); ChrDelL(S,' ');
  SetDlgItemText(HWindow,id2,F);
  if S='' then Exit;
  StrPCopy(F,S); SetDlgItemText(Hwindow,id3,F);
end;             { ParseDDECmd }

procedure ParseString(var P1: PChar; id: integer; Key: boolean);
var
  P2: PChar;
  quoted,Sof,Slash: boolean;
  nbr: integer;
  ch: char;
begin
  if Key then
  begin
    while (UpCase(P1^) in ['A'..'Z',' ']) do inc(P1);
    while P1^ in [' ','='] do inc(P1);
  end;
  if P1^<>#0 then
  begin
    nbr:=0;
    quoted:=P1^='"'; if quoted then inc(P1);
    P2:=P1; Slash:=false;
    while (P2^<>#0) and (nbr>=0) do
    begin
      ch:=P2^;
      if (P2^=lbrace) and (not Slash) then inc(nbr)
      else if (P2^=rbrace) and (not slash) then dec(nbr)
      else if (P2^='"') then
      begin
        if P2[1]='"' then inc(P2)
        else if quoted and (nbr=0) then dec(nbr);
      end else if (not quoted) and (nbr=0) and (P2^=',') then dec(nbr);
      if (nbr>=0) and (P2^<>#0) then inc(P2);
      if ch='\' then Slash:=not Slash else Slash:=false;
    end;
    {
    quoted:=(P1^='"'); if quoted then inc(P1);
    P2:=P1;
    while (P2^<>#0) and
      ((Quoted and (P2^<>'"')) or
       ((not Quoted) and (P2^<>','))) do inc(P2);
    }
    if quoted and (P2^='"') then
    begin
      P2^:=#0; inc(P2);
    end;
    Sof:=(P2^=#0); P2^:=#0;
    SetDlgItemText(HWindow,id,P1);
    P1:=P2;
    if not Sof then
    begin
      inc(P1);
      while (P1^ in [' ',',']) do inc(P1);
    end;
  end;
end;              { ParseString }

begin            { ParseArg }
  New(Arg); New(tmp); GetMem(P,4096);
  Arg^:=StrPas(PArg);
  if (Ind=Hyper_Run) or (Ind>=Hyper_User) then
    SetDlgItemText(HWindow,dl_EditHyperArg,PArg)
  else if (Ind=Hyper_Href) then
    SetDlgItemText(HWindow,dl_EditHyperURL,PArg)
  else if Ind=Hyper_Cite then
  begin
    if StrPosLI(Arg^,'\file'+lbrace)=1 then
    begin
      fine:=false;
      Delete(Arg^,1,6); i:=Pos(rbrace,Arg^);
      if i>0 then
      begin
        StrPCopy(P,Copy(Arg^,1,i-1));
        Delete(Arg^,1,i);
        if Arg^<>'' then
        begin
          if StrPos(P,'://')=Nil then
            SetDlgItemText(HWindow,dl_EditHyperFile,P)
          else begin
            P1:=StrScan(P,','); if P1<>Nil then P1^:=#0;
            SetDlgItemText(HWindow,dl_EditHyperURL,P);
            if P1<>Nil then
            begin
              P1:=P1+1;
              while (P1^=' ') do P1:=P1+1;
              SetDlgItemText(HWindow,dl_EditHyperFile,P1);
            end;
          end;
          fine:=true;
        end;
      end;
      if not fine then StrCopy(P,PArg)
      else StrPCopy(P,Arg^);
      SetDlgItemText(HWindow,dl_EditHyperEntry,P);
    end;
  end else if Ind=Hyper_FTP then
  begin
    StrCopy(P,PArg); P1:=StrScan(P,','); if P1<>Nil then P1^:=#0;
    SetDlgItemText(Hwindow,dl_EditHyperURL,P);
    if P1<>Nil then
    begin
      P1:=P1+1;
      while (P1^=' ') do P1:=P1+1;
      SetDlgItemText(HWindow,dl_EditHyperFile,P1);
    end;
  end else if Ind=Hyper_Mail then
  begin
    StrCopy(P,PArg); P1:=P; while (P1^=' ') do inc(P1);
    ParseString(P1,dl_EditHyperRecip,false);
    while P1^<>#0 do
    begin
      while P1^ in [' ',','] do inc(P1);
      if P1^<>#0 then
      begin        
        if UpCase(P1^)='C' then                                      { CC      }
          ParseString(P1,dl_EditHyperCC,true) 
        else if UpCase(P1^)='B' then                                 { BCC     }
          ParseString(P1,dl_EditHyperBCC,true) 
        else if UpCase(P1^)='M' then                                 { Message }
          ParseString(P1,dl_EditHyperMessage,true) 
        else if (UpCase(P1^)='S') and (UpCase(P1[1])='U') then       { Subject }
          ParseString(P1,dl_EditHyperSubject,true)
        else if (UpCase(P1^)='S') then                               { Send    }
        begin
          CheckDlgButton(HWindow,dl_EditHyperSend,bf_Checked);
          while not (P1^ in [' ',',',#0]) do inc(P1);
        end else P1^:=#0;                                            { Error   }
      end;      
    end;
  end else if Ind=Hyper_Help then
  begin
    i:=Pos(',',Arg^); if i=0 then i:=length(Arg^)+1;
    StrPcopy(P,Copy(Arg^,1,i-1)); Delete(Arg^,1,i);
    SetDlgItemText(HWindow,dl_EditHyperFile,P);
    if Arg^<>'' then
    begin
      i:=Pos(',',Arg^); if i=0 then i:=length(Arg^)+1;
      StrPCopy(P,Copy(Arg^,1,i-1)); Delete(Arg^,1,i);
      i:=SendDlgItemMsg(dl_EditHyperHelpCmd,cb_FindStringExact,word(-1),longint(P));
      if i<>cb_Err then SendDlgItemMsg(dl_EditHyperHelpCmd,cb_SetCurSel,i,0);
      if i>0 then
      begin
        StrPCopy(P,Arg^);
        SetDlgItemText(HWindow,dl_EditHyperHelpKey,P);
      end;
    end;
  end else if Ind=Hyper_DDE then
  begin
    if StrPosLI(Arg^,'\fail'+lbrace)=1 then
    begin
      CheckDlgButton(HWindow,dl_EditHyperFailOn,bf_Checked);
      Delete(Arg^,1,6);
      { Execute }
      if (length(Arg^)>1) and (Arg^[1]=rbrace) then Delete(Arg^,1,1)
      else begin 
        nbr:=1; i:=1;
        while (nbr>0) and (i<=length(Arg^)) do
        begin
          if Arg^[i]=lbrace then inc(nbr)
          else if Arg^[i]=rbrace then dec(nbr);
          if nbr>0 then inc(i);
        end;
        StrPCopy(F,Copy(Arg^,1,i-1));
        SetDlgItemText(HWindow,dl_EditHyperDDEExec,F);
        Delete(Arg^,1,i);
      end;
      { 2-nd DDE command }
      if (length(Arg^)>1) and (Arg^[1]=lbrace) and (Arg^[2]=rbrace) then
      begin              { Repeat old DDE command }
        CheckDlgButton(HWindow,dl_EditHyperRepeatDDE,bf_Checked);
        Delete(Arg^,1,2);
      end else if (length(Arg^)>1) and (Arg^[1]=lbrace) then { New DDE command }
      begin
        CheckDlgButton(HWindow,dl_EditHyperNewDDECmd,bf_Checked);
        Delete(Arg^,1,1);
        nbr:=1; i:=1;
        while (nbr>0) and (i<=length(Arg^)) do
        begin
          if Arg^[i]=lbrace then inc(nbr)
          else if Arg^[i]=rbrace then dec(nbr);
          if nbr>0 then inc(i);
        end;
        tmp^:=Copy(Arg^,1,i-1); Delete(Arg^,1,i);
        ParseDDECmd(tmp^,dl_EditHyperService2,dl_EditHyperTopic2,
                    dl_EditHyperDDECmd2);
      end;
    end;
    ParseDDECmd(Arg^,dl_EditHyperService1,dl_EditHyperTopic1,
                dl_EditHyperDDECmd1);
  end;
  FreeMem(P,4096); Dispose(tmp); Dispose(Arg);
end;               { ParseArg }

begin              { ResolveHyper }
  ResolveHyper:=0;
  l:=StrLen(P); if l<8 then Exit;
  if (P[0]<>'\') and (P[0]<>'<') then Exit;
  GetMem(P1,l+2);
  StrCopy(P1,P); P^:=#0;
  i:=0; j:=0;
  while (P1[i]<>#0) do
  begin
    if P1[i] in [#0..#31] then P1[i]:=' ';
    if (P1[i]<>' ') or ((i>0) and (P1[i-1]<>' ')) then
    begin
      P[j]:=P1[i]; inc(j);
    end;
    inc(i); 
  end;
  P[j]:=#0;
  FreeMem(P1,l+2); P1:=Nil;
  P1:=StrEnd(P)-1;
  while (P1<>P) and (P1^=' ') do
  begin
    P1^:=#0; P1:=P1-1;
  end;
  if HyperlinkFlags.LaTeX and (P[0]='\') then
  begin
    { Look for TeXMacro }
    P1:=StrScan(P,lbrace); if P1=Nil then Exit;
    P1^:=#0; PMacro:=P; P:=P1+1; if P^=#0 then Exit;
    { Look for argument }
    nbr:=1; P1:=P;
    while (P1^<>#0) and (nbr>0) do
    begin
      if P1^=lbrace then inc(nbr)
      else if P1^=rbrace then dec(nbr);
      if nbr>0 then P1:=P1+1;
    end;
    if P1^=#0 then Exit;
    { Look for description }
    PDesc:=Nil; P1^:=#0; PArg:=P; P:=P1+1;
{    while (P^=' ') do P:=P1+1;} { skip spaces }
    if (P^<>#0) and (P^ in [{lbrace,}'[']) then
    begin
      if P^=lbrace then HyperEndChar:=rbrace else HyperEndChar:=']';
      P:=P+1; nbr:=1; P1:=P;
      while (P1^<>#0) and (nbr>0) do
      begin
        if P1^=lbrace then inc(nbr)
        else if ((nbr>1) and (P1^=rbrace)) or
                ((nbr=1) and (P1^=HyperEndChar)) then dec(nbr);
        if nbr>0 then P1:=P1+1;
      end;
      if P1^=#0 then Exit;
      P1^:=#0; PDesc:=P;
      P:=P1+1; if P^<>#0 then Exit;
    end;
    {YES!}
    i:=1; tmp:=StrPas(PMacro);
    while (i<=NHyperTypes) and (tmp<>HyperTypesArr^[i].TeXMacro^) do inc(i);
    if i>NHyperTypes then Exit;
    SendDlgItemMsg(dl_EditHyperClass,cb_SetCurSel,i-1,0);
    if PDesc<>Nil then SetDlgItemText(HWindow,dl_EditHyperDesc,PDesc);
    ParseArg(PArg,i);
    ResolveHyper:=1;
    Exit;
  end;
  if HyperlinkFlags.HTML and (P[0]='<') and (UpCase(P[1])='A')
     and (P[2]=' ') then
  begin
    P:=P+3; while (P^=' ') do P:=P+1;
    if P^=#0 then Exit;
    P1:=StrEnd(P)-4; if P1<=P then Exit;
    if StrLIComp(P1,'</a>',10)<>0 then Exit;
    P1^:=#0;
    { Look for class name }
    P1:=StrScan(P,'='); if P1=Nil then Exit;
    P1^:=#0; PMacro:=P; P:=P1+1; if P^=#0 then Exit;
    { Look for argument }
    quoted:=(P^='"'); if quoted then P:=P+1; if P^=#0 then Exit;
    i:=0;
    while (P[i]<>#0) and ((quoted and (P[i]<>'"')) or
      ((not quoted) and (P[i]<>'>'))) do inc(i);
    if P[i]=#0 then Exit;
    P[i]:=#0; PArg:=P; P:=P+i+1;
    if quoted then
    begin
      while (P^=' ') do P:=P+1;
      if P^<>'>' then Exit;
      P^:=#0; P:=P+1;
    end;
    while (P^=' ') do P:=P+1;
    if P^=#0 then Exit;
    PDesc:=P;
    { ok }
    i:=1; tmp:=StrPas(PMacro); StrLwr(tmp);
    while (i<=NHyperTypes) and (tmp<>HyperTypesArr^[i].pre^) do inc(i);
    if i>NHyperTypes then Exit;
    SendDlgItemMsg(dl_EditHyperClass,cb_SetCurSel,i-1,0);
    SetDlgItemText(HWindow,dl_EditHyperDesc,PDesc);
    ParseArg(PArg,i);
    ResolveHyper:=2;
  end;
end;              { ResolveHyper }

begin                        { TEditHyperDlg.SetupWindow }
  TBasicDialog.SetupWindow;
  for i:=1 to NHyperTypes do
  begin
    StrPCopy(F,HyperTypesArr^[i].pre^);
    SendDlgItemMsg(dl_EditHyperClass,cb_AddString,0,longint(@F));
  end;
  SendDlgItemMsg(dl_EditHyperClass,cb_SetCurSel,0,0);

  StrPCopy(F,'Contents'); SendDlgItemMsg(dl_EditHyperHelpCmd,cb_AddString,0,longint(@F));
  StrPCopy(F,'Search'); SendDlgItemMsg(dl_EditHyperHelpCmd,cb_AddString,0,longint(@F));
  StrPCopy(F,'Key'); SendDlgItemMsg(dl_EditHyperHelpCmd,cb_AddString,0,longint(@F));
  StrPCopy(F,'Context'); SendDlgItemMsg(dl_EditHyperHelpCmd,cb_AddString,0,longint(@F));
  StrPCopy(F,'ContextPopup'); SendDlgItemMsg(dl_EditHyperHelpCmd,cb_AddString,0,longint(@F));
  StrPCopy(F,'Command'); SendDlgItemMsg(dl_EditHyperHelpCmd,cb_AddString,0,longint(@F));
  SendDlgItemMsg(dl_EditHyperHelpCmd,cb_SetCurSel,0,0);

  InitIdList;
  BasicEBox^.GetSelection(StartPos,EndPos);
  Selected:=(StartPos<EndPos-1);
  P0:=Nil; P:=Nil; LeadingWhite:=false; TrailingWhite:=false;
  if Selected then
  begin
    l:=EndPos-StartPos+10;
    GetMem(P0,l);
    BasicEBox^.GetSubText(P0,StartPos,EndPos);
    if (StartPos>0) then
    begin
      BasicEBox^.GetSubText(F,StartPos-1,StartPos);
      if F[0]<>' ' then LeadingWhite:=true;
    end;
    P:=P0;
    while (P[0]=' ') do P:=P+1;
    i:=StrLen(P)-1;
    while (i>=0) and (P[i]=' ') do
    begin
      TrailingWhite:=true; dec(i);
    end;
    P[i+1]:=#0;
{    if not (P[0] in ['\','<']) then Selected:=false;}
    i:=0;
    while (P[i]<>#0) do    { Skip CR-LF pairs }
      if (P[i]=#13) and (P[i+1]=#10) then
      begin
        j:=i-1;
        repeat
          inc(j); P[j]:=P[j+2];
        until P[j]=#0;
      end else inc(i);
  end else if StartPos>0 then
  begin
    BasicEBox^.GetSubText(F,StartPos-1,StartPos);
    if F[0]<>' ' then LeadingWhite:=true; 
  end;
  if Selected then
  begin
    SyntaxFound:=ResolveHyper(P);
    if SyntaxFound=1 then
      CheckDlgButton(HWindow,dl_EditHyperLaTeX,bf_Checked)
    else if SyntaxFound=2 then
      CheckDlgButton(HWindow,dl_EditHyperHTML,bf_Checked)
    else begin
      if HyperlinkFlags.LaTeX then CheckDlgButton(HWindow,dl_EditHyperLaTeX,bf_Checked)
      else CheckDlgButton(HWindow,dl_EditHyperHTML,bf_Checked);
      SetDlgItemText(HWindow,dl_EditHyperDesc,P);
    end;
  end else
  begin
    SendDlgItemMsg(dl_EditHyperClass,cb_SetCurSel,0,0);
    if HyperlinkFlags.LaTeX then CheckDlgButton(HWindow,dl_EditHyperLaTeX,bf_Checked)
    else CheckDlgButton(HWindow,dl_EditHyperHTML,bf_Checked);
  end;
  if P0<>Nil then FreeMem(P0,l);

  EnableWindow(GetItemHandle(dl_EditHyperLaTeX),HyperlinkFlags.LaTeX);
  EnableWindow(GetItemHandle(dl_EditHyperHTML),HyperlinkFlags.HTML);

  ShowItems; InitPos;
end;                { TEditHyperDlg.SetupWindow }

procedure TEditHyperDlg.ClassCBox(var Msg: TMessage);
begin
  if Msg.lParamHi=cbn_SelChange then ShowItems;
end;

procedure TEditHyperDlg.FailOnBtn(var Msg: TMessage);
begin Update; end;

procedure TEditHyperDlg.DDERepeat(var Msg: TMessage);
begin
  if IsDlgButtonChecked(Hwindow,dl_EditHyperRepeatDDE)=bf_Checked then
  CheckDlgButton(HWindow,dl_EditHyperNewDDECmd,bf_UnChecked);
  Update;
end;

procedure TEditHyperDlg.DDEAnother(var Msg: TMessage);
begin
  if IsDlgButtonChecked(Hwindow,dl_EditHyperNewDDECmd)=bf_Checked then
  CheckDlgButton(HWindow,dl_EditHyperRepeatDDE,bf_UnChecked);
  Update;
end;

procedure TEditHyperDlg.BrowseBtn(var Msg: TMessage);
var
  T: TOpenFileName;
  Filters,Fname,Title,DefExtStr: Pchar;
  Class: integer;
  tmp: string;
begin
  GetMem(Filters,256); GetMem(Fname,256);
  GetMem(Title,256); GetMem(DefExtStr,256);
  Class:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0)+1;
  tmp:=#0#0; DefExtStr[0]:=#0; Title[0]:=#0;
  if Class=Hyper_Help then
  begin
    StrPCopy(Title,'Help file');
    tmp:=StrPas(Title)+'s'#0'*.hlp'#0+AnyFileFilter;
    StrPCopy(DefExtStr,'hlp');
  end else if Class=Hyper_Cite then
  begin
    StrPCopy(Title,'Database file');
    tmp:=StrPas(Title)+'s'#0'*'+DefExtension[BibTeXFormat]^+#0+AnyFileFilter;
    StrPCopy(DefExtStr,Copy(DefExtension[BibTeXFormat]^,2,255));
  end else if Class=Hyper_FTP then
  begin
    StrPCopy(Title,'Download file');
    tmp:=AnyFileFilter;
    StrPCopy(DefExtStr,Copy(DefExtension[BibTeXFormat]^,2,255));
  end;
  Move(tmp[1],Filters[0],length(tmp));
  Fname[0]:=#0;
  FillChar(T,SizeOf(T),0);
  with T do
  begin
    lStructSize:=SizeOf(T);
    hWndOwner:=HWindow;
    lpstrFilter:=Filters; nFilterIndex:=1;
    lpstrFile:=Fname;    nMaxFile:=255;
    lpstrTitle:=Title;
    flags:=Ofn_FileMustExist or ofn_NoChangeDir or ofn_HideReadOnly;
    if LFNAble then flags:=flags or ofn_LongNames;
    lpstrDefExt:=DefExtStr;
  end;
  if GetOpenFileName(T) then
  begin
    tmp:=StrPas(Fname); CanonicalFname(tmp); StrPCopy(Fname,tmp);
    SetDlgItemText(HWindow,dl_EditHyperFile,Fname);
  end;
  FreeMem(DefExtStr,256); FreeMem(Title,256);
  FreeMem(Fname,256); FreeMem(Filters,256);
end;                    { TEditHyperDlg.BrowseBtn }

procedure TEditHyperDlg.TestBtn(var Msg: TMessage);
var
  F,P0,P,F1,MR2: PChar;
  Class,i,j,Len,TotRecip,Reciplen: integer;
  RParams: array[1..3] of TRecip;
  S: PString;
  Subj,Mess: Pchar;
  Send: boolean;
  MailRecip: PMAPIRecipDesc;
  MailMessage: TMAPIMessage;
  flFlags: TFlags;
begin
  Class:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0);
  if Class=cb_Err then Exit;
  inc(Class);
  GetMem(F,4096);
  GetDlgItemText(HWindow,dl_EditHyperArg,F,255);
  if Class=Hyper_run then HyperEx_RunClass(HWindow,Entry,F)
  else if Class=Hyper_Help then
  begin
    F[0]:=#0; GetArg(Class,F);
    New(S); S^:=StrPas(F); HyperEx_HelpClass(Entry,HWindow,S^); Dispose(S);
  end else if (Class=Hyper_Mail) and
              (GetDlgItemText(HWindow,dl_EditHyperRecip,F,1023)>0) then
  begin
    for j:=1 to 3 do with RParams[j] do
    begin
      S:=Nil; SLen:=0; RecipCount:=0;
    end;
    Mess:=Nil; Subj:=Nil;
    with RParams[Ind_To] do
    begin
      S:=StrNew(F); SLen:=StrLen(S);
    end;
    if GetDlgItemText(HWindow,dl_EditHyperSubject,F,255)>0 then
      Subj:=StrNew(F);
    if GetDlgItemText(HWindow,dl_EditHyperCC,F,1023)>0 then
    with RParams[Ind_CC] do
    begin
      S:=StrNew(F); SLen:=StrLen(S);
    end;
    if GetDlgItemText(HWindow,dl_EditHyperBCC,F,1023)>0 then
    with RParams[Ind_BCC] do
    begin
      S:=StrNew(F); SLen:=StrLen(S);
    end;
    if GetDlgItemText(HWindow,dl_EditHyperMessage,F,255)>0 then
      Mess:=StrNew(F);
    flFlags:=MAPI_LOGON_UI;
    if IsDlgButtonChecked(HWindow,dl_EditHyperSend)<>bf_Checked then
      flFlags:=flFlags or MAPI_DIALOG;
    ExpandTemplates(Entry,Subj); ExpandTemplates(Entry,Mess);

  { Ok, now build the structures }
    for j:=1 to 3 do
    with RParams[j] do if S<>Nil then
    begin
      RecipCount:=1;
      i:=0; Len:=StrLen(S);
      while i<Len-1 do
      begin
        if S[i]=';' then
        begin
          inc(RecipCount); S[i]:=#0;
          while (i<Len) and (S[i+1] in [' ',';']) do   { Skip null entries }
          begin
            inc(i); S[i]:=' ';
          end;
        end;
        inc(i);
      end;
    end;

    TotRecip:=RParams[Ind_To].RecipCount+RParams[Ind_CC].RecipCount
                              +RParams[Ind_BCC].RecipCount;
    GetMem(MailRecip,TotRecip*sizeof(TMAPIRecipDesc));
    FillChar(MailRecip^,TotRecip*sizeof(TMAPIRecipDesc),0);
    MR2:=PChar(MailRecip);
    for j:=1 to 3 do
    with RParams[j] do
    begin
      P:=S;
      for i:=1 to RecipCount do
      begin
        while (P^=' ') do inc(P); 
        with PMAPIRecipDesc(MR2)^ do
        begin
          if j=Ind_To then ulRecipClass:=MAPI_TO
          else if j=Ind_CC then ulRecipClass:=MAPI_CC
          else if j=Ind_BCC then ulRecipClass:=MAPI_BCC;
          lpszName:=P;
        end;
        if i<RecipCount then MR2:=MR2+sizeof(TMAPIRecipDesc);
        P:=P+StrLen(P)+1;
      end;
    end;
    FillChar(MailMessage,sizeof(MailMessage),0);
    with MailMessage do
    begin
      lpszSubject:=Subj;
      lpszNoteText:=Mess;
      flFlags:=MAPI_SENT;
      nRecipCount:=TotRecip;
      lpRecips:=MailRecip;
    end;

    MAPISendMail(0,0,@MailMessage,flFlags,0);

    FreeMem(MailRecip,TotRecip*sizeof(TMAPIRecipDesc));
    for j:=3 downto 1 do with RParams[j] do
      if S<>Nil then FreeMem(S,SLen+1);
    if Mess<>Nil then StrDispose(Mess);
    if Subj<>Nil then StrDispose(Subj);
  end else if Class>=Hyper_User then
  begin
    Hyper_UserClassExpand(Entry,Class,F);
    case HyperTypesArr^[Class].HType of
      Hyper_Run: HyperEx_RunClass(HWindow,Nil,F);
      Hyper_Help:
        begin
          F[0]:=#0; GetArg(Class,F);
          New(S); S^:=StrPas(F); HyperEx_HelpClass(Nil,HWindow,S^); Dispose(S);
        end;
      Hyper_Mail: HyperEx_MailClass(HWindow,Nil,F);
    end;
  end;
  FreeMem(F,4096);
end;                     { TEditHyperDlg.TestBtn }

function TEditHyperDlg.CanClose: boolean;
var
  F: array[0..255] of char;
  Class,i: integer;
  DDE2: boolean;

function MustExist(Id,StrID: integer): boolean;
begin
  if GetDlgItemText(HWindow,id,F,255)=0 then
  begin
    if StrID<>0 then ErrorMessageRC(StrID,'')
    else messagebeep(0);
    MustExist:=false;
  end else MustExist:=true;
end;      { MustExist }

begin              { TEditHyperDlg.CanClose }
  CanClose:=false;
  if not TBasicDialog.CanClose then Exit;
  if (IsDlgButtonChecked(HWindow,dl_EditHyperLaTeX)<>bf_Checked)
     and not MustExist(dl_EditHyperDesc,0) then Exit;
  Class:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0)+1;
  if (Class=Hyper_Run) or (Class>=Hyper_User) then
  begin
    if not MustExist(dl_EditHyperArg,0) then Exit;
  end else if Class=Hyper_Cite then
  begin
    if not MustExist(dl_EditHyperEntry,0) then Exit;
  end else if (Class=Hyper_Href) or (Class=Hyper_FTP) then
  begin
    if not MustExist(dl_EditHyperURL,0) then Exit;
  end else if Class=Hyper_Mail then
  begin
    if not MustExist(dl_EditHyperRecip,0) then Exit;
  end else if Class=Hyper_Help then
  begin
    if not MustExist(dl_EditHyperFile,0) then Exit;
    i:=SendDlgItemMsg(dl_EditHyperHelpCmd,cb_GetCurSel,0,0);
    if (i>1) and not MustExist(dl_EditHyperHelpKey,0) then Exit;
  end else if Class=Hyper_DDE then
  begin
    if not (MustExist(dl_EditHyperService1,0) and
            MustExist(dl_EditHyperTopic1,0) and
            MustExist(dl_EditHyperDDECmd1,0)) then Exit;
    if IsDlgButtonChecked(HWindow,dl_EditHyperFailOn)=bf_Checked then
    begin
      DDE2:=IsDlgButtonChecked(HWindow,dl_EditHyperNewDDECmd)=bf_Checked;
      if (not DDE2) and not MustExist(dl_EditHyperDDEExec,0) then Exit;
      if DDE2 and not (
            MustExist(dl_EditHyperService2,0) and
            MustExist(dl_EditHyperTopic2,0) and
            MustExist(dl_EditHyperDDECmd2,0)    ) then Exit;
    end;
  end else Exit;
  CanClose:=true;
end;                 { TEditHyperDlg.CanClose }

procedure TEditHyperDlg.GetArg(Class: integer; P: PChar);
var
  i: integer;
  P2,P3,PF: PChar;
  quote: boolean;

procedure Comma;
begin
  StrCat(P,',');
end;

procedure PutDDE(id1,id2,id3: integer);
begin
  GetDlgItemText(HWindow,id1,P2,255); StrCat(P,P2); Comma;
  GetDlgItemText(HWindow,id2,P2,255); StrCat(P,P2); Comma;
  GetDlgItemText(HWindow,id3,P2,255); StrCat(P,P2);
end;              { PutDDE }

function NeedsQuoting(F: PChar): boolean;
var
  P2: PChar;
  nbr: integer;
  Slash: boolean;
  ch: char;
begin
  Slash:=false; Nbr:=0;
  NeedsQuoting:=true;
  P2:=F;
  while P2^<>#0 do
  begin
    if (P2^=lbrace) and not slash then inc(nbr)
    else if (P2^=rbrace) and not slash then dec(nbr)
    else if (nbr=0) and (P2^=',') then Exit;  { Needs quoting! }
    if P2^='\' then Slash:=not Slash else Slash:=false;
    inc(P2);
  end;
  NeedsQuoting:=false;
end;               { NeedsQuoting }

begin             { GetArg }
  GetMem(P2,1024); GetMem(P3,1024);
  if (Class=Hyper_Run) or (Class>=Hyper_User) then
  begin
    GetDlgItemText(HWindow,dl_EditHyperArg,P2,255); StrCat(P,P2);
  end else if (Class=Hyper_Href) then
  begin
    GetDlgItemText(HWindow,dl_EditHyperURL,P2,255); StrCat(P,P2);
  end else if (Class=Hyper_Mail) then
  begin
    GetDlgItemText(HWindow,dl_EditHyperRecip,P2,1023);
    PF:=P2;
    repeat
      PF:=StrScan(PF,','); if PF<>Nil then PF^:=';';
    until PF=Nil;
    StrCat(P,P2);
    if GetDlgItemText(HWindow,dl_EditHyperCC,P2,1023)>0 then
    begin
      PF:=P2;
      repeat
        PF:=StrScan(PF,','); if PF<>Nil then PF^:=';';
      until PF=Nil;
      quote:=NeedsQuoting(P2);
      StrCat(P,', CC='); if quote then StrCat(P,'"');
      StrCat(P,P2);      if quote then StrCat(P,'"');
    end;
    if GetDlgItemText(HWindow,dl_EditHyperBCC,P2,1023)>0 then
    begin
      PF:=P2;
      repeat
        PF:=StrScan(PF,','); if PF<>Nil then PF^:=';';
      until PF=Nil;
      quote:=NeedsQuoting(P2);
      StrCat(P,', BCC='); if quote then StrCat(P,'"');
      StrCat(P,P2);       if quote then StrCat(P,'"');
    end;
    if GetDlgItemText(HWindow,dl_EditHyperSubject,P2,255)>0 then
    begin
      quote:=NeedsQuoting(P2);
      StrCat(P,', SU='); if quote then StrCat(P,'"');
      StrCat(P,P2); if quote then StrCat(P,'"');             
    end;
    if GetDlgItemText(HWindow,dl_EditHyperMessage,P2,255)>0 then
    begin
      quote:=NeedsQuoting(P2);
      StrCat(P,', M='); if quote then StrCat(P,'"');
      StrCat(P,P2); if quote then StrCat(P,'"');             
    end;
    if IsDlgButtonChecked(HWindow,dl_EditHyperSend)=bf_Checked then
      StrCat(P,', SND');
  end else if (Class=Hyper_Cite) then
  begin
    GetDlgItemText(HWindow,dl_EditHyperURL, P2,255);
    GetDlgItemText(HWindow,dl_EditHyperFile,P3,255);
    if (P2^<>#0) or (P3^<>#0) then
    begin
      StrCat(P,'\file'+lbrace);
      if P2^<>#0 then
      begin
        StrCat(P,P2);
        if P3^<>#0 then StrCat(P,', ');
      end;
      StrCat(P,P3); StrCat(P,rbrace);
    end;
    GetDlgItemText(HWindow,dl_EditHyperEntry,P2,255);
    StrCat(P,P2);
  end else if Class=Hyper_FTP then
  begin
    GetDlgItemText(HWindow,dl_EditHyperURL, P2,255);
    GetDlgItemText(HWindow,dl_EditHyperFile,P3,255);
    if (P2^<>#0) or (P3^<>#0) then
    begin
      if P2^<>#0 then
      begin
        StrCat(P,P2);
        if P3^<>#0 then StrCat(P,', ');
      end;
      StrCat(P,P3);
    end;
  end else if Class=Hyper_Help then
  begin
    GetDlgItemText(HWindow,dl_EditHyperFile,P2,PathNameLength);
    StrCat(P,P2);
    i:=SendDlgItemMsg(dl_EditHyperHelpCmd,cb_GetCurSel,0,0);
    if i>0 then
    begin
      Comma;
      SendDlgItemMsg(dl_EditHyperHelpCmd,cb_GetLBText,i,longint(P2));
      StrCat(P,P2);
      Comma;
      GetDlgItemText(HWindow,dl_EditHyperHelpKey,P2,255);
      StrCat(P,P2);
    end;
  end else if Class=Hyper_DDE then
  begin
    if IsDlgButtonChecked(HWindow,dl_EditHyperFailOn)=bf_Checked then   { \fail }
    begin
      StrPCopy(P2,'\fail'+lbrace); StrCat(P,P2);
      GetDlgItemText(HWindow,dl_EditHyperDDEExec,P2,255);
      StrCat(P,P2);
      StrPCopy(P2,rbrace); StrCat(P,P2);
      if IsDlgButtonChecked(Hwindow,dl_EditHyperRepeatDDE)=bf_Checked then
      begin
        StrPCopy(P2,lbrace+rbrace); StrCat(P,P2);
      end else if IsDlgButtonChecked(Hwindow,dl_EditHyperNewDDECmd)=bf_Checked then
      begin
        StrPCopy(P2,lbrace); StrCat(P,P2);
        PutDDE(dl_EditHyperService2,dl_EditHyperTopic2,dl_EditHyperDDECmd2);
        StrPCopy(P2,rbrace); StrCat(P,P2);
      end;
    end;
    PutDDE(dl_EditHyperService1,dl_EditHyperTopic1,dl_EditHyperDDECmd1);
  end;
  FreeMem(P3,1024); FreeMem(P2,1024);
end;                 { TEditHyperDlg.GetArg }

procedure TEditHyperDlg.ok(var Msg: TMessage);
const
  PSize = 1023;
var
  LaTeX,quote,IsDesc: boolean;
  Class: integer;
  F: array[0..256] of char;
  P,P1,P2: PChar;
begin     { ok }
  if not CanClose then Exit;
  LaTeX:=IsDlgButtonChecked(HWindow,dl_EditHyperLaTeX)=bf_Checked;
  Class:=SendDlgItemMsg(dl_EditHyperClass,cb_GetCurSel,0,0);
  if Class=cb_Err then
  begin
    EndDlg(id_cancel); Exit;
  end;
  inc(Class);
  GetMem(P,PSize+1);
  if LeadingWhite then StrPCopy(P,' ') else StrPCopy(P,'');
  if LaTeX then
    StrPCopy(F,HyperTypesArr^[Class].TeXMacro^+lbrace)
  else
    StrPCopy(F,'<a '+HyperTypesArr^[Class].pre^+'="');
  StrCat(P,F);

  GetArg(Class,P);
  if LaTeX then StrCat(P,rbrace)
  else StrCat(P,'">');

  IsDesc:=false; P1:=Nil; P2:=Nil;
  if GetDlgItemText(HWindow,dl_EditHyperDesc,F,255)>0 then
  begin
    P1:=@F; while (P1^=' ') do inc(P1);
    P2:=P1+StrLen(P1)-1;
    while P2^=' ' do
    begin
      P2^:=#0; dec(P2);
    end;
    IsDesc:=(P1^<>#0);
  end;
  if LaTeX and IsDesc then
  begin
    StrCat(P,'['); StrCat(P,P1); StrCat(P,']');
  end else if not LaTeX then
  begin
    StrCat(P,P1); StrCat(P,'</a>');
  end;

  if TrailingWhite then StrCat(P,' ');

  BasicEBox^.Insert(P);

  FreeMem(P,PSize+1);
  EndDlg(id_ok);
end;                 { TEditHyperDlg.ok }

destructor TEditHyperDlg.Done;
begin
  EditBoxes.Done;
  FreeMem(IdList,(Hyper_User+1)*sizeof(IdListRec));
  TBasicDialog.Done;
end;

{--------------------------------------------}

procedure SubstituteHyper(Entry: EntryRecPtr; var tmp: string);
var
  D,N,E: PString;
  tmp2,template: string;
  i: integer;
  ch: char;
begin
  if Entry=Nil then Exit;
  AllocStrings(true,@D,@N,@E,Nil);
  { Illegal TeX characters and \verb }
  i:=1;
  repeat
    while (i<length(tmp)) and (tmp[i]<>'\') do inc(i);
    while (i<length(tmp)) and (copy(tmp,i,2)='\\') do inc(i,2);
    if (i>=length(tmp)) or (tmp[i]<>'\') then inc(i)
    else begin
      if tmp[i+1] in ['%','$','&','#'] then   { Illegal TeX chars }
      begin
        delete(tmp,i,1); inc(i);
      end else if (i<length(tmp)+5) and (copy(tmp,i+1,4)='verb') and
         not (tmp[i+5] in TexLett) then  { \verb }
      begin
        ch:=tmp[i+5]; delete(tmp,i,6);
        while (i<=length(tmp)) and (tmp[i]<>ch) do inc(i);
        if i<=length(tmp) then Delete(tmp,i,1) else i:=0;
      end else inc(i);
    end;
  until (i>=length(tmp)) or (i<1);

  StrRepl(tmp,'##',#1,1,255,255);
  if entry^.nentry=0 then tmp2:='' else tmp2:=entry^.name;
  StrRepl(tmp,'#l',tmp2,1,255,255);
  StrRepl(tmp,'#L',tmp2,1,255,255);
  if entry^.nentry=0 then tmp2:='0' else tmp2:=num2str(entry^.nentry);
  StrRepl(tmp,'#e',tmp2,1,255,255);
  StrRepl(tmp,'#E',tmp2,1,255,255);
  tmp2:=BibName^;
  StrLwr(tmp2); StrRepl(tmp,'#f',tmp2,1,255,255);
  StrUpr(tmp2); StrRepl(tmp,'#F',tmp2,1,255,255);
  LFNFSplit(bibname^,D,N,E);
  StrLwr(D^); StrRepl(tmp,'#d',D^,1,255,255);
  StrUpr(D^); StrRepl(tmp,'#D',D^,1,255,255);
  StrLwr(N^); StrRepl(tmp,'#n',N^,1,255,255);
  StrUpr(N^); StrRepl(tmp,'#N',N^,1,255,255);
  StrLwr(E^); StrRepl(tmp,'#x',E^,1,255,255);
  StrUpr(E^); StrRepl(tmp,'#X',E^,1,255,255);
  StrRepl(tmp,#1,'#',1,255,255);
  { templates }
  tmp2:='';
  repeat
    i:=Pos(lbrace+lbrace,tmp);
    if i=0 then
    begin
      tmp2:=tmp2+tmp; tmp:='';
    end else
    begin
      tmp2:=tmp2+Copy(tmp,1,i-1); Delete(tmp,1,i+1);
      i:=Pos(rbrace+rbrace,tmp);
      if i=0 then
      begin
        template:=tmp; tmp:='';
      end else
      begin
        template:=Copy(tmp,1,i-1); Delete(tmp,1,i+1);
      end;
      PrepareTemplate(Template);
      FillTemplate(Entry,Template,Template,DefaultFormat,false,true);
      tmp2:=tmp2+Template;
    end;
  until tmp='';
  ChrDelR(tmp2,' ');
  tmp:=tmp2;
  AllocStrings(false,@D,@N,@E,Nil);
end;                            { SubstituteHyper }

function HyperEx_MailClass(W: HWnd; Entry: EntryRecPtr; F: PChar): boolean;
var
  Subj,Mess,P,P1,MR2: Pchar;
  Send: boolean;
  MailRecip: PMAPIRecipDesc;
  MailMessage: TMAPIMessage;
  Flags: TFlags;
  TotRecip,i,j,len: integer;
  RParams: array[1..3] of TRecip;

procedure ParseString(var P1,PRes: PChar; Key: boolean);
var
  P2: PChar;
  quoted,Sof,Slash: boolean;
  nbr: integer;
  ch: char;
begin
  if Key then
  begin
    while (UpCase(P1^) in ['A'..'Z',' ']) do inc(P1);
    while P1^ in [' ','='] do inc(P1);
  end;
  if P1^<>#0 then
  begin
    nbr:=0;
    quoted:=P1^='"'; if quoted then inc(P1);
    P2:=P1; Slash:=false;
    while (P2^<>#0) and (nbr>=0) do
    begin
      ch:=P2^;
      if (P2^=lbrace) and (not Slash) then inc(nbr)
      else if (P2^=rbrace) and (not slash) then dec(nbr)
      else if (P2^='"') then
      begin
        if P2[1]='"' then inc(P2)
        else if quoted and (nbr=0) then dec(nbr);
      end else if (not quoted) and (nbr=0) and (P2^=',') then dec(nbr);
      if (nbr>=0) and (P2^<>#0) then inc(P2);
      if ch='\' then Slash:=not Slash else Slash:=false;
    end;
    {
    quoted:=(P1^='"'); if quoted then inc(P1);
    P2:=P1;
    while (P2^<>#0) and
      ((Quoted and (P2^<>'"')) or
       ((not Quoted) and (P2^<>','))) do inc(P2);
    }
    if quoted and (P2^='"') then
    begin
      P2^:=#0; inc(P2);
    end;
    Sof:=(P2^=#0); P2^:=#0;
    if PRes<>Nil then StrDispose(PRes); PRes:=StrNew(P1);
    P1:=P2; 
    if not Sof then
    begin
      inc(P1);
      while (P1^ in [' ',',']) do inc(P1);
    end;
  end;
end;              { ParseString }

begin              { HyperEx_MailClass }
  Subj:=Nil; Mess:=Nil; Send:=false;
  HyperEx_MailClass:=false;
  if (F=Nil) or (F^=#0) then Exit;
  P1:=F; while (P1^=' ') do inc(P1);
  for j:=1 to 3 do with RParams[j] do
  begin
    S:=Nil; SLen:=0; RecipCount:=0;
  end;
  TotRecip:=0;
  with RParams[Ind_To] do
  begin
    ParseString(P1,RParams[Ind_To].S,false);
    if (S=Nil) or (S^=#0) then
    begin
      if S<>Nil then StrDispose(S); Exit;
    end;
    SLen:=StrLen(S);
  end;
  while P1^<>#0 do
  begin
    while P1^ in [' ',','] do inc(P1);
    if P1^<>#0 then
    begin        
      if UpCase(P1^)='C' then                                      { CC      }
        with RParams[Ind_CC] do
        begin
          ParseString(P1,S,true); SLen:=StrLen(S);
        end 
      else if UpCase(P1^)='B' then                                 { BCC     }
        with RParams[Ind_BCC] do
        begin
          ParseString(P1,S,true); SLen:=StrLen(S);
        end 
      else if UpCase(P1^)='M' then                                 { Message }
          ParseString(P1,Mess,true) 
      else if (UpCase(P1^)='S') and (UpCase(P1[1])='U') then       { Subject }
          ParseString(P1,Subj,true)
      else if (UpCase(P1^)='S') then                               { Send    }
      begin
        Send:=true;
        while not (P1^ in [' ',',',#0]) do inc(P1);
      end else P1^:=#0;                                            { Error   }
    end;      
  end;
  ExpandTemplates(Entry,Subj); ExpandTemplates(Entry,Mess);
{  if Subj<>Nil then message(StrPas(Subj)) else message('none');}

  { Ok, now build the structures }
  { List of recipients }
  TotRecip:=0;
  for j:=1 to 3 do with RParams[j] do if S<>Nil then
  begin
    RecipCount:=1;
    i:=0; Len:=StrLen(S);
    while i<Len-1 do
    begin
      if S[i]=';' then
      begin
        inc(RecipCount); S[i]:=#0;
        while (i<Len) and (S[i+1] in [' ',';']) do   { Skip null entries }
        begin
          inc(i); S[i]:=' ';
        end;
      end;
      inc(i);
    end;
    TotRecip:=TotRecip+RecipCount;
  end;
  GetMem(MailRecip,TotRecip*sizeof(TMAPIRecipDesc));
  FillChar(MailRecip^,TotRecip*sizeof(TMAPIRecipDesc),0);
  MR2:=PChar(MailRecip);
  for j:=1 to 3 do with RParams[j] do if S<>Nil then
  begin
    P:=S;
    for i:=1 to RecipCount do
    begin
      while (P^=' ') do inc(P); 
      with PMAPIRecipDesc(MR2)^ do
      begin
        if j=Ind_To then ulRecipClass:=MAPI_TO
        else if j=Ind_CC  then ulRecipClass:=MAPI_CC
        else if j=Ind_BCC then ulRecipClass:=MAPI_BCC;
        lpszName:=P;
      end;
      if i<RecipCount then MR2:=MR2+sizeof(TMAPIRecipDesc);
      P:=P+StrLen(P)+1;
    end;
  end;
  { Message }
  FillChar(MailMessage,sizeof(MailMessage),0);
  with MailMessage do
  begin
    lpszSubject:=Subj;
    lpszNoteText:=Mess;
    flFlags:=MAPI_SENT;
    nRecipCount:=TotRecip;
    lpRecips:=MailRecip;
  end;
  Flags:=MAPI_LOGON_UI;
  if not Send then FLAGS:=FLAGS or MAPI_DIALOG;

  HyperEx_MailClass := (MAPISendMail(0,0,@MailMessage,Flags,0)=Success_Success);

  FreeMem(MailRecip,TotRecip*sizeof(TMAPIRecipDesc));
  for j:=3 downto 1 do with RParams[j] do
    if S<>Nil then FreeMem(S,SLen+1);
  if Mess <>Nil then StrDispose(Mess);
  if Subj <>Nil then StrDispose(Subj);
end;                  { HyperEx_MailClass }

function HyperEx_RunClass(W: HWnd; Entry: EntryRecPtr; F: PChar): boolean;
var
  i: word;
  Arr: array[-1..256] of char;
  tmp: PString;
  Cmd,PF,Params: Pchar;
begin
  HyperEx_RunClass:=false;
  Cmd:=@Arr[0]; tmp:=PString(@Arr[-1]);
  tmp^:=StrPas(F);
  SubstituteHyper(Entry,tmp^);
  Cmd[length(tmp^)]:=#0;

  PF:=StrScan(Cmd,' '); Params:=Nil;
  if PF<>Nil then
  begin
    Params:=PF+1; PF^:=#0;
    while Params^=' ' do inc(Params);
  end else Params:=Cmd+StrLen(Cmd);
  i:=ShellExecute(W,Nil,Cmd,Params,'.',sw_Show);
{  i:=WinExec(Cmd,sw_Show);}
  if i>32 then HyperEx_RunClass:=true
  else case i of
    1,2,3 : ErrorMessageRC(Str_CantFindApp,'');
    0,8   : ErrorMessageRC(Str_NoMemForApp,'');
    10..15: ErrorMessageRC(Str_InvalidApp,'');
    21    : ErrorMessageRC(Str_AppIs32Bit,'');
    31    : ErrorMessageRC(Str_NoAssociation,StrPas(Cmd));
    else    ErrorMessageRC(Str_ProblemWithApp,num2str(i));
  end;
end;                      { HyperEx_RunClass }

procedure Hyper_UserClassExpand(Entry: EntryRecPtr; Class: integer; F: PChar);
var
  tmp,tmp2,S: Pstring;
  i,j,nbr: integer;

procedure TidyUp;
begin
  Dispose(S); Dispose(tmp2); Dispose(tmp);
end;

begin
  New(tmp); New(tmp2); New(S);
  S^:=StrPas(F);
  tmp^:=HyperTypesArr^[Class].app^; i:=1;
  if Pos('#1',tmp^)=0 then   { No parameters, do nothing }
  else if Pos('#2',tmp^)=0 then StrRepl(tmp^,'#1',S^,1,255,255)  { One parameter }
  else   { Multiple parameters }
    repeat
      if S^='' then tmp2^:=''
      else if (S^[1]<>lbrace) then
      begin
        if i=1 then
        begin
          tmp2^:=S^; S^:='';
        end else
        begin
          ErrorMessageRC(Str_HyperUserError,''); TidyUp; Exit;
        end;
      end else
      begin
        Delete(S^,1,1);
        nbr:=1; j:=1;
        while (j<=length(S^)) and (nbr>0) do
        begin
          if S^[j]=lbrace then inc(nbr) else if S^[j]=rbrace then dec(nbr);
          if nbr>0 then inc(j);
        end;
        if j>length(S^) then
        begin
          ErrorMessageRC(Str_HyperUserError,''); TidyUp; Exit;
        end;
        tmp2^:=Copy(S^,1,j-1); Delete(S^,1,j);
      end;
      StrRepl(tmp^,'#'+num2str(i),tmp2^,1,255,255);
      inc(i);
    until Pos('#'+num2str(i),tmp^)=0;

  SubstituteHyper(Entry,tmp^); StrPCopy(F,tmp^);
  TidyUp;
end;      { Hyper_UserClassExpand }


function HyperEx_HelpClass(Entry: EntryRecPtr; H: HWnd; var S: string): boolean;
var
  F,FL: array[0..255] of char;
  cmd: string;
  i,j,Base: integer;
  l: longint;
begin
  HyperEx_HelpClass:=false;
  SubstituteHyper(Entry,S);
  i:=Pos(',',S); cmd:='';
  if i=0 then   { default }
  begin
    cmd:=S; if Pos('.',cmd)=0 then cmd:=cmd+'.hlp';
    StrPCopy(FL,cmd); cmd:='';
  end else
  begin
    cmd:=Copy(S,1,i-1); if Pos('.',cmd)=0 then cmd:=cmd+'.hlp';
    StrPCopy(FL,cmd); Delete(S,1,i);
    { Commands }
    F[0]:=#0;
    i:=Pos(',',S);
    if i=0 then
    begin
      cmd:=S; S:='';
    end else
    begin
      cmd:=Copy(S,1,i-1); Delete(S,1,i); ChrDelL(S,' ');
    end;
    ChrDel(cmd,' '); StrLwr(cmd);
  end;
  if (cmd='') or (Pos('content',cmd)=1) then
    WinHelp(H,FL,Help_Contents,0)
  else if cmd='search' then
  begin
    StrPCopy(F,S); WinHelp(H,FL,Help_PartialKey,longint(@F))
  end else if cmd='key' then
  begin
    StrPCopy(F,S); WinHelp(H,FL,Help_PartialKey,longint(@F));
  end else if Pos('context',cmd)=1 then
  begin
    ChrDel(S,' ');
    if S='' then
    begin
      ErrorMessageRC(Str_HyperUserError,''); Exit;
    end;
{$IFOPT R+}
  {$DEFINE RPLUS}
{$ELSE}
  {$UNDEF RPLUS}
{$ENDIF}
{$R-}
    Base:=10;
    if S[1]='$' then
    begin
      Delete(S,1,1); Base:=16;
    end else if S[length(S)]='h' then
    begin
      dec(S[0]); Base:=16;
    end else if Pos('0x',S)=1 then
    begin
      Delete(S,1,2); Base:=16;
    end else if S[1]='#' then Delete(S,1,1);
    l:=0; j:=1;
    while j<=length(S) do
    begin
      i:=0;
      if S[j] in ['0'..'9'] then i:=Ord(S[j])-Ord('0')
      else if (Base=16) and (UpCase(S[j]) in ['A'..'F']) then
        i:=Ord(UpCase(S[j]))-Ord('A')+10
      else begin
        ErrorMessageRC(Str_HyperUserError,''); Exit;
      end;
      l:=l*Base+i;
      inc(j);
    end;
{$IFDEF RPLUS}
{$R+}
{$ENDIF} 
    if cmd='context' then
      HyperEx_HelpClass:=WinHelp(H,FL,Help_Context,l)
    else
      HyperEx_HelpClass:=WinHelp(H,FL,Help_ContextPopup,l);
  end else if cmd='command' then
  begin
    StrPCopy(F,S); HyperEx_HelpClass:=WinHelp(H,FL,Help_Command,longint(@F));
  end;

end;               { HyperEx_HelpClass }

end.
